/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnMetadata;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvMetadata;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnMetadataSerializerVer14;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvMetadataVer14
implements OFBsnTlvMetadata {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvMetadataVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 6;
    private final OFBsnMetadata value;
    static final Reader READER = new Reader();
    static final OFBsnTlvMetadataVer14Funnel FUNNEL = new OFBsnTlvMetadataVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvMetadataVer14(OFBsnMetadata value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvMetadataVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 221;
    }

    @Override
    public OFBsnMetadata getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvMetadata.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvMetadataVer14(");
        b.append("value=").append((Object)this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvMetadataVer14 other = (OFBsnTlvMetadataVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvMetadataVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvMetadataVer14 message) {
            bb.writeShort(221);
            bb.writeShort(6);
            OFBsnMetadataSerializerVer14.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvMetadataVer14Funnel
    implements Funnel<OFBsnTlvMetadataVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvMetadataVer14Funnel() {
        }

        public void funnel(OFBsnTlvMetadataVer14 message, PrimitiveSink sink) {
            sink.putShort((short)221);
            sink.putShort((short)6);
            OFBsnMetadataSerializerVer14.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvMetadata> {
        Reader() {
        }

        @Override
        public OFBsnTlvMetadata readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 221) {
                throw new OFParseError("Wrong type: Expected=0xdd(0xdd), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFBsnMetadata value = OFBsnMetadataSerializerVer14.readFrom(bb);
            OFBsnTlvMetadataVer14 bsnTlvMetadataVer14 = new OFBsnTlvMetadataVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvMetadataVer14);
            }
            return bsnTlvMetadataVer14;
        }
    }

    static class Builder
    implements OFBsnTlvMetadata.Builder {
        private boolean valueSet;
        private OFBsnMetadata value;

        Builder() {
        }

        @Override
        public int getType() {
            return 221;
        }

        @Override
        public OFBsnMetadata getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvMetadata.Builder setValue(OFBsnMetadata value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvMetadata build() {
            if (!this.valueSet) {
                throw new IllegalStateException("Property value doesn't have default value -- must be set");
            }
            if (this.value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvMetadataVer14(this.value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvMetadata.Builder {
        final OFBsnTlvMetadataVer14 parentMessage;
        private boolean valueSet;
        private OFBsnMetadata value;

        BuilderWithParent(OFBsnTlvMetadataVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 221;
        }

        @Override
        public OFBsnMetadata getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvMetadata.Builder setValue(OFBsnMetadata value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvMetadata build() {
            OFBsnMetadata value;
            OFBsnMetadata oFBsnMetadata = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvMetadataVer14(value);
        }
    }
}

