/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvIpv6Prefix;
import org.projectfloodlight.openflow.types.IPv6Address;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvIpv6PrefixVer14
implements OFBsnTlvIpv6Prefix {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvIpv6PrefixVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 21;
    private static final IPv6Address DEFAULT_VALUE = IPv6Address.NONE;
    private static final short DEFAULT_PREFIX_LENGTH = 0;
    private final IPv6Address value;
    private final short prefixLength;
    static final OFBsnTlvIpv6PrefixVer14 DEFAULT = new OFBsnTlvIpv6PrefixVer14(DEFAULT_VALUE, 0);
    static final Reader READER = new Reader();
    static final OFBsnTlvIpv6PrefixVer14Funnel FUNNEL = new OFBsnTlvIpv6PrefixVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvIpv6PrefixVer14(IPv6Address value, short prefixLength) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvIpv6PrefixVer14: property value cannot be null");
        }
        this.value = value;
        this.prefixLength = U8.normalize(prefixLength);
    }

    @Override
    public int getType() {
        return 122;
    }

    @Override
    public IPv6Address getValue() {
        return this.value;
    }

    @Override
    public short getPrefixLength() {
        return this.prefixLength;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvIpv6Prefix.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvIpv6PrefixVer14(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("prefixLength=").append(this.prefixLength);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvIpv6PrefixVer14 other = (OFBsnTlvIpv6PrefixVer14)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return this.prefixLength == other.prefixLength;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + this.prefixLength;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvIpv6PrefixVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvIpv6PrefixVer14 message) {
            bb.writeShort(122);
            bb.writeShort(21);
            message.value.write16Bytes(bb);
            bb.writeByte((int)U8.t(message.prefixLength));
        }
    }

    static class OFBsnTlvIpv6PrefixVer14Funnel
    implements Funnel<OFBsnTlvIpv6PrefixVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvIpv6PrefixVer14Funnel() {
        }

        public void funnel(OFBsnTlvIpv6PrefixVer14 message, PrimitiveSink sink) {
            sink.putShort((short)122);
            sink.putShort((short)21);
            message.value.putTo(sink);
            sink.putShort(message.prefixLength);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvIpv6Prefix> {
        Reader() {
        }

        @Override
        public OFBsnTlvIpv6Prefix readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 122) {
                throw new OFParseError("Wrong type: Expected=0x7a(0x7a), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 21) {
                throw new OFParseError("Wrong length: Expected=21(21), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            IPv6Address value = IPv6Address.read16Bytes(bb);
            short prefixLength = U8.f(bb.readByte());
            OFBsnTlvIpv6PrefixVer14 bsnTlvIpv6PrefixVer14 = new OFBsnTlvIpv6PrefixVer14(value, prefixLength);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvIpv6PrefixVer14);
            }
            return bsnTlvIpv6PrefixVer14;
        }
    }

    static class Builder
    implements OFBsnTlvIpv6Prefix.Builder {
        private boolean valueSet;
        private IPv6Address value;
        private boolean prefixLengthSet;
        private short prefixLength;

        Builder() {
        }

        @Override
        public int getType() {
            return 122;
        }

        @Override
        public IPv6Address getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvIpv6Prefix.Builder setValue(IPv6Address value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public short getPrefixLength() {
            return this.prefixLength;
        }

        @Override
        public OFBsnTlvIpv6Prefix.Builder setPrefixLength(short prefixLength) {
            this.prefixLength = prefixLength;
            this.prefixLengthSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvIpv6Prefix build() {
            IPv6Address value;
            IPv6Address iPv6Address = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            short prefixLength = this.prefixLengthSet ? this.prefixLength : (short)0;
            return new OFBsnTlvIpv6PrefixVer14(value, prefixLength);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvIpv6Prefix.Builder {
        final OFBsnTlvIpv6PrefixVer14 parentMessage;
        private boolean valueSet;
        private IPv6Address value;
        private boolean prefixLengthSet;
        private short prefixLength;

        BuilderWithParent(OFBsnTlvIpv6PrefixVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 122;
        }

        @Override
        public IPv6Address getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvIpv6Prefix.Builder setValue(IPv6Address value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public short getPrefixLength() {
            return this.prefixLength;
        }

        @Override
        public OFBsnTlvIpv6Prefix.Builder setPrefixLength(short prefixLength) {
            this.prefixLength = prefixLength;
            this.prefixLengthSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvIpv6Prefix build() {
            IPv6Address value;
            IPv6Address iPv6Address = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            short prefixLength = this.prefixLengthSet ? this.prefixLength : this.parentMessage.prefixLength;
            return new OFBsnTlvIpv6PrefixVer14(value, prefixLength);
        }
    }
}

