/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvArpTpa;
import org.projectfloodlight.openflow.types.IPv4Address;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvArpTpaVer14
implements OFBsnTlvArpTpa {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvArpTpaVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 8;
    private static final IPv4Address DEFAULT_VALUE = IPv4Address.NONE;
    private final IPv4Address value;
    static final OFBsnTlvArpTpaVer14 DEFAULT = new OFBsnTlvArpTpaVer14(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvArpTpaVer14Funnel FUNNEL = new OFBsnTlvArpTpaVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvArpTpaVer14(IPv4Address value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvArpTpaVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 198;
    }

    @Override
    public IPv4Address getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvArpTpa.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvArpTpaVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvArpTpaVer14 other = (OFBsnTlvArpTpaVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvArpTpaVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvArpTpaVer14 message) {
            bb.writeShort(198);
            bb.writeShort(8);
            message.value.write4Bytes(bb);
        }
    }

    static class OFBsnTlvArpTpaVer14Funnel
    implements Funnel<OFBsnTlvArpTpaVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvArpTpaVer14Funnel() {
        }

        public void funnel(OFBsnTlvArpTpaVer14 message, PrimitiveSink sink) {
            sink.putShort((short)198);
            sink.putShort((short)8);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvArpTpa> {
        Reader() {
        }

        @Override
        public OFBsnTlvArpTpa readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 198) {
                throw new OFParseError("Wrong type: Expected=0xc6(0xc6), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            IPv4Address value = IPv4Address.read4Bytes(bb);
            OFBsnTlvArpTpaVer14 bsnTlvArpTpaVer14 = new OFBsnTlvArpTpaVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvArpTpaVer14);
            }
            return bsnTlvArpTpaVer14;
        }
    }

    static class Builder
    implements OFBsnTlvArpTpa.Builder {
        private boolean valueSet;
        private IPv4Address value;

        Builder() {
        }

        @Override
        public int getType() {
            return 198;
        }

        @Override
        public IPv4Address getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvArpTpa.Builder setValue(IPv4Address value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvArpTpa build() {
            IPv4Address value;
            IPv4Address iPv4Address = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvArpTpaVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvArpTpa.Builder {
        final OFBsnTlvArpTpaVer14 parentMessage;
        private boolean valueSet;
        private IPv4Address value;

        BuilderWithParent(OFBsnTlvArpTpaVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 198;
        }

        @Override
        public IPv4Address getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvArpTpa.Builder setValue(IPv4Address value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvArpTpa build() {
            IPv4Address value;
            IPv4Address iPv4Address = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvArpTpaVer14(value);
        }
    }
}

