/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnAdminState;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvAdminState;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnAdminStateSerializerVer14;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvAdminStateVer14
implements OFBsnTlvAdminState {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvAdminStateVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 5;
    private final OFBsnAdminState value;
    static final Reader READER = new Reader();
    static final OFBsnTlvAdminStateVer14Funnel FUNNEL = new OFBsnTlvAdminStateVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvAdminStateVer14(OFBsnAdminState value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvAdminStateVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 216;
    }

    @Override
    public OFBsnAdminState getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvAdminState.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvAdminStateVer14(");
        b.append("value=").append((Object)this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvAdminStateVer14 other = (OFBsnTlvAdminStateVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvAdminStateVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvAdminStateVer14 message) {
            bb.writeShort(216);
            bb.writeShort(5);
            OFBsnAdminStateSerializerVer14.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvAdminStateVer14Funnel
    implements Funnel<OFBsnTlvAdminStateVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvAdminStateVer14Funnel() {
        }

        public void funnel(OFBsnTlvAdminStateVer14 message, PrimitiveSink sink) {
            sink.putShort((short)216);
            sink.putShort((short)5);
            OFBsnAdminStateSerializerVer14.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvAdminState> {
        Reader() {
        }

        @Override
        public OFBsnTlvAdminState readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 216) {
                throw new OFParseError("Wrong type: Expected=0xd8(0xd8), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 5) {
                throw new OFParseError("Wrong length: Expected=5(5), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFBsnAdminState value = OFBsnAdminStateSerializerVer14.readFrom(bb);
            OFBsnTlvAdminStateVer14 bsnTlvAdminStateVer14 = new OFBsnTlvAdminStateVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvAdminStateVer14);
            }
            return bsnTlvAdminStateVer14;
        }
    }

    static class Builder
    implements OFBsnTlvAdminState.Builder {
        private boolean valueSet;
        private OFBsnAdminState value;

        Builder() {
        }

        @Override
        public int getType() {
            return 216;
        }

        @Override
        public OFBsnAdminState getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvAdminState.Builder setValue(OFBsnAdminState value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvAdminState build() {
            if (!this.valueSet) {
                throw new IllegalStateException("Property value doesn't have default value -- must be set");
            }
            if (this.value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvAdminStateVer14(this.value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvAdminState.Builder {
        final OFBsnTlvAdminStateVer14 parentMessage;
        private boolean valueSet;
        private OFBsnAdminState value;

        BuilderWithParent(OFBsnTlvAdminStateVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 216;
        }

        @Override
        public OFBsnAdminState getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvAdminState.Builder setValue(OFBsnAdminState value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvAdminState build() {
            OFBsnAdminState value;
            OFBsnAdminState oFBsnAdminState = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvAdminStateVer14(value);
        }
    }
}

