/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnTableSetBucketsSize;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.TableId;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTableSetBucketsSizeVer14
implements OFBsnTableSetBucketsSize {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTableSetBucketsSizeVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 24;
    private static final long DEFAULT_XID = 0L;
    private static final TableId DEFAULT_TABLE_ID = TableId.ALL;
    private static final long DEFAULT_BUCKETS_SIZE = 0L;
    private final long xid;
    private final TableId tableId;
    private final long bucketsSize;
    static final OFBsnTableSetBucketsSizeVer14 DEFAULT = new OFBsnTableSetBucketsSizeVer14(0L, DEFAULT_TABLE_ID, 0L);
    static final Reader READER = new Reader();
    static final OFBsnTableSetBucketsSizeVer14Funnel FUNNEL = new OFBsnTableSetBucketsSizeVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTableSetBucketsSizeVer14(long xid, TableId tableId, long bucketsSize) {
        if (tableId == null) {
            throw new NullPointerException("OFBsnTableSetBucketsSizeVer14: property tableId cannot be null");
        }
        this.xid = U32.normalize(xid);
        this.tableId = tableId;
        this.bucketsSize = U32.normalize(bucketsSize);
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 61L;
    }

    @Override
    public TableId getTableId() {
        return this.tableId;
    }

    @Override
    public long getBucketsSize() {
        return this.bucketsSize;
    }

    @Override
    public OFBsnTableSetBucketsSize.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTableSetBucketsSizeVer14(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("tableId=").append(this.tableId);
        b.append(", ");
        b.append("bucketsSize=").append(this.bucketsSize);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTableSetBucketsSizeVer14 other = (OFBsnTableSetBucketsSizeVer14)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.tableId == null ? other.tableId != null : !this.tableId.equals(other.tableId)) {
            return false;
        }
        return this.bucketsSize == other.bucketsSize;
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTableSetBucketsSizeVer14 other = (OFBsnTableSetBucketsSizeVer14)obj;
        if (this.tableId == null ? other.tableId != null : !this.tableId.equals(other.tableId)) {
            return false;
        }
        return this.bucketsSize == other.bucketsSize;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.tableId == null ? 0 : this.tableId.hashCode());
        result = 31 * (int)(this.bucketsSize ^ this.bucketsSize >>> 32);
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tableId == null ? 0 : this.tableId.hashCode());
        result = 31 * (int)(this.bucketsSize ^ this.bucketsSize >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTableSetBucketsSizeVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTableSetBucketsSizeVer14 message) {
            bb.writeByte(5);
            bb.writeByte(4);
            bb.writeShort(24);
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(61);
            bb.writeZero(1);
            message.tableId.writeByte(bb);
            bb.writeZero(2);
            bb.writeInt(U32.t(message.bucketsSize));
        }
    }

    static class OFBsnTableSetBucketsSizeVer14Funnel
    implements Funnel<OFBsnTableSetBucketsSizeVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTableSetBucketsSizeVer14Funnel() {
        }

        public void funnel(OFBsnTableSetBucketsSizeVer14 message, PrimitiveSink sink) {
            sink.putByte((byte)5);
            sink.putByte((byte)4);
            sink.putShort((short)24);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(61);
            message.tableId.putTo(sink);
            sink.putLong(message.bucketsSize);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTableSetBucketsSize> {
        Reader() {
        }

        @Override
        public OFBsnTableSetBucketsSize readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 5) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_14(5), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 24) {
                throw new OFParseError("Wrong length: Expected=24(24), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 61) {
                throw new OFParseError("Wrong subtype: Expected=0x3dL(0x3dL), got=" + subtype);
            }
            bb.skipBytes(1);
            TableId tableId = TableId.readByte(bb);
            bb.skipBytes(2);
            long bucketsSize = U32.f(bb.readInt());
            OFBsnTableSetBucketsSizeVer14 bsnTableSetBucketsSizeVer14 = new OFBsnTableSetBucketsSizeVer14(xid, tableId, bucketsSize);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTableSetBucketsSizeVer14);
            }
            return bsnTableSetBucketsSizeVer14;
        }
    }

    static class Builder
    implements OFBsnTableSetBucketsSize.Builder {
        private boolean xidSet;
        private long xid;
        private boolean tableIdSet;
        private TableId tableId;
        private boolean bucketsSizeSet;
        private long bucketsSize;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnTableSetBucketsSize.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 61L;
        }

        @Override
        public TableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFBsnTableSetBucketsSize.Builder setTableId(TableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public long getBucketsSize() {
            return this.bucketsSize;
        }

        @Override
        public OFBsnTableSetBucketsSize.Builder setBucketsSize(long bucketsSize) {
            this.bucketsSize = bucketsSize;
            this.bucketsSizeSet = true;
            return this;
        }

        @Override
        public OFBsnTableSetBucketsSize build() {
            TableId tableId;
            long xid = this.xidSet ? this.xid : 0L;
            TableId tableId2 = tableId = this.tableIdSet ? this.tableId : DEFAULT_TABLE_ID;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            long bucketsSize = this.bucketsSizeSet ? this.bucketsSize : 0L;
            return new OFBsnTableSetBucketsSizeVer14(xid, tableId, bucketsSize);
        }
    }

    static class BuilderWithParent
    implements OFBsnTableSetBucketsSize.Builder {
        final OFBsnTableSetBucketsSizeVer14 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean tableIdSet;
        private TableId tableId;
        private boolean bucketsSizeSet;
        private long bucketsSize;

        BuilderWithParent(OFBsnTableSetBucketsSizeVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnTableSetBucketsSize.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 61L;
        }

        @Override
        public TableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFBsnTableSetBucketsSize.Builder setTableId(TableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public long getBucketsSize() {
            return this.bucketsSize;
        }

        @Override
        public OFBsnTableSetBucketsSize.Builder setBucketsSize(long bucketsSize) {
            this.bucketsSize = bucketsSize;
            this.bucketsSizeSet = true;
            return this;
        }

        @Override
        public OFBsnTableSetBucketsSize build() {
            TableId tableId;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            TableId tableId2 = tableId = this.tableIdSet ? this.tableId : this.parentMessage.tableId;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            long bucketsSize = this.bucketsSizeSet ? this.bucketsSize : this.parentMessage.bucketsSize;
            return new OFBsnTableSetBucketsSizeVer14(xid, tableId, bucketsSize);
        }
    }
}

