/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFAsyncConfigPropRequestforwardSlave;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFAsyncConfigPropRequestforwardSlaveVer14
implements OFAsyncConfigPropRequestforwardSlave {
    private static final Logger logger = LoggerFactory.getLogger(OFAsyncConfigPropRequestforwardSlaveVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 8;
    private static final long DEFAULT_MASK = 0L;
    private final long mask;
    static final OFAsyncConfigPropRequestforwardSlaveVer14 DEFAULT = new OFAsyncConfigPropRequestforwardSlaveVer14(0L);
    static final Reader READER = new Reader();
    static final OFAsyncConfigPropRequestforwardSlaveVer14Funnel FUNNEL = new OFAsyncConfigPropRequestforwardSlaveVer14Funnel();
    static final Writer WRITER = new Writer();

    OFAsyncConfigPropRequestforwardSlaveVer14(long mask) {
        this.mask = U32.normalize(mask);
    }

    @Override
    public int getType() {
        return 10;
    }

    @Override
    public long getMask() {
        return this.mask;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFAsyncConfigPropRequestforwardSlave.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFAsyncConfigPropRequestforwardSlaveVer14(");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFAsyncConfigPropRequestforwardSlaveVer14 other = (OFAsyncConfigPropRequestforwardSlaveVer14)obj;
        return this.mask == other.mask;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.mask ^ this.mask >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFAsyncConfigPropRequestforwardSlaveVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFAsyncConfigPropRequestforwardSlaveVer14 message) {
            bb.writeShort(10);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.mask));
        }
    }

    static class OFAsyncConfigPropRequestforwardSlaveVer14Funnel
    implements Funnel<OFAsyncConfigPropRequestforwardSlaveVer14> {
        private static final long serialVersionUID = 1L;

        OFAsyncConfigPropRequestforwardSlaveVer14Funnel() {
        }

        public void funnel(OFAsyncConfigPropRequestforwardSlaveVer14 message, PrimitiveSink sink) {
            sink.putShort((short)10);
            sink.putShort((short)8);
            sink.putLong(message.mask);
        }
    }

    static class Reader
    implements OFMessageReader<OFAsyncConfigPropRequestforwardSlave> {
        Reader() {
        }

        @Override
        public OFAsyncConfigPropRequestforwardSlave readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 10) {
                throw new OFParseError("Wrong type: Expected=0xa(0xa), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long mask = U32.f(bb.readInt());
            OFAsyncConfigPropRequestforwardSlaveVer14 asyncConfigPropRequestforwardSlaveVer14 = new OFAsyncConfigPropRequestforwardSlaveVer14(mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)asyncConfigPropRequestforwardSlaveVer14);
            }
            return asyncConfigPropRequestforwardSlaveVer14;
        }
    }

    static class Builder
    implements OFAsyncConfigPropRequestforwardSlave.Builder {
        private boolean maskSet;
        private long mask;

        Builder() {
        }

        @Override
        public int getType() {
            return 10;
        }

        @Override
        public long getMask() {
            return this.mask;
        }

        @Override
        public OFAsyncConfigPropRequestforwardSlave.Builder setMask(long mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFAsyncConfigPropRequestforwardSlave build() {
            long mask = this.maskSet ? this.mask : 0L;
            return new OFAsyncConfigPropRequestforwardSlaveVer14(mask);
        }
    }

    static class BuilderWithParent
    implements OFAsyncConfigPropRequestforwardSlave.Builder {
        final OFAsyncConfigPropRequestforwardSlaveVer14 parentMessage;
        private boolean maskSet;
        private long mask;

        BuilderWithParent(OFAsyncConfigPropRequestforwardSlaveVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 10;
        }

        @Override
        public long getMask() {
            return this.mask;
        }

        @Override
        public OFAsyncConfigPropRequestforwardSlave.Builder setMask(long mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFAsyncConfigPropRequestforwardSlave build() {
            long mask = this.maskSet ? this.mask : this.parentMessage.mask;
            return new OFAsyncConfigPropRequestforwardSlaveVer14(mask);
        }
    }
}

