/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFTableFeaturePropInstructions;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.instructionid.OFInstructionId;
import org.projectfloodlight.openflow.protocol.ver13.OFInstructionIdVer13;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFTableFeaturePropInstructionsVer13
implements OFTableFeaturePropInstructions {
    private static final Logger logger = LoggerFactory.getLogger(OFTableFeaturePropInstructionsVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 4;
    static final int MAXIMUM_LENGTH = 65535;
    private static final List<OFInstructionId> DEFAULT_INSTRUCTION_IDS = ImmutableList.of();
    private final List<OFInstructionId> instructionIds;
    static final OFTableFeaturePropInstructionsVer13 DEFAULT = new OFTableFeaturePropInstructionsVer13(DEFAULT_INSTRUCTION_IDS);
    static final Reader READER = new Reader();
    static final OFTableFeaturePropInstructionsVer13Funnel FUNNEL = new OFTableFeaturePropInstructionsVer13Funnel();
    static final Writer WRITER = new Writer();

    OFTableFeaturePropInstructionsVer13(List<OFInstructionId> instructionIds) {
        if (instructionIds == null) {
            throw new NullPointerException("OFTableFeaturePropInstructionsVer13: property instructionIds cannot be null");
        }
        this.instructionIds = instructionIds;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public List<OFInstructionId> getInstructionIds() {
        return this.instructionIds;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFTableFeaturePropInstructions.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFTableFeaturePropInstructionsVer13(");
        b.append("instructionIds=").append(this.instructionIds);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFTableFeaturePropInstructionsVer13 other = (OFTableFeaturePropInstructionsVer13)obj;
        return !(this.instructionIds == null ? other.instructionIds != null : !this.instructionIds.equals(other.instructionIds));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.instructionIds == null ? 0 : this.instructionIds.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFTableFeaturePropInstructionsVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFTableFeaturePropInstructionsVer13 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(0);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            ChannelUtils.writeList(bb, message.instructionIds);
            int length = bb.writerIndex() - startIndex;
            int alignedLength = (length + 7) / 8 * 8;
            if (length > 65535) {
                throw new IllegalArgumentException("OFTableFeaturePropInstructionsVer13: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);
            bb.writeZero(alignedLength - length);
        }
    }

    static class OFTableFeaturePropInstructionsVer13Funnel
    implements Funnel<OFTableFeaturePropInstructionsVer13> {
        private static final long serialVersionUID = 1L;

        OFTableFeaturePropInstructionsVer13Funnel() {
        }

        public void funnel(OFTableFeaturePropInstructionsVer13 message, PrimitiveSink sink) {
            sink.putShort((short)0);
            FunnelUtils.putList(message.instructionIds, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFTableFeaturePropInstructions> {
        Reader() {
        }

        @Override
        public OFTableFeaturePropInstructions readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 0) {
                throw new OFParseError("Wrong type: Expected=0x0(0x0), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 4) {
                throw new OFParseError("Wrong length: Expected to be >= 4, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            List<OFInstructionId> instructionIds = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFInstructionIdVer13.READER);
            bb.skipBytes((length + 7) / 8 * 8 - length);
            OFTableFeaturePropInstructionsVer13 tableFeaturePropInstructionsVer13 = new OFTableFeaturePropInstructionsVer13(instructionIds);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)tableFeaturePropInstructionsVer13);
            }
            return tableFeaturePropInstructionsVer13;
        }
    }

    static class Builder
    implements OFTableFeaturePropInstructions.Builder {
        private boolean instructionIdsSet;
        private List<OFInstructionId> instructionIds;

        Builder() {
        }

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public List<OFInstructionId> getInstructionIds() {
            return this.instructionIds;
        }

        @Override
        public OFTableFeaturePropInstructions.Builder setInstructionIds(List<OFInstructionId> instructionIds) {
            this.instructionIds = instructionIds;
            this.instructionIdsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFTableFeaturePropInstructions build() {
            List<OFInstructionId> instructionIds;
            List<OFInstructionId> list = instructionIds = this.instructionIdsSet ? this.instructionIds : DEFAULT_INSTRUCTION_IDS;
            if (instructionIds == null) {
                throw new NullPointerException("Property instructionIds must not be null");
            }
            return new OFTableFeaturePropInstructionsVer13(instructionIds);
        }
    }

    static class BuilderWithParent
    implements OFTableFeaturePropInstructions.Builder {
        final OFTableFeaturePropInstructionsVer13 parentMessage;
        private boolean instructionIdsSet;
        private List<OFInstructionId> instructionIds;

        BuilderWithParent(OFTableFeaturePropInstructionsVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public List<OFInstructionId> getInstructionIds() {
            return this.instructionIds;
        }

        @Override
        public OFTableFeaturePropInstructions.Builder setInstructionIds(List<OFInstructionId> instructionIds) {
            this.instructionIds = instructionIds;
            this.instructionIdsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFTableFeaturePropInstructions build() {
            List instructionIds;
            List list = instructionIds = this.instructionIdsSet ? this.instructionIds : this.parentMessage.instructionIds;
            if (instructionIds == null) {
                throw new NullPointerException("Property instructionIds must not be null");
            }
            return new OFTableFeaturePropInstructionsVer13(instructionIds);
        }
    }
}

