/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmConnTrackingNwDstMasked;
import org.projectfloodlight.openflow.protocol.ver13.OFOxmConnTrackingNwDstVer13;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmConnTrackingNwDstMaskedVer13
implements OFOxmConnTrackingNwDstMasked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmConnTrackingNwDstMaskedVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 12;
    private static final U32 DEFAULT_VALUE = U32.ZERO;
    private static final U32 DEFAULT_VALUE_MASK = U32.ZERO;
    private final U32 value;
    private final U32 mask;
    static final OFOxmConnTrackingNwDstMaskedVer13 DEFAULT = new OFOxmConnTrackingNwDstMaskedVer13(DEFAULT_VALUE, DEFAULT_VALUE_MASK);
    static final Reader READER = new Reader();
    static final OFOxmConnTrackingNwDstMaskedVer13Funnel FUNNEL = new OFOxmConnTrackingNwDstMaskedVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmConnTrackingNwDstMaskedVer13(U32 value, U32 mask) {
        if (value == null) {
            throw new NullPointerException("OFOxmConnTrackingNwDstMaskedVer13: property value cannot be null");
        }
        if (mask == null) {
            throw new NullPointerException("OFOxmConnTrackingNwDstMaskedVer13: property mask cannot be null");
        }
        this.value = value;
        this.mask = mask;
    }

    @Override
    public long getTypeLen() {
        return 127752L;
    }

    @Override
    public U32 getValue() {
        return this.value;
    }

    @Override
    public U32 getMask() {
        return this.mask;
    }

    @Override
    public MatchField<U32> getMatchField() {
        return MatchField.CONN_TRACKING_NW_DST;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<U32> getCanonical() {
        if (U32.NO_MASK.equals(this.mask)) {
            return new OFOxmConnTrackingNwDstVer13(this.value);
        }
        if (U32.FULL_MASK.equals(this.mask)) {
            return null;
        }
        return this;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmConnTrackingNwDstMasked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmConnTrackingNwDstMaskedVer13(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmConnTrackingNwDstMaskedVer13 other = (OFOxmConnTrackingNwDstMaskedVer13)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.mask == null ? other.mask != null : !this.mask.equals(other.mask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmConnTrackingNwDstMaskedVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmConnTrackingNwDstMaskedVer13 message) {
            bb.writeInt(127752);
            bb.writeInt(message.value.getRaw());
            bb.writeInt(message.mask.getRaw());
        }
    }

    static class OFOxmConnTrackingNwDstMaskedVer13Funnel
    implements Funnel<OFOxmConnTrackingNwDstMaskedVer13> {
        private static final long serialVersionUID = 1L;

        OFOxmConnTrackingNwDstMaskedVer13Funnel() {
        }

        public void funnel(OFOxmConnTrackingNwDstMaskedVer13 message, PrimitiveSink sink) {
            sink.putInt(127752);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmConnTrackingNwDstMasked> {
        Reader() {
        }

        @Override
        public OFOxmConnTrackingNwDstMasked readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 127752) {
                throw new OFParseError("Wrong typeLen: Expected=0x1f308L(0x1f308L), got=" + typeLen);
            }
            U32 value = U32.of(bb.readInt());
            U32 mask = U32.of(bb.readInt());
            OFOxmConnTrackingNwDstMaskedVer13 oxmConnTrackingNwDstMaskedVer13 = new OFOxmConnTrackingNwDstMaskedVer13(value, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmConnTrackingNwDstMaskedVer13);
            }
            return oxmConnTrackingNwDstMaskedVer13;
        }
    }

    static class Builder
    implements OFOxmConnTrackingNwDstMasked.Builder {
        private boolean valueSet;
        private U32 value;
        private boolean maskSet;
        private U32 mask;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 127752L;
        }

        @Override
        public U32 getValue() {
            return this.value;
        }

        @Override
        public OFOxmConnTrackingNwDstMasked.Builder setValue(U32 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public U32 getMask() {
            return this.mask;
        }

        @Override
        public OFOxmConnTrackingNwDstMasked.Builder setMask(U32 mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<U32> getMatchField() {
            return MatchField.CONN_TRACKING_NW_DST;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<U32> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmConnTrackingNwDstMasked build() {
            U32 mask;
            U32 value;
            U32 u32 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            U32 u322 = mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmConnTrackingNwDstMaskedVer13(value, mask);
        }
    }

    static class BuilderWithParent
    implements OFOxmConnTrackingNwDstMasked.Builder {
        final OFOxmConnTrackingNwDstMaskedVer13 parentMessage;
        private boolean valueSet;
        private U32 value;
        private boolean maskSet;
        private U32 mask;

        BuilderWithParent(OFOxmConnTrackingNwDstMaskedVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 127752L;
        }

        @Override
        public U32 getValue() {
            return this.value;
        }

        @Override
        public OFOxmConnTrackingNwDstMasked.Builder setValue(U32 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public U32 getMask() {
            return this.mask;
        }

        @Override
        public OFOxmConnTrackingNwDstMasked.Builder setMask(U32 mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<U32> getMatchField() {
            return MatchField.CONN_TRACKING_NW_DST;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<U32> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmConnTrackingNwDstMasked build() {
            U32 mask;
            U32 value;
            U32 u32 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            U32 u322 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmConnTrackingNwDstMaskedVer13(value, mask);
        }
    }
}

