/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmBsnTcpFlagsMasked;
import org.projectfloodlight.openflow.protocol.ver13.OFOxmBsnTcpFlagsVer13;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmBsnTcpFlagsMaskedVer13
implements OFOxmBsnTcpFlagsMasked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmBsnTcpFlagsMaskedVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final U16 DEFAULT_VALUE = U16.ZERO;
    private static final U16 DEFAULT_VALUE_MASK = U16.ZERO;
    private final U16 value;
    private final U16 mask;
    static final OFOxmBsnTcpFlagsMaskedVer13 DEFAULT = new OFOxmBsnTcpFlagsMaskedVer13(DEFAULT_VALUE, DEFAULT_VALUE_MASK);
    static final Reader READER = new Reader();
    static final OFOxmBsnTcpFlagsMaskedVer13Funnel FUNNEL = new OFOxmBsnTcpFlagsMaskedVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmBsnTcpFlagsMaskedVer13(U16 value, U16 mask) {
        if (value == null) {
            throw new NullPointerException("OFOxmBsnTcpFlagsMaskedVer13: property value cannot be null");
        }
        if (mask == null) {
            throw new NullPointerException("OFOxmBsnTcpFlagsMaskedVer13: property mask cannot be null");
        }
        this.value = value;
        this.mask = mask;
    }

    @Override
    public long getTypeLen() {
        return 205060L;
    }

    @Override
    public U16 getValue() {
        return this.value;
    }

    @Override
    public U16 getMask() {
        return this.mask;
    }

    @Override
    public MatchField<U16> getMatchField() {
        return MatchField.BSN_TCP_FLAGS;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<U16> getCanonical() {
        if (U16.NO_MASK.equals(this.mask)) {
            return new OFOxmBsnTcpFlagsVer13(this.value);
        }
        if (U16.FULL_MASK.equals(this.mask)) {
            return null;
        }
        return this;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmBsnTcpFlagsMasked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmBsnTcpFlagsMaskedVer13(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmBsnTcpFlagsMaskedVer13 other = (OFOxmBsnTcpFlagsMaskedVer13)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.mask == null ? other.mask != null : !this.mask.equals(other.mask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmBsnTcpFlagsMaskedVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmBsnTcpFlagsMaskedVer13 message) {
            bb.writeInt(205060);
            bb.writeShort((int)message.value.getRaw());
            bb.writeShort((int)message.mask.getRaw());
        }
    }

    static class OFOxmBsnTcpFlagsMaskedVer13Funnel
    implements Funnel<OFOxmBsnTcpFlagsMaskedVer13> {
        private static final long serialVersionUID = 1L;

        OFOxmBsnTcpFlagsMaskedVer13Funnel() {
        }

        public void funnel(OFOxmBsnTcpFlagsMaskedVer13 message, PrimitiveSink sink) {
            sink.putInt(205060);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmBsnTcpFlagsMasked> {
        Reader() {
        }

        @Override
        public OFOxmBsnTcpFlagsMasked readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 205060) {
                throw new OFParseError("Wrong typeLen: Expected=0x32104L(0x32104L), got=" + typeLen);
            }
            U16 value = U16.of(bb.readShort());
            U16 mask = U16.of(bb.readShort());
            OFOxmBsnTcpFlagsMaskedVer13 oxmBsnTcpFlagsMaskedVer13 = new OFOxmBsnTcpFlagsMaskedVer13(value, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmBsnTcpFlagsMaskedVer13);
            }
            return oxmBsnTcpFlagsMaskedVer13;
        }
    }

    static class Builder
    implements OFOxmBsnTcpFlagsMasked.Builder {
        private boolean valueSet;
        private U16 value;
        private boolean maskSet;
        private U16 mask;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 205060L;
        }

        @Override
        public U16 getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnTcpFlagsMasked.Builder setValue(U16 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public U16 getMask() {
            return this.mask;
        }

        @Override
        public OFOxmBsnTcpFlagsMasked.Builder setMask(U16 mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<U16> getMatchField() {
            return MatchField.BSN_TCP_FLAGS;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<U16> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmBsnTcpFlagsMasked build() {
            U16 mask;
            U16 value;
            U16 u16 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            U16 u162 = mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmBsnTcpFlagsMaskedVer13(value, mask);
        }
    }

    static class BuilderWithParent
    implements OFOxmBsnTcpFlagsMasked.Builder {
        final OFOxmBsnTcpFlagsMaskedVer13 parentMessage;
        private boolean valueSet;
        private U16 value;
        private boolean maskSet;
        private U16 mask;

        BuilderWithParent(OFOxmBsnTcpFlagsMaskedVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 205060L;
        }

        @Override
        public U16 getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnTcpFlagsMasked.Builder setValue(U16 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public U16 getMask() {
            return this.mask;
        }

        @Override
        public OFOxmBsnTcpFlagsMasked.Builder setMask(U16 mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<U16> getMatchField() {
            return MatchField.BSN_TCP_FLAGS;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<U16> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmBsnTcpFlagsMasked build() {
            U16 mask;
            U16 value;
            U16 u16 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            U16 u162 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmBsnTcpFlagsMaskedVer13(value, mask);
        }
    }
}

