/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.instruction.OFInstruction;
import org.projectfloodlight.openflow.protocol.ver13.OFInstructionApplyActionsVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFInstructionClearActionsVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFInstructionExperimenterVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFInstructionGotoTableVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFInstructionMeterVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFInstructionWriteActionsVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFInstructionWriteMetadataVer13;

abstract class OFInstructionVer13 {
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 4;
    public static final Reader READER = new Reader();

    OFInstructionVer13() {
    }

    static class Reader
    implements OFMessageReader<OFInstruction> {
        Reader() {
        }

        @Override
        public OFInstruction readFrom(ByteBuf bb) throws OFParseError {
            if (bb.readableBytes() < 4) {
                return null;
            }
            int start = bb.readerIndex();
            short type = bb.readShort();
            bb.readerIndex(start);
            switch (type) {
                case 4: {
                    return OFInstructionApplyActionsVer13.READER.readFrom(bb);
                }
                case 5: {
                    return OFInstructionClearActionsVer13.READER.readFrom(bb);
                }
                case -1: {
                    return OFInstructionExperimenterVer13.READER.readFrom(bb);
                }
                case 1: {
                    return OFInstructionGotoTableVer13.READER.readFrom(bb);
                }
                case 3: {
                    return OFInstructionWriteActionsVer13.READER.readFrom(bb);
                }
                case 2: {
                    return OFInstructionWriteMetadataVer13.READER.readFrom(bb);
                }
                case 6: {
                    return OFInstructionMeterVer13.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator type of class OFInstructionVer13: " + type);
        }
    }
}

