/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFCapabilities;
import org.projectfloodlight.openflow.protocol.OFFeaturesReply;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPortDesc;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver13.OFCapabilitiesSerializerVer13;
import org.projectfloodlight.openflow.types.DatapathId;
import org.projectfloodlight.openflow.types.OFAuxId;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFFeaturesReplyVer13
implements OFFeaturesReply {
    private static final Logger logger = LoggerFactory.getLogger(OFFeaturesReplyVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 32;
    private static final long DEFAULT_XID = 0L;
    private static final DatapathId DEFAULT_DATAPATH_ID = DatapathId.NONE;
    private static final long DEFAULT_N_BUFFERS = 0L;
    private static final short DEFAULT_N_TABLES = 0;
    private static final OFAuxId DEFAULT_AUXILIARY_ID = OFAuxId.MAIN;
    private static final Set<OFCapabilities> DEFAULT_CAPABILITIES = ImmutableSet.of();
    private static final long DEFAULT_RESERVED = 0L;
    private final long xid;
    private final DatapathId datapathId;
    private final long nBuffers;
    private final short nTables;
    private final OFAuxId auxiliaryId;
    private final Set<OFCapabilities> capabilities;
    private final long reserved;
    static final OFFeaturesReplyVer13 DEFAULT = new OFFeaturesReplyVer13(0L, DEFAULT_DATAPATH_ID, 0L, 0, DEFAULT_AUXILIARY_ID, DEFAULT_CAPABILITIES, 0L);
    static final Reader READER = new Reader();
    static final OFFeaturesReplyVer13Funnel FUNNEL = new OFFeaturesReplyVer13Funnel();
    static final Writer WRITER = new Writer();

    OFFeaturesReplyVer13(long xid, DatapathId datapathId, long nBuffers, short nTables, OFAuxId auxiliaryId, Set<OFCapabilities> capabilities, long reserved) {
        if (datapathId == null) {
            throw new NullPointerException("OFFeaturesReplyVer13: property datapathId cannot be null");
        }
        if (auxiliaryId == null) {
            throw new NullPointerException("OFFeaturesReplyVer13: property auxiliaryId cannot be null");
        }
        if (capabilities == null) {
            throw new NullPointerException("OFFeaturesReplyVer13: property capabilities cannot be null");
        }
        this.xid = U32.normalize(xid);
        this.datapathId = datapathId;
        this.nBuffers = U32.normalize(nBuffers);
        this.nTables = U8.normalize(nTables);
        this.auxiliaryId = auxiliaryId;
        this.capabilities = capabilities;
        this.reserved = U32.normalize(reserved);
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.FEATURES_REPLY;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public DatapathId getDatapathId() {
        return this.datapathId;
    }

    @Override
    public long getNBuffers() {
        return this.nBuffers;
    }

    @Override
    public short getNTables() {
        return this.nTables;
    }

    @Override
    public Set<OFCapabilities> getCapabilities() {
        return this.capabilities;
    }

    @Override
    public Set<OFActionType> getActions() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property actions not supported in version 1.3");
    }

    @Override
    public List<OFPortDesc> getPorts() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property ports not supported in version 1.3");
    }

    @Override
    public long getReserved() {
        return this.reserved;
    }

    @Override
    public OFAuxId getAuxiliaryId() {
        return this.auxiliaryId;
    }

    @Override
    public OFFeaturesReply.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFFeaturesReplyVer13(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("datapathId=").append(this.datapathId);
        b.append(", ");
        b.append("nBuffers=").append(this.nBuffers);
        b.append(", ");
        b.append("nTables=").append(this.nTables);
        b.append(", ");
        b.append("auxiliaryId=").append(this.auxiliaryId);
        b.append(", ");
        b.append("capabilities=").append(this.capabilities);
        b.append(", ");
        b.append("reserved=").append(this.reserved);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFFeaturesReplyVer13 other = (OFFeaturesReplyVer13)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.datapathId == null ? other.datapathId != null : !this.datapathId.equals(other.datapathId)) {
            return false;
        }
        if (this.nBuffers != other.nBuffers) {
            return false;
        }
        if (this.nTables != other.nTables) {
            return false;
        }
        if (this.auxiliaryId == null ? other.auxiliaryId != null : !this.auxiliaryId.equals(other.auxiliaryId)) {
            return false;
        }
        if (this.capabilities == null ? other.capabilities != null : !this.capabilities.equals(other.capabilities)) {
            return false;
        }
        return this.reserved == other.reserved;
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFFeaturesReplyVer13 other = (OFFeaturesReplyVer13)obj;
        if (this.datapathId == null ? other.datapathId != null : !this.datapathId.equals(other.datapathId)) {
            return false;
        }
        if (this.nBuffers != other.nBuffers) {
            return false;
        }
        if (this.nTables != other.nTables) {
            return false;
        }
        if (this.auxiliaryId == null ? other.auxiliaryId != null : !this.auxiliaryId.equals(other.auxiliaryId)) {
            return false;
        }
        if (this.capabilities == null ? other.capabilities != null : !this.capabilities.equals(other.capabilities)) {
            return false;
        }
        return this.reserved == other.reserved;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.datapathId == null ? 0 : this.datapathId.hashCode());
        result = 31 * (int)(this.nBuffers ^ this.nBuffers >>> 32);
        result = 31 * result + this.nTables;
        result = 31 * result + (this.auxiliaryId == null ? 0 : this.auxiliaryId.hashCode());
        result = 31 * result + (this.capabilities == null ? 0 : this.capabilities.hashCode());
        result = 31 * (int)(this.reserved ^ this.reserved >>> 32);
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.datapathId == null ? 0 : this.datapathId.hashCode());
        result = 31 * (int)(this.nBuffers ^ this.nBuffers >>> 32);
        result = 31 * result + this.nTables;
        result = 31 * result + (this.auxiliaryId == null ? 0 : this.auxiliaryId.hashCode());
        result = 31 * result + (this.capabilities == null ? 0 : this.capabilities.hashCode());
        result = 31 * (int)(this.reserved ^ this.reserved >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFFeaturesReplyVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFFeaturesReplyVer13 message) {
            bb.writeByte(4);
            bb.writeByte(6);
            bb.writeShort(32);
            bb.writeInt(U32.t(message.xid));
            bb.writeLong(message.datapathId.getLong());
            bb.writeInt(U32.t(message.nBuffers));
            bb.writeByte((int)U8.t(message.nTables));
            message.auxiliaryId.writeByte(bb);
            bb.writeZero(2);
            OFCapabilitiesSerializerVer13.writeTo(bb, message.capabilities);
            bb.writeInt(U32.t(message.reserved));
        }
    }

    static class OFFeaturesReplyVer13Funnel
    implements Funnel<OFFeaturesReplyVer13> {
        private static final long serialVersionUID = 1L;

        OFFeaturesReplyVer13Funnel() {
        }

        public void funnel(OFFeaturesReplyVer13 message, PrimitiveSink sink) {
            sink.putByte((byte)4);
            sink.putByte((byte)6);
            sink.putShort((short)32);
            sink.putLong(message.xid);
            message.datapathId.putTo(sink);
            sink.putLong(message.nBuffers);
            sink.putShort(message.nTables);
            message.auxiliaryId.putTo(sink);
            OFCapabilitiesSerializerVer13.putTo(message.capabilities, sink);
            sink.putLong(message.reserved);
        }
    }

    static class Reader
    implements OFMessageReader<OFFeaturesReply> {
        Reader() {
        }

        @Override
        public OFFeaturesReply readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 6) {
                throw new OFParseError("Wrong type: Expected=OFType.FEATURES_REPLY(6), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 32) {
                throw new OFParseError("Wrong length: Expected=32(32), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            DatapathId datapathId = DatapathId.of(bb.readLong());
            long nBuffers = U32.f(bb.readInt());
            short nTables = U8.f(bb.readByte());
            OFAuxId auxiliaryId = OFAuxId.readByte(bb);
            bb.skipBytes(2);
            Set<OFCapabilities> capabilities = OFCapabilitiesSerializerVer13.readFrom(bb);
            long reserved = U32.f(bb.readInt());
            OFFeaturesReplyVer13 featuresReplyVer13 = new OFFeaturesReplyVer13(xid, datapathId, nBuffers, nTables, auxiliaryId, capabilities, reserved);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)featuresReplyVer13);
            }
            return featuresReplyVer13;
        }
    }

    static class Builder
    implements OFFeaturesReply.Builder {
        private boolean xidSet;
        private long xid;
        private boolean datapathIdSet;
        private DatapathId datapathId;
        private boolean nBuffersSet;
        private long nBuffers;
        private boolean nTablesSet;
        private short nTables;
        private boolean auxiliaryIdSet;
        private OFAuxId auxiliaryId;
        private boolean capabilitiesSet;
        private Set<OFCapabilities> capabilities;
        private boolean reservedSet;
        private long reserved;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.FEATURES_REPLY;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFFeaturesReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public DatapathId getDatapathId() {
            return this.datapathId;
        }

        @Override
        public OFFeaturesReply.Builder setDatapathId(DatapathId datapathId) {
            this.datapathId = datapathId;
            this.datapathIdSet = true;
            return this;
        }

        @Override
        public long getNBuffers() {
            return this.nBuffers;
        }

        @Override
        public OFFeaturesReply.Builder setNBuffers(long nBuffers) {
            this.nBuffers = nBuffers;
            this.nBuffersSet = true;
            return this;
        }

        @Override
        public short getNTables() {
            return this.nTables;
        }

        @Override
        public OFFeaturesReply.Builder setNTables(short nTables) {
            this.nTables = nTables;
            this.nTablesSet = true;
            return this;
        }

        @Override
        public Set<OFCapabilities> getCapabilities() {
            return this.capabilities;
        }

        @Override
        public OFFeaturesReply.Builder setCapabilities(Set<OFCapabilities> capabilities) {
            this.capabilities = capabilities;
            this.capabilitiesSet = true;
            return this;
        }

        @Override
        public Set<OFActionType> getActions() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property actions not supported in version 1.3");
        }

        @Override
        public OFFeaturesReply.Builder setActions(Set<OFActionType> actions) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property actions not supported in version 1.3");
        }

        @Override
        public List<OFPortDesc> getPorts() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property ports not supported in version 1.3");
        }

        @Override
        public OFFeaturesReply.Builder setPorts(List<OFPortDesc> ports) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property ports not supported in version 1.3");
        }

        @Override
        public long getReserved() {
            return this.reserved;
        }

        @Override
        public OFFeaturesReply.Builder setReserved(long reserved) {
            this.reserved = reserved;
            this.reservedSet = true;
            return this;
        }

        @Override
        public OFAuxId getAuxiliaryId() {
            return this.auxiliaryId;
        }

        @Override
        public OFFeaturesReply.Builder setAuxiliaryId(OFAuxId auxiliaryId) {
            this.auxiliaryId = auxiliaryId;
            this.auxiliaryIdSet = true;
            return this;
        }

        @Override
        public OFFeaturesReply build() {
            Set<OFCapabilities> capabilities;
            OFAuxId auxiliaryId;
            DatapathId datapathId;
            long xid = this.xidSet ? this.xid : 0L;
            DatapathId datapathId2 = datapathId = this.datapathIdSet ? this.datapathId : DEFAULT_DATAPATH_ID;
            if (datapathId == null) {
                throw new NullPointerException("Property datapathId must not be null");
            }
            long nBuffers = this.nBuffersSet ? this.nBuffers : 0L;
            short nTables = this.nTablesSet ? this.nTables : (short)0;
            OFAuxId oFAuxId = auxiliaryId = this.auxiliaryIdSet ? this.auxiliaryId : DEFAULT_AUXILIARY_ID;
            if (auxiliaryId == null) {
                throw new NullPointerException("Property auxiliaryId must not be null");
            }
            Set<OFCapabilities> set = capabilities = this.capabilitiesSet ? this.capabilities : DEFAULT_CAPABILITIES;
            if (capabilities == null) {
                throw new NullPointerException("Property capabilities must not be null");
            }
            long reserved = this.reservedSet ? this.reserved : 0L;
            return new OFFeaturesReplyVer13(xid, datapathId, nBuffers, nTables, auxiliaryId, capabilities, reserved);
        }
    }

    static class BuilderWithParent
    implements OFFeaturesReply.Builder {
        final OFFeaturesReplyVer13 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean datapathIdSet;
        private DatapathId datapathId;
        private boolean nBuffersSet;
        private long nBuffers;
        private boolean nTablesSet;
        private short nTables;
        private boolean auxiliaryIdSet;
        private OFAuxId auxiliaryId;
        private boolean capabilitiesSet;
        private Set<OFCapabilities> capabilities;
        private boolean reservedSet;
        private long reserved;

        BuilderWithParent(OFFeaturesReplyVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.FEATURES_REPLY;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFFeaturesReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public DatapathId getDatapathId() {
            return this.datapathId;
        }

        @Override
        public OFFeaturesReply.Builder setDatapathId(DatapathId datapathId) {
            this.datapathId = datapathId;
            this.datapathIdSet = true;
            return this;
        }

        @Override
        public long getNBuffers() {
            return this.nBuffers;
        }

        @Override
        public OFFeaturesReply.Builder setNBuffers(long nBuffers) {
            this.nBuffers = nBuffers;
            this.nBuffersSet = true;
            return this;
        }

        @Override
        public short getNTables() {
            return this.nTables;
        }

        @Override
        public OFFeaturesReply.Builder setNTables(short nTables) {
            this.nTables = nTables;
            this.nTablesSet = true;
            return this;
        }

        @Override
        public Set<OFCapabilities> getCapabilities() {
            return this.capabilities;
        }

        @Override
        public OFFeaturesReply.Builder setCapabilities(Set<OFCapabilities> capabilities) {
            this.capabilities = capabilities;
            this.capabilitiesSet = true;
            return this;
        }

        @Override
        public Set<OFActionType> getActions() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property actions not supported in version 1.3");
        }

        @Override
        public OFFeaturesReply.Builder setActions(Set<OFActionType> actions) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property actions not supported in version 1.3");
        }

        @Override
        public List<OFPortDesc> getPorts() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property ports not supported in version 1.3");
        }

        @Override
        public OFFeaturesReply.Builder setPorts(List<OFPortDesc> ports) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property ports not supported in version 1.3");
        }

        @Override
        public long getReserved() {
            return this.reserved;
        }

        @Override
        public OFFeaturesReply.Builder setReserved(long reserved) {
            this.reserved = reserved;
            this.reservedSet = true;
            return this;
        }

        @Override
        public OFAuxId getAuxiliaryId() {
            return this.auxiliaryId;
        }

        @Override
        public OFFeaturesReply.Builder setAuxiliaryId(OFAuxId auxiliaryId) {
            this.auxiliaryId = auxiliaryId;
            this.auxiliaryIdSet = true;
            return this;
        }

        @Override
        public OFFeaturesReply build() {
            Set capabilities;
            OFAuxId auxiliaryId;
            DatapathId datapathId;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            DatapathId datapathId2 = datapathId = this.datapathIdSet ? this.datapathId : this.parentMessage.datapathId;
            if (datapathId == null) {
                throw new NullPointerException("Property datapathId must not be null");
            }
            long nBuffers = this.nBuffersSet ? this.nBuffers : this.parentMessage.nBuffers;
            short nTables = this.nTablesSet ? this.nTables : this.parentMessage.nTables;
            OFAuxId oFAuxId = auxiliaryId = this.auxiliaryIdSet ? this.auxiliaryId : this.parentMessage.auxiliaryId;
            if (auxiliaryId == null) {
                throw new NullPointerException("Property auxiliaryId must not be null");
            }
            Set set = capabilities = this.capabilitiesSet ? this.capabilities : this.parentMessage.capabilities;
            if (capabilities == null) {
                throw new NullPointerException("Property capabilities must not be null");
            }
            long reserved = this.reservedSet ? this.reserved : this.parentMessage.reserved;
            return new OFFeaturesReplyVer13(xid, datapathId, nBuffers, nTables, auxiliaryId, capabilities, reserved);
        }
    }
}

