/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnRoutingParam;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvRoutingParam;
import org.projectfloodlight.openflow.protocol.ver13.OFBsnRoutingParamSerializerVer13;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvRoutingParamVer13
implements OFBsnTlvRoutingParam {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvRoutingParamVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 6;
    private final OFBsnRoutingParam value;
    static final Reader READER = new Reader();
    static final OFBsnTlvRoutingParamVer13Funnel FUNNEL = new OFBsnTlvRoutingParamVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvRoutingParamVer13(OFBsnRoutingParam value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvRoutingParamVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 161;
    }

    @Override
    public OFBsnRoutingParam getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvRoutingParam.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvRoutingParamVer13(");
        b.append("value=").append((Object)this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvRoutingParamVer13 other = (OFBsnTlvRoutingParamVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvRoutingParamVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvRoutingParamVer13 message) {
            bb.writeShort(161);
            bb.writeShort(6);
            OFBsnRoutingParamSerializerVer13.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvRoutingParamVer13Funnel
    implements Funnel<OFBsnTlvRoutingParamVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvRoutingParamVer13Funnel() {
        }

        public void funnel(OFBsnTlvRoutingParamVer13 message, PrimitiveSink sink) {
            sink.putShort((short)161);
            sink.putShort((short)6);
            OFBsnRoutingParamSerializerVer13.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvRoutingParam> {
        Reader() {
        }

        @Override
        public OFBsnTlvRoutingParam readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 161) {
                throw new OFParseError("Wrong type: Expected=0xa1(0xa1), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFBsnRoutingParam value = OFBsnRoutingParamSerializerVer13.readFrom(bb);
            OFBsnTlvRoutingParamVer13 bsnTlvRoutingParamVer13 = new OFBsnTlvRoutingParamVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvRoutingParamVer13);
            }
            return bsnTlvRoutingParamVer13;
        }
    }

    static class Builder
    implements OFBsnTlvRoutingParam.Builder {
        private boolean valueSet;
        private OFBsnRoutingParam value;

        Builder() {
        }

        @Override
        public int getType() {
            return 161;
        }

        @Override
        public OFBsnRoutingParam getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvRoutingParam.Builder setValue(OFBsnRoutingParam value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvRoutingParam build() {
            if (!this.valueSet) {
                throw new IllegalStateException("Property value doesn't have default value -- must be set");
            }
            if (this.value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvRoutingParamVer13(this.value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvRoutingParam.Builder {
        final OFBsnTlvRoutingParamVer13 parentMessage;
        private boolean valueSet;
        private OFBsnRoutingParam value;

        BuilderWithParent(OFBsnTlvRoutingParamVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 161;
        }

        @Override
        public OFBsnRoutingParam getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvRoutingParam.Builder setValue(OFBsnRoutingParam value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvRoutingParam build() {
            OFBsnRoutingParam value;
            OFBsnRoutingParam oFBsnRoutingParam = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvRoutingParamVer13(value);
        }
    }
}

