/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvMplsControlWord;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvMplsControlWordVer13
implements OFBsnTlvMplsControlWord {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvMplsControlWordVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 5;
    private static final short DEFAULT_VALUE = 0;
    private final short value;
    static final OFBsnTlvMplsControlWordVer13 DEFAULT = new OFBsnTlvMplsControlWordVer13(0);
    static final Reader READER = new Reader();
    static final OFBsnTlvMplsControlWordVer13Funnel FUNNEL = new OFBsnTlvMplsControlWordVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvMplsControlWordVer13(short value) {
        this.value = U8.normalize(value);
    }

    @Override
    public int getType() {
        return 62;
    }

    @Override
    public short getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvMplsControlWord.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvMplsControlWordVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvMplsControlWordVer13 other = (OFBsnTlvMplsControlWordVer13)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.value;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvMplsControlWordVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvMplsControlWordVer13 message) {
            bb.writeShort(62);
            bb.writeShort(5);
            bb.writeByte((int)U8.t(message.value));
        }
    }

    static class OFBsnTlvMplsControlWordVer13Funnel
    implements Funnel<OFBsnTlvMplsControlWordVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvMplsControlWordVer13Funnel() {
        }

        public void funnel(OFBsnTlvMplsControlWordVer13 message, PrimitiveSink sink) {
            sink.putShort((short)62);
            sink.putShort((short)5);
            sink.putShort(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvMplsControlWord> {
        Reader() {
        }

        @Override
        public OFBsnTlvMplsControlWord readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 62) {
                throw new OFParseError("Wrong type: Expected=0x3e(0x3e), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 5) {
                throw new OFParseError("Wrong length: Expected=5(5), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            short value = U8.f(bb.readByte());
            OFBsnTlvMplsControlWordVer13 bsnTlvMplsControlWordVer13 = new OFBsnTlvMplsControlWordVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvMplsControlWordVer13);
            }
            return bsnTlvMplsControlWordVer13;
        }
    }

    static class Builder
    implements OFBsnTlvMplsControlWord.Builder {
        private boolean valueSet;
        private short value;

        Builder() {
        }

        @Override
        public int getType() {
            return 62;
        }

        @Override
        public short getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvMplsControlWord.Builder setValue(short value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvMplsControlWord build() {
            short value = this.valueSet ? this.value : (short)0;
            return new OFBsnTlvMplsControlWordVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvMplsControlWord.Builder {
        final OFBsnTlvMplsControlWordVer13 parentMessage;
        private boolean valueSet;
        private short value;

        BuilderWithParent(OFBsnTlvMplsControlWordVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 62;
        }

        @Override
        public short getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvMplsControlWord.Builder setValue(short value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvMplsControlWord build() {
            short value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvMplsControlWordVer13(value);
        }
    }
}

