/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvMgmt;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvMgmtVer13
implements OFBsnTlvMgmt {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvMgmtVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final long DEFAULT_VALUE = 0L;
    private final long value;
    static final OFBsnTlvMgmtVer13 DEFAULT = new OFBsnTlvMgmtVer13(0L);
    static final Reader READER = new Reader();
    static final OFBsnTlvMgmtVer13Funnel FUNNEL = new OFBsnTlvMgmtVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvMgmtVer13(long value) {
        this.value = U32.normalize(value);
    }

    @Override
    public int getType() {
        return 211;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvMgmt.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvMgmtVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvMgmtVer13 other = (OFBsnTlvMgmtVer13)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.value ^ this.value >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvMgmtVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvMgmtVer13 message) {
            bb.writeShort(211);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.value));
        }
    }

    static class OFBsnTlvMgmtVer13Funnel
    implements Funnel<OFBsnTlvMgmtVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvMgmtVer13Funnel() {
        }

        public void funnel(OFBsnTlvMgmtVer13 message, PrimitiveSink sink) {
            sink.putShort((short)211);
            sink.putShort((short)8);
            sink.putLong(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvMgmt> {
        Reader() {
        }

        @Override
        public OFBsnTlvMgmt readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 211) {
                throw new OFParseError("Wrong type: Expected=0xd3(0xd3), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long value = U32.f(bb.readInt());
            OFBsnTlvMgmtVer13 bsnTlvMgmtVer13 = new OFBsnTlvMgmtVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvMgmtVer13);
            }
            return bsnTlvMgmtVer13;
        }
    }

    static class Builder
    implements OFBsnTlvMgmt.Builder {
        private boolean valueSet;
        private long value;

        Builder() {
        }

        @Override
        public int getType() {
            return 211;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvMgmt.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvMgmt build() {
            long value = this.valueSet ? this.value : 0L;
            return new OFBsnTlvMgmtVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvMgmt.Builder {
        final OFBsnTlvMgmtVer13 parentMessage;
        private boolean valueSet;
        private long value;

        BuilderWithParent(OFBsnTlvMgmtVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 211;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvMgmt.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvMgmt build() {
            long value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvMgmtVer13(value);
        }
    }
}

