/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnHashPacketField;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvHashPacketField;
import org.projectfloodlight.openflow.protocol.ver13.OFBsnHashPacketFieldSerializerVer13;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvHashPacketFieldVer13
implements OFBsnTlvHashPacketField {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvHashPacketFieldVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 12;
    private static final Set<OFBsnHashPacketField> DEFAULT_VALUE = ImmutableSet.of();
    private final Set<OFBsnHashPacketField> value;
    static final OFBsnTlvHashPacketFieldVer13 DEFAULT = new OFBsnTlvHashPacketFieldVer13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvHashPacketFieldVer13Funnel FUNNEL = new OFBsnTlvHashPacketFieldVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvHashPacketFieldVer13(Set<OFBsnHashPacketField> value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvHashPacketFieldVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 103;
    }

    @Override
    public Set<OFBsnHashPacketField> getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvHashPacketField.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvHashPacketFieldVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvHashPacketFieldVer13 other = (OFBsnTlvHashPacketFieldVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvHashPacketFieldVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvHashPacketFieldVer13 message) {
            bb.writeShort(103);
            bb.writeShort(12);
            OFBsnHashPacketFieldSerializerVer13.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvHashPacketFieldVer13Funnel
    implements Funnel<OFBsnTlvHashPacketFieldVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvHashPacketFieldVer13Funnel() {
        }

        public void funnel(OFBsnTlvHashPacketFieldVer13 message, PrimitiveSink sink) {
            sink.putShort((short)103);
            sink.putShort((short)12);
            OFBsnHashPacketFieldSerializerVer13.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvHashPacketField> {
        Reader() {
        }

        @Override
        public OFBsnTlvHashPacketField readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 103) {
                throw new OFParseError("Wrong type: Expected=0x67(0x67), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 12) {
                throw new OFParseError("Wrong length: Expected=12(12), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            Set<OFBsnHashPacketField> value = OFBsnHashPacketFieldSerializerVer13.readFrom(bb);
            OFBsnTlvHashPacketFieldVer13 bsnTlvHashPacketFieldVer13 = new OFBsnTlvHashPacketFieldVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvHashPacketFieldVer13);
            }
            return bsnTlvHashPacketFieldVer13;
        }
    }

    static class Builder
    implements OFBsnTlvHashPacketField.Builder {
        private boolean valueSet;
        private Set<OFBsnHashPacketField> value;

        Builder() {
        }

        @Override
        public int getType() {
            return 103;
        }

        @Override
        public Set<OFBsnHashPacketField> getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvHashPacketField.Builder setValue(Set<OFBsnHashPacketField> value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvHashPacketField build() {
            Set<OFBsnHashPacketField> value;
            Set<OFBsnHashPacketField> set = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvHashPacketFieldVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvHashPacketField.Builder {
        final OFBsnTlvHashPacketFieldVer13 parentMessage;
        private boolean valueSet;
        private Set<OFBsnHashPacketField> value;

        BuilderWithParent(OFBsnTlvHashPacketFieldVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 103;
        }

        @Override
        public Set<OFBsnHashPacketField> getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvHashPacketField.Builder setValue(Set<OFBsnHashPacketField> value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvHashPacketField build() {
            Set value;
            Set set = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvHashPacketFieldVer13(value);
        }
    }
}

