/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnEncap;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvEncap;
import org.projectfloodlight.openflow.protocol.ver13.OFBsnEncapSerializerVer13;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvEncapVer13
implements OFBsnTlvEncap {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvEncapVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 5;
    private final OFBsnEncap value;
    static final Reader READER = new Reader();
    static final OFBsnTlvEncapVer13Funnel FUNNEL = new OFBsnTlvEncapVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvEncapVer13(OFBsnEncap value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvEncapVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 175;
    }

    @Override
    public OFBsnEncap getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvEncap.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvEncapVer13(");
        b.append("value=").append((Object)this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvEncapVer13 other = (OFBsnTlvEncapVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvEncapVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvEncapVer13 message) {
            bb.writeShort(175);
            bb.writeShort(5);
            OFBsnEncapSerializerVer13.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvEncapVer13Funnel
    implements Funnel<OFBsnTlvEncapVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvEncapVer13Funnel() {
        }

        public void funnel(OFBsnTlvEncapVer13 message, PrimitiveSink sink) {
            sink.putShort((short)175);
            sink.putShort((short)5);
            OFBsnEncapSerializerVer13.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvEncap> {
        Reader() {
        }

        @Override
        public OFBsnTlvEncap readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 175) {
                throw new OFParseError("Wrong type: Expected=0xaf(0xaf), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 5) {
                throw new OFParseError("Wrong length: Expected=5(5), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFBsnEncap value = OFBsnEncapSerializerVer13.readFrom(bb);
            OFBsnTlvEncapVer13 bsnTlvEncapVer13 = new OFBsnTlvEncapVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvEncapVer13);
            }
            return bsnTlvEncapVer13;
        }
    }

    static class Builder
    implements OFBsnTlvEncap.Builder {
        private boolean valueSet;
        private OFBsnEncap value;

        Builder() {
        }

        @Override
        public int getType() {
            return 175;
        }

        @Override
        public OFBsnEncap getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvEncap.Builder setValue(OFBsnEncap value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvEncap build() {
            if (!this.valueSet) {
                throw new IllegalStateException("Property value doesn't have default value -- must be set");
            }
            if (this.value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvEncapVer13(this.value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvEncap.Builder {
        final OFBsnTlvEncapVer13 parentMessage;
        private boolean valueSet;
        private OFBsnEncap value;

        BuilderWithParent(OFBsnTlvEncapVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 175;
        }

        @Override
        public OFBsnEncap getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvEncap.Builder setValue(OFBsnEncap value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvEncap build() {
            OFBsnEncap value;
            OFBsnEncap oFBsnEncap = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvEncapVer13(value);
        }
    }
}

