/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvEgressOnly;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvEgressOnlyVer13
implements OFBsnTlvEgressOnly {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvEgressOnlyVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 4;
    static final OFBsnTlvEgressOnlyVer13 DEFAULT = new OFBsnTlvEgressOnlyVer13();
    static final OFBsnTlvEgressOnlyVer13 INSTANCE = new OFBsnTlvEgressOnlyVer13();
    static final Reader READER = new Reader();
    static final OFBsnTlvEgressOnlyVer13Funnel FUNNEL = new OFBsnTlvEgressOnlyVer13Funnel();
    static final Writer WRITER = new Writer();

    private OFBsnTlvEgressOnlyVer13() {
    }

    @Override
    public int getType() {
        return 137;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvEgressOnly.Builder createBuilder() {
        throw new UnsupportedOperationException("OFBsnTlvEgressOnlyVer13 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvEgressOnlyVer13(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvEgressOnlyVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvEgressOnlyVer13 message) {
            bb.writeShort(137);
            bb.writeShort(4);
        }
    }

    static class OFBsnTlvEgressOnlyVer13Funnel
    implements Funnel<OFBsnTlvEgressOnlyVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvEgressOnlyVer13Funnel() {
        }

        public void funnel(OFBsnTlvEgressOnlyVer13 message, PrimitiveSink sink) {
            sink.putShort((short)137);
            sink.putShort((short)4);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvEgressOnly> {
        Reader() {
        }

        @Override
        public OFBsnTlvEgressOnly readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 137) {
                throw new OFParseError("Wrong type: Expected=0x89(0x89), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 4) {
                throw new OFParseError("Wrong length: Expected=4(4), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

