/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvArpSpa;
import org.projectfloodlight.openflow.types.IPv4Address;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvArpSpaVer13
implements OFBsnTlvArpSpa {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvArpSpaVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final IPv4Address DEFAULT_VALUE = IPv4Address.NONE;
    private final IPv4Address value;
    static final OFBsnTlvArpSpaVer13 DEFAULT = new OFBsnTlvArpSpaVer13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvArpSpaVer13Funnel FUNNEL = new OFBsnTlvArpSpaVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvArpSpaVer13(IPv4Address value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvArpSpaVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 199;
    }

    @Override
    public IPv4Address getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvArpSpa.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvArpSpaVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvArpSpaVer13 other = (OFBsnTlvArpSpaVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvArpSpaVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvArpSpaVer13 message) {
            bb.writeShort(199);
            bb.writeShort(8);
            message.value.write4Bytes(bb);
        }
    }

    static class OFBsnTlvArpSpaVer13Funnel
    implements Funnel<OFBsnTlvArpSpaVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvArpSpaVer13Funnel() {
        }

        public void funnel(OFBsnTlvArpSpaVer13 message, PrimitiveSink sink) {
            sink.putShort((short)199);
            sink.putShort((short)8);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvArpSpa> {
        Reader() {
        }

        @Override
        public OFBsnTlvArpSpa readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 199) {
                throw new OFParseError("Wrong type: Expected=0xc7(0xc7), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            IPv4Address value = IPv4Address.read4Bytes(bb);
            OFBsnTlvArpSpaVer13 bsnTlvArpSpaVer13 = new OFBsnTlvArpSpaVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvArpSpaVer13);
            }
            return bsnTlvArpSpaVer13;
        }
    }

    static class Builder
    implements OFBsnTlvArpSpa.Builder {
        private boolean valueSet;
        private IPv4Address value;

        Builder() {
        }

        @Override
        public int getType() {
            return 199;
        }

        @Override
        public IPv4Address getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvArpSpa.Builder setValue(IPv4Address value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvArpSpa build() {
            IPv4Address value;
            IPv4Address iPv4Address = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvArpSpaVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvArpSpa.Builder {
        final OFBsnTlvArpSpaVer13 parentMessage;
        private boolean valueSet;
        private IPv4Address value;

        BuilderWithParent(OFBsnTlvArpSpaVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 199;
        }

        @Override
        public IPv4Address getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvArpSpa.Builder setValue(IPv4Address value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvArpSpa build() {
            IPv4Address value;
            IPv4Address iPv4Address = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvArpSpaVer13(value);
        }
    }
}

