/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFStatsReply;
import org.projectfloodlight.openflow.protocol.ver12.OFAggregateStatsReplyVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFDescStatsReplyVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFExperimenterStatsReplyVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFFlowStatsReplyVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFGroupDescStatsReplyVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFGroupFeaturesStatsReplyVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFGroupStatsReplyVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFPortStatsReplyVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFQueueStatsReplyVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFTableStatsReplyVer12;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;

abstract class OFStatsReplyVer12 {
    static final byte WIRE_VERSION = 3;
    static final int MINIMUM_LENGTH = 16;
    public static final Reader READER = new Reader();

    OFStatsReplyVer12() {
    }

    static class Reader
    implements OFMessageReader<OFStatsReply> {
        Reader() {
        }

        @Override
        public OFStatsReply readFrom(ByteBuf bb) throws OFParseError {
            if (bb.readableBytes() < 16) {
                return null;
            }
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 3) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_12(3), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 19) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REPLY(19), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            U32.f(bb.readInt());
            short statsType = bb.readShort();
            bb.readerIndex(start);
            switch (statsType) {
                case 2: {
                    return OFAggregateStatsReplyVer12.READER.readFrom(bb);
                }
                case -1: {
                    return OFExperimenterStatsReplyVer12.READER.readFrom(bb);
                }
                case 0: {
                    return OFDescStatsReplyVer12.READER.readFrom(bb);
                }
                case 1: {
                    return OFFlowStatsReplyVer12.READER.readFrom(bb);
                }
                case 4: {
                    return OFPortStatsReplyVer12.READER.readFrom(bb);
                }
                case 5: {
                    return OFQueueStatsReplyVer12.READER.readFrom(bb);
                }
                case 3: {
                    return OFTableStatsReplyVer12.READER.readFrom(bb);
                }
                case 7: {
                    return OFGroupDescStatsReplyVer12.READER.readFrom(bb);
                }
                case 6: {
                    return OFGroupStatsReplyVer12.READER.readFrom(bb);
                }
                case 8: {
                    return OFGroupFeaturesStatsReplyVer12.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator statsType of class OFStatsReplyVer12: " + statsType);
        }
    }
}

