/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnHeader;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.ver11.OFBsnBwClearDataReplyVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFBsnBwClearDataRequestVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFBsnBwEnableGetReplyVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFBsnBwEnableGetRequestVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFBsnBwEnableSetReplyVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFBsnBwEnableSetRequestVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFBsnGetInterfacesReplyVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFBsnGetInterfacesRequestVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFBsnGetMirroringReplyVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFBsnGetMirroringRequestVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFBsnPduRxReplyVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFBsnPduRxRequestVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFBsnPduRxTimeoutVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFBsnPduTxReplyVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFBsnPduTxRequestVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFBsnSetMirroringVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFBsnSetPktinSuppressionReplyVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFBsnSetPktinSuppressionRequestVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFBsnVirtualPortCreateReplyVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFBsnVirtualPortCreateRequestVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFBsnVirtualPortRemoveReplyVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFBsnVirtualPortRemoveRequestVer11;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;

abstract class OFBsnHeaderVer11 {
    static final byte WIRE_VERSION = 2;
    static final int MINIMUM_LENGTH = 16;
    public static final Reader READER = new Reader();

    OFBsnHeaderVer11() {
    }

    static class Reader
    implements OFMessageReader<OFBsnHeader> {
        Reader() {
        }

        @Override
        public OFBsnHeader readFrom(ByteBuf bb) throws OFParseError {
            if (bb.readableBytes() < 16) {
                return null;
            }
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 2) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_11(2), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            bb.readerIndex(start);
            switch (subtype) {
                case 22: {
                    return OFBsnBwClearDataReplyVer11.READER.readFrom(bb);
                }
                case 21: {
                    return OFBsnBwClearDataRequestVer11.READER.readFrom(bb);
                }
                case 20: {
                    return OFBsnBwEnableGetReplyVer11.READER.readFrom(bb);
                }
                case 19: {
                    return OFBsnBwEnableGetRequestVer11.READER.readFrom(bb);
                }
                case 23: {
                    return OFBsnBwEnableSetReplyVer11.READER.readFrom(bb);
                }
                case 18: {
                    return OFBsnBwEnableSetRequestVer11.READER.readFrom(bb);
                }
                case 10: {
                    return OFBsnGetInterfacesReplyVer11.READER.readFrom(bb);
                }
                case 9: {
                    return OFBsnGetInterfacesRequestVer11.READER.readFrom(bb);
                }
                case 5: {
                    return OFBsnGetMirroringReplyVer11.READER.readFrom(bb);
                }
                case 4: {
                    return OFBsnGetMirroringRequestVer11.READER.readFrom(bb);
                }
                case 34: {
                    return OFBsnPduRxReplyVer11.READER.readFrom(bb);
                }
                case 33: {
                    return OFBsnPduRxRequestVer11.READER.readFrom(bb);
                }
                case 35: {
                    return OFBsnPduRxTimeoutVer11.READER.readFrom(bb);
                }
                case 32: {
                    return OFBsnPduTxReplyVer11.READER.readFrom(bb);
                }
                case 31: {
                    return OFBsnPduTxRequestVer11.READER.readFrom(bb);
                }
                case 3: {
                    return OFBsnSetMirroringVer11.READER.readFrom(bb);
                }
                case 25: {
                    return OFBsnSetPktinSuppressionReplyVer11.READER.readFrom(bb);
                }
                case 11: {
                    return OFBsnSetPktinSuppressionRequestVer11.READER.readFrom(bb);
                }
                case 16: {
                    return OFBsnVirtualPortCreateReplyVer11.READER.readFrom(bb);
                }
                case 15: {
                    return OFBsnVirtualPortCreateRequestVer11.READER.readFrom(bb);
                }
                case 26: {
                    return OFBsnVirtualPortRemoveReplyVer11.READER.readFrom(bb);
                }
                case 17: {
                    return OFBsnVirtualPortRemoveRequestVer11.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator subtype of class OFBsnHeaderVer11: " + subtype);
        }
    }
}

