/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import com.google.common.hash.PrimitiveSink;
import com.google.common.primitives.UnsignedInts;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.protocol.OFHeaderTypeNamespace;
import org.projectfloodlight.openflow.types.OFValueType;

public class PacketType
implements OFValueType<PacketType> {
    private final int namespace;
    private final int nsType;
    static final int NAMESPACE_ONF = 0;
    static final int NAMESPACE_ETHERTYPE = 1;
    static final int NS_TYPE_ONF_ETHERNET = 0;
    static final int NS_TYPE_ONF_NO_PACKET = 1;
    static final int NS_TYPE_ONF_EXPERIMENTER = 65535;
    static final int NS_TYPE_ETHER_IPv4 = 2048;
    static final int NS_TYPE_ETHER_IPv6 = 34525;
    public static final PacketType ETHERNET = new PacketType(0, 0);
    public static final PacketType NO_PACKET = new PacketType(0, 1);
    public static final PacketType EXPERIMENTER = new PacketType(0, 65535);
    public static final PacketType IPV4 = new PacketType(1, 2048);
    public static final PacketType IPV6 = new PacketType(1, 34525);
    public static final PacketType NO_MASK = PacketType.of(65535, 65535);
    public static final PacketType FULL_MASK = PacketType.of(0, 0);

    private PacketType(int namespace, int nsType) {
        this.namespace = namespace;
        this.nsType = nsType;
    }

    public static PacketType of(int namespace, int nsType) {
        switch (namespace) {
            case 0: {
                switch (nsType) {
                    case 0: {
                        return ETHERNET;
                    }
                    case 1: {
                        return NO_PACKET;
                    }
                    case 65535: {
                        return EXPERIMENTER;
                    }
                }
                break;
            }
            case 1: {
                switch (nsType) {
                    case 2048: {
                        return IPV4;
                    }
                    case 34525: {
                        return IPV6;
                    }
                }
            }
        }
        return new PacketType(namespace, nsType);
    }

    public static PacketType of(OFHeaderTypeNamespace namespace, int nsType) {
        return PacketType.of(namespace.getStableValue(), nsType);
    }

    @Override
    public PacketType applyMask(PacketType mask) {
        return PacketType.of(this.namespace & mask.namespace, this.nsType & mask.nsType);
    }

    @Override
    public int compareTo(PacketType o) {
        int res = UnsignedInts.compare((int)this.namespace, (int)o.namespace);
        if (res != 0) {
            return res;
        }
        return UnsignedInts.compare((int)this.nsType, (int)o.nsType);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        sink.putInt(this.namespace);
        sink.putInt(this.nsType);
    }

    @Override
    public int getLength() {
        return 4;
    }

    public void write4Bytes(ByteBuf c) {
        c.writeShort(this.namespace);
        c.writeInt(this.nsType);
    }

    public static PacketType read4Bytes(ByteBuf c) {
        return PacketType.of(c.readShort(), c.readInt());
    }

    public int getNamespace() {
        return this.namespace;
    }

    public int getNsType() {
        return this.nsType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.namespace;
        result = 31 * result + this.nsType;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PacketType other = (PacketType)obj;
        if (this.namespace != other.namespace) {
            return false;
        }
        return this.nsType == other.nsType;
    }

    public String toString() {
        return "PacketType [namespace=" + this.namespace + ", nsType=" + this.nsType + "]";
    }
}

