/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import com.google.common.hash.PrimitiveSink;
import org.projectfloodlight.openflow.types.OFValueType;

public class Masked<T extends OFValueType<T>>
implements OFValueType<Masked<T>> {
    protected final T value;
    protected final T mask;

    protected Masked(T value, T mask) {
        this.value = value.applyMask(mask);
        this.mask = mask;
    }

    public T getValue() {
        return this.value;
    }

    public T getMask() {
        return this.mask;
    }

    public static <T extends OFValueType<T>> Masked<T> of(T value, T mask) {
        return new Masked<T>(value, mask);
    }

    @Override
    public int getLength() {
        return this.value.getLength() + this.mask.getLength();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.value.toString()).append('/').append(this.mask.toString());
        return sb.toString();
    }

    public boolean matches(T candidate) {
        return candidate.applyMask(this.mask).equals(this.value);
    }

    @Override
    public Masked<T> applyMask(Masked<T> mask) {
        return this;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Masked)) {
            return false;
        }
        Masked mobj = (Masked)obj;
        return this.value.equals(mobj.value) && this.mask.equals(mobj.mask);
    }

    public int hashCode() {
        int prime = 59;
        int result = 1;
        result = 59 * result + this.value.hashCode();
        result = 59 * result + this.mask.hashCode();
        return result;
    }

    @Override
    public int compareTo(Masked<T> o) {
        int res = this.value.compareTo(o.value);
        if (res != 0) {
            return res;
        }
        return this.mask.compareTo(o.mask);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        this.value.putTo(sink);
        this.mask.putTo(sink);
    }
}

