/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFControllerRole;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFRoleRequest;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver15.OFControllerRoleSerializerVer15;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFRoleRequestVer15
implements OFRoleRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFRoleRequestVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 24;
    private static final long DEFAULT_XID = 0L;
    private static final int DEFAULT_SHORT_ID = 0;
    private static final U64 DEFAULT_GENERATION_ID = U64.ZERO;
    private final long xid;
    private final OFControllerRole role;
    private final int shortId;
    private final U64 generationId;
    static final Reader READER = new Reader();
    static final OFRoleRequestVer15Funnel FUNNEL = new OFRoleRequestVer15Funnel();
    static final Writer WRITER = new Writer();

    OFRoleRequestVer15(long xid, OFControllerRole role, int shortId, U64 generationId) {
        if (role == null) {
            throw new NullPointerException("OFRoleRequestVer15: property role cannot be null");
        }
        if (generationId == null) {
            throw new NullPointerException("OFRoleRequestVer15: property generationId cannot be null");
        }
        this.xid = xid;
        this.role = role;
        this.shortId = shortId;
        this.generationId = generationId;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFType getType() {
        return OFType.ROLE_REQUEST;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFControllerRole getRole() {
        return this.role;
    }

    @Override
    public U64 getGenerationId() {
        return this.generationId;
    }

    @Override
    public int getShortId() {
        return this.shortId;
    }

    @Override
    public OFRoleRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFRoleRequestVer15(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("role=").append((Object)this.role);
        b.append(", ");
        b.append("shortId=").append(this.shortId);
        b.append(", ");
        b.append("generationId=").append(this.generationId);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFRoleRequestVer15 other = (OFRoleRequestVer15)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.role == null ? other.role != null : !this.role.equals((Object)other.role)) {
            return false;
        }
        if (this.shortId != other.shortId) {
            return false;
        }
        return !(this.generationId == null ? other.generationId != null : !this.generationId.equals(other.generationId));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFRoleRequestVer15 other = (OFRoleRequestVer15)obj;
        if (this.role == null ? other.role != null : !this.role.equals((Object)other.role)) {
            return false;
        }
        if (this.shortId != other.shortId) {
            return false;
        }
        return !(this.generationId == null ? other.generationId != null : !this.generationId.equals(other.generationId));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.role == null ? 0 : this.role.hashCode());
        result = 31 * result + this.shortId;
        result = 31 * result + (this.generationId == null ? 0 : this.generationId.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.role == null ? 0 : this.role.hashCode());
        result = 31 * result + this.shortId;
        result = 31 * result + (this.generationId == null ? 0 : this.generationId.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFRoleRequestVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFRoleRequestVer15 message) {
            bb.writeByte(6);
            bb.writeByte(24);
            bb.writeShort(24);
            bb.writeInt(U32.t(message.xid));
            OFControllerRoleSerializerVer15.writeTo(bb, message.role);
            bb.writeShort((int)U16.t(message.shortId));
            bb.writeZero(2);
            bb.writeLong(message.generationId.getValue());
        }
    }

    static class OFRoleRequestVer15Funnel
    implements Funnel<OFRoleRequestVer15> {
        private static final long serialVersionUID = 1L;

        OFRoleRequestVer15Funnel() {
        }

        public void funnel(OFRoleRequestVer15 message, PrimitiveSink sink) {
            sink.putByte((byte)6);
            sink.putByte((byte)24);
            sink.putShort((short)24);
            sink.putLong(message.xid);
            OFControllerRoleSerializerVer15.putTo(message.role, sink);
            sink.putInt(message.shortId);
            message.generationId.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFRoleRequest> {
        Reader() {
        }

        @Override
        public OFRoleRequest readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 6) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 24) {
                throw new OFParseError("Wrong type: Expected=OFType.ROLE_REQUEST(24), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 24) {
                throw new OFParseError("Wrong length: Expected=24(24), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            OFControllerRole role = OFControllerRoleSerializerVer15.readFrom(bb);
            int shortId = U16.f(bb.readShort());
            bb.skipBytes(2);
            U64 generationId = U64.ofRaw(bb.readLong());
            OFRoleRequestVer15 roleRequestVer15 = new OFRoleRequestVer15(xid, role, shortId, generationId);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)roleRequestVer15);
            }
            return roleRequestVer15;
        }
    }

    static class Builder
    implements OFRoleRequest.Builder {
        private boolean xidSet;
        private long xid;
        private boolean roleSet;
        private OFControllerRole role;
        private boolean shortIdSet;
        private int shortId;
        private boolean generationIdSet;
        private U64 generationId;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.ROLE_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFRoleRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFControllerRole getRole() {
            return this.role;
        }

        @Override
        public OFRoleRequest.Builder setRole(OFControllerRole role) {
            this.role = role;
            this.roleSet = true;
            return this;
        }

        @Override
        public U64 getGenerationId() {
            return this.generationId;
        }

        @Override
        public OFRoleRequest.Builder setGenerationId(U64 generationId) {
            this.generationId = generationId;
            this.generationIdSet = true;
            return this;
        }

        @Override
        public int getShortId() {
            return this.shortId;
        }

        @Override
        public OFRoleRequest.Builder setShortId(int shortId) {
            this.shortId = shortId;
            this.shortIdSet = true;
            return this;
        }

        @Override
        public OFRoleRequest build() {
            U64 generationId;
            long xid;
            long l = xid = this.xidSet ? this.xid : 0L;
            if (!this.roleSet) {
                throw new IllegalStateException("Property role doesn't have default value -- must be set");
            }
            if (this.role == null) {
                throw new NullPointerException("Property role must not be null");
            }
            int shortId = this.shortIdSet ? this.shortId : 0;
            U64 u64 = generationId = this.generationIdSet ? this.generationId : DEFAULT_GENERATION_ID;
            if (generationId == null) {
                throw new NullPointerException("Property generationId must not be null");
            }
            return new OFRoleRequestVer15(xid, this.role, shortId, generationId);
        }
    }

    static class BuilderWithParent
    implements OFRoleRequest.Builder {
        final OFRoleRequestVer15 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean roleSet;
        private OFControllerRole role;
        private boolean shortIdSet;
        private int shortId;
        private boolean generationIdSet;
        private U64 generationId;

        BuilderWithParent(OFRoleRequestVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.ROLE_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFRoleRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFControllerRole getRole() {
            return this.role;
        }

        @Override
        public OFRoleRequest.Builder setRole(OFControllerRole role) {
            this.role = role;
            this.roleSet = true;
            return this;
        }

        @Override
        public U64 getGenerationId() {
            return this.generationId;
        }

        @Override
        public OFRoleRequest.Builder setGenerationId(U64 generationId) {
            this.generationId = generationId;
            this.generationIdSet = true;
            return this;
        }

        @Override
        public int getShortId() {
            return this.shortId;
        }

        @Override
        public OFRoleRequest.Builder setShortId(int shortId) {
            this.shortId = shortId;
            this.shortIdSet = true;
            return this;
        }

        @Override
        public OFRoleRequest build() {
            U64 generationId;
            OFControllerRole role;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            OFControllerRole oFControllerRole = role = this.roleSet ? this.role : this.parentMessage.role;
            if (role == null) {
                throw new NullPointerException("Property role must not be null");
            }
            int shortId = this.shortIdSet ? this.shortId : this.parentMessage.shortId;
            U64 u64 = generationId = this.generationIdSet ? this.generationId : this.parentMessage.generationId;
            if (generationId == null) {
                throw new NullPointerException("Property generationId must not be null");
            }
            return new OFRoleRequestVer15(xid, role, shortId, generationId);
        }
    }
}

