/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPortStatsPropOptical;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFPortStatsPropOpticalVer15
implements OFPortStatsPropOptical {
    private static final Logger logger = LoggerFactory.getLogger(OFPortStatsPropOpticalVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 44;
    private static final long DEFAULT_FLAGS = 0L;
    private static final long DEFAULT_TX_FREQ_LMDA = 0L;
    private static final long DEFAULT_TX_OFFSET = 0L;
    private static final long DEFAULT_TX_GRID_SPAN = 0L;
    private static final long DEFAULT_RX_FREQ_LMDA = 0L;
    private static final long DEFAULT_RX_OFFSET = 0L;
    private static final long DEFAULT_RX_GRID_SPAN = 0L;
    private static final int DEFAULT_TX_PWR = 0;
    private static final int DEFAULT_RX_PWR = 0;
    private static final int DEFAULT_BIAS_CURRENT = 0;
    private static final int DEFAULT_TEMPERATURE = 0;
    private final long flags;
    private final long txFreqLmda;
    private final long txOffset;
    private final long txGridSpan;
    private final long rxFreqLmda;
    private final long rxOffset;
    private final long rxGridSpan;
    private final int txPwr;
    private final int rxPwr;
    private final int biasCurrent;
    private final int temperature;
    static final OFPortStatsPropOpticalVer15 DEFAULT = new OFPortStatsPropOpticalVer15(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0, 0, 0, 0);
    static final Reader READER = new Reader();
    static final OFPortStatsPropOpticalVer15Funnel FUNNEL = new OFPortStatsPropOpticalVer15Funnel();
    static final Writer WRITER = new Writer();

    OFPortStatsPropOpticalVer15(long flags, long txFreqLmda, long txOffset, long txGridSpan, long rxFreqLmda, long rxOffset, long rxGridSpan, int txPwr, int rxPwr, int biasCurrent, int temperature) {
        this.flags = flags;
        this.txFreqLmda = txFreqLmda;
        this.txOffset = txOffset;
        this.txGridSpan = txGridSpan;
        this.rxFreqLmda = rxFreqLmda;
        this.rxOffset = rxOffset;
        this.rxGridSpan = rxGridSpan;
        this.txPwr = txPwr;
        this.rxPwr = rxPwr;
        this.biasCurrent = biasCurrent;
        this.temperature = temperature;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public long getFlags() {
        return this.flags;
    }

    @Override
    public long getTxFreqLmda() {
        return this.txFreqLmda;
    }

    @Override
    public long getTxOffset() {
        return this.txOffset;
    }

    @Override
    public long getTxGridSpan() {
        return this.txGridSpan;
    }

    @Override
    public long getRxFreqLmda() {
        return this.rxFreqLmda;
    }

    @Override
    public long getRxOffset() {
        return this.rxOffset;
    }

    @Override
    public long getRxGridSpan() {
        return this.rxGridSpan;
    }

    @Override
    public int getTxPwr() {
        return this.txPwr;
    }

    @Override
    public int getRxPwr() {
        return this.rxPwr;
    }

    @Override
    public int getBiasCurrent() {
        return this.biasCurrent;
    }

    @Override
    public int getTemperature() {
        return this.temperature;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFPortStatsPropOptical.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFPortStatsPropOpticalVer15(");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("txFreqLmda=").append(this.txFreqLmda);
        b.append(", ");
        b.append("txOffset=").append(this.txOffset);
        b.append(", ");
        b.append("txGridSpan=").append(this.txGridSpan);
        b.append(", ");
        b.append("rxFreqLmda=").append(this.rxFreqLmda);
        b.append(", ");
        b.append("rxOffset=").append(this.rxOffset);
        b.append(", ");
        b.append("rxGridSpan=").append(this.rxGridSpan);
        b.append(", ");
        b.append("txPwr=").append(this.txPwr);
        b.append(", ");
        b.append("rxPwr=").append(this.rxPwr);
        b.append(", ");
        b.append("biasCurrent=").append(this.biasCurrent);
        b.append(", ");
        b.append("temperature=").append(this.temperature);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPortStatsPropOpticalVer15 other = (OFPortStatsPropOpticalVer15)obj;
        if (this.flags != other.flags) {
            return false;
        }
        if (this.txFreqLmda != other.txFreqLmda) {
            return false;
        }
        if (this.txOffset != other.txOffset) {
            return false;
        }
        if (this.txGridSpan != other.txGridSpan) {
            return false;
        }
        if (this.rxFreqLmda != other.rxFreqLmda) {
            return false;
        }
        if (this.rxOffset != other.rxOffset) {
            return false;
        }
        if (this.rxGridSpan != other.rxGridSpan) {
            return false;
        }
        if (this.txPwr != other.txPwr) {
            return false;
        }
        if (this.rxPwr != other.rxPwr) {
            return false;
        }
        if (this.biasCurrent != other.biasCurrent) {
            return false;
        }
        return this.temperature == other.temperature;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.flags ^ this.flags >>> 32);
        result = 31 * (int)(this.txFreqLmda ^ this.txFreqLmda >>> 32);
        result = 31 * (int)(this.txOffset ^ this.txOffset >>> 32);
        result = 31 * (int)(this.txGridSpan ^ this.txGridSpan >>> 32);
        result = 31 * (int)(this.rxFreqLmda ^ this.rxFreqLmda >>> 32);
        result = 31 * (int)(this.rxOffset ^ this.rxOffset >>> 32);
        result = 31 * (int)(this.rxGridSpan ^ this.rxGridSpan >>> 32);
        result = 31 * result + this.txPwr;
        result = 31 * result + this.rxPwr;
        result = 31 * result + this.biasCurrent;
        result = 31 * result + this.temperature;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFPortStatsPropOpticalVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFPortStatsPropOpticalVer15 message) {
            bb.writeShort(1);
            bb.writeShort(44);
            bb.writeZero(4);
            bb.writeInt(U32.t(message.flags));
            bb.writeInt(U32.t(message.txFreqLmda));
            bb.writeInt(U32.t(message.txOffset));
            bb.writeInt(U32.t(message.txGridSpan));
            bb.writeInt(U32.t(message.rxFreqLmda));
            bb.writeInt(U32.t(message.rxOffset));
            bb.writeInt(U32.t(message.rxGridSpan));
            bb.writeShort((int)U16.t(message.txPwr));
            bb.writeShort((int)U16.t(message.rxPwr));
            bb.writeShort((int)U16.t(message.biasCurrent));
            bb.writeShort((int)U16.t(message.temperature));
        }
    }

    static class OFPortStatsPropOpticalVer15Funnel
    implements Funnel<OFPortStatsPropOpticalVer15> {
        private static final long serialVersionUID = 1L;

        OFPortStatsPropOpticalVer15Funnel() {
        }

        public void funnel(OFPortStatsPropOpticalVer15 message, PrimitiveSink sink) {
            sink.putShort((short)1);
            sink.putShort((short)44);
            sink.putLong(message.flags);
            sink.putLong(message.txFreqLmda);
            sink.putLong(message.txOffset);
            sink.putLong(message.txGridSpan);
            sink.putLong(message.rxFreqLmda);
            sink.putLong(message.rxOffset);
            sink.putLong(message.rxGridSpan);
            sink.putInt(message.txPwr);
            sink.putInt(message.rxPwr);
            sink.putInt(message.biasCurrent);
            sink.putInt(message.temperature);
        }
    }

    static class Reader
    implements OFMessageReader<OFPortStatsPropOptical> {
        Reader() {
        }

        @Override
        public OFPortStatsPropOptical readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 1) {
                throw new OFParseError("Wrong type: Expected=0x1(0x1), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 44) {
                throw new OFParseError("Wrong length: Expected=44(44), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            bb.skipBytes(4);
            long flags = U32.f(bb.readInt());
            long txFreqLmda = U32.f(bb.readInt());
            long txOffset = U32.f(bb.readInt());
            long txGridSpan = U32.f(bb.readInt());
            long rxFreqLmda = U32.f(bb.readInt());
            long rxOffset = U32.f(bb.readInt());
            long rxGridSpan = U32.f(bb.readInt());
            int txPwr = U16.f(bb.readShort());
            int rxPwr = U16.f(bb.readShort());
            int biasCurrent = U16.f(bb.readShort());
            int temperature = U16.f(bb.readShort());
            OFPortStatsPropOpticalVer15 portStatsPropOpticalVer15 = new OFPortStatsPropOpticalVer15(flags, txFreqLmda, txOffset, txGridSpan, rxFreqLmda, rxOffset, rxGridSpan, txPwr, rxPwr, biasCurrent, temperature);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)portStatsPropOpticalVer15);
            }
            return portStatsPropOpticalVer15;
        }
    }

    static class Builder
    implements OFPortStatsPropOptical.Builder {
        private boolean flagsSet;
        private long flags;
        private boolean txFreqLmdaSet;
        private long txFreqLmda;
        private boolean txOffsetSet;
        private long txOffset;
        private boolean txGridSpanSet;
        private long txGridSpan;
        private boolean rxFreqLmdaSet;
        private long rxFreqLmda;
        private boolean rxOffsetSet;
        private long rxOffset;
        private boolean rxGridSpanSet;
        private long rxGridSpan;
        private boolean txPwrSet;
        private int txPwr;
        private boolean rxPwrSet;
        private int rxPwr;
        private boolean biasCurrentSet;
        private int biasCurrent;
        private boolean temperatureSet;
        private int temperature;

        Builder() {
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public long getFlags() {
            return this.flags;
        }

        @Override
        public OFPortStatsPropOptical.Builder setFlags(long flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public long getTxFreqLmda() {
            return this.txFreqLmda;
        }

        @Override
        public OFPortStatsPropOptical.Builder setTxFreqLmda(long txFreqLmda) {
            this.txFreqLmda = txFreqLmda;
            this.txFreqLmdaSet = true;
            return this;
        }

        @Override
        public long getTxOffset() {
            return this.txOffset;
        }

        @Override
        public OFPortStatsPropOptical.Builder setTxOffset(long txOffset) {
            this.txOffset = txOffset;
            this.txOffsetSet = true;
            return this;
        }

        @Override
        public long getTxGridSpan() {
            return this.txGridSpan;
        }

        @Override
        public OFPortStatsPropOptical.Builder setTxGridSpan(long txGridSpan) {
            this.txGridSpan = txGridSpan;
            this.txGridSpanSet = true;
            return this;
        }

        @Override
        public long getRxFreqLmda() {
            return this.rxFreqLmda;
        }

        @Override
        public OFPortStatsPropOptical.Builder setRxFreqLmda(long rxFreqLmda) {
            this.rxFreqLmda = rxFreqLmda;
            this.rxFreqLmdaSet = true;
            return this;
        }

        @Override
        public long getRxOffset() {
            return this.rxOffset;
        }

        @Override
        public OFPortStatsPropOptical.Builder setRxOffset(long rxOffset) {
            this.rxOffset = rxOffset;
            this.rxOffsetSet = true;
            return this;
        }

        @Override
        public long getRxGridSpan() {
            return this.rxGridSpan;
        }

        @Override
        public OFPortStatsPropOptical.Builder setRxGridSpan(long rxGridSpan) {
            this.rxGridSpan = rxGridSpan;
            this.rxGridSpanSet = true;
            return this;
        }

        @Override
        public int getTxPwr() {
            return this.txPwr;
        }

        @Override
        public OFPortStatsPropOptical.Builder setTxPwr(int txPwr) {
            this.txPwr = txPwr;
            this.txPwrSet = true;
            return this;
        }

        @Override
        public int getRxPwr() {
            return this.rxPwr;
        }

        @Override
        public OFPortStatsPropOptical.Builder setRxPwr(int rxPwr) {
            this.rxPwr = rxPwr;
            this.rxPwrSet = true;
            return this;
        }

        @Override
        public int getBiasCurrent() {
            return this.biasCurrent;
        }

        @Override
        public OFPortStatsPropOptical.Builder setBiasCurrent(int biasCurrent) {
            this.biasCurrent = biasCurrent;
            this.biasCurrentSet = true;
            return this;
        }

        @Override
        public int getTemperature() {
            return this.temperature;
        }

        @Override
        public OFPortStatsPropOptical.Builder setTemperature(int temperature) {
            this.temperature = temperature;
            this.temperatureSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFPortStatsPropOptical build() {
            long flags = this.flagsSet ? this.flags : 0L;
            long txFreqLmda = this.txFreqLmdaSet ? this.txFreqLmda : 0L;
            long txOffset = this.txOffsetSet ? this.txOffset : 0L;
            long txGridSpan = this.txGridSpanSet ? this.txGridSpan : 0L;
            long rxFreqLmda = this.rxFreqLmdaSet ? this.rxFreqLmda : 0L;
            long rxOffset = this.rxOffsetSet ? this.rxOffset : 0L;
            long rxGridSpan = this.rxGridSpanSet ? this.rxGridSpan : 0L;
            int txPwr = this.txPwrSet ? this.txPwr : 0;
            int rxPwr = this.rxPwrSet ? this.rxPwr : 0;
            int biasCurrent = this.biasCurrentSet ? this.biasCurrent : 0;
            int temperature = this.temperatureSet ? this.temperature : 0;
            return new OFPortStatsPropOpticalVer15(flags, txFreqLmda, txOffset, txGridSpan, rxFreqLmda, rxOffset, rxGridSpan, txPwr, rxPwr, biasCurrent, temperature);
        }
    }

    static class BuilderWithParent
    implements OFPortStatsPropOptical.Builder {
        final OFPortStatsPropOpticalVer15 parentMessage;
        private boolean flagsSet;
        private long flags;
        private boolean txFreqLmdaSet;
        private long txFreqLmda;
        private boolean txOffsetSet;
        private long txOffset;
        private boolean txGridSpanSet;
        private long txGridSpan;
        private boolean rxFreqLmdaSet;
        private long rxFreqLmda;
        private boolean rxOffsetSet;
        private long rxOffset;
        private boolean rxGridSpanSet;
        private long rxGridSpan;
        private boolean txPwrSet;
        private int txPwr;
        private boolean rxPwrSet;
        private int rxPwr;
        private boolean biasCurrentSet;
        private int biasCurrent;
        private boolean temperatureSet;
        private int temperature;

        BuilderWithParent(OFPortStatsPropOpticalVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public long getFlags() {
            return this.flags;
        }

        @Override
        public OFPortStatsPropOptical.Builder setFlags(long flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public long getTxFreqLmda() {
            return this.txFreqLmda;
        }

        @Override
        public OFPortStatsPropOptical.Builder setTxFreqLmda(long txFreqLmda) {
            this.txFreqLmda = txFreqLmda;
            this.txFreqLmdaSet = true;
            return this;
        }

        @Override
        public long getTxOffset() {
            return this.txOffset;
        }

        @Override
        public OFPortStatsPropOptical.Builder setTxOffset(long txOffset) {
            this.txOffset = txOffset;
            this.txOffsetSet = true;
            return this;
        }

        @Override
        public long getTxGridSpan() {
            return this.txGridSpan;
        }

        @Override
        public OFPortStatsPropOptical.Builder setTxGridSpan(long txGridSpan) {
            this.txGridSpan = txGridSpan;
            this.txGridSpanSet = true;
            return this;
        }

        @Override
        public long getRxFreqLmda() {
            return this.rxFreqLmda;
        }

        @Override
        public OFPortStatsPropOptical.Builder setRxFreqLmda(long rxFreqLmda) {
            this.rxFreqLmda = rxFreqLmda;
            this.rxFreqLmdaSet = true;
            return this;
        }

        @Override
        public long getRxOffset() {
            return this.rxOffset;
        }

        @Override
        public OFPortStatsPropOptical.Builder setRxOffset(long rxOffset) {
            this.rxOffset = rxOffset;
            this.rxOffsetSet = true;
            return this;
        }

        @Override
        public long getRxGridSpan() {
            return this.rxGridSpan;
        }

        @Override
        public OFPortStatsPropOptical.Builder setRxGridSpan(long rxGridSpan) {
            this.rxGridSpan = rxGridSpan;
            this.rxGridSpanSet = true;
            return this;
        }

        @Override
        public int getTxPwr() {
            return this.txPwr;
        }

        @Override
        public OFPortStatsPropOptical.Builder setTxPwr(int txPwr) {
            this.txPwr = txPwr;
            this.txPwrSet = true;
            return this;
        }

        @Override
        public int getRxPwr() {
            return this.rxPwr;
        }

        @Override
        public OFPortStatsPropOptical.Builder setRxPwr(int rxPwr) {
            this.rxPwr = rxPwr;
            this.rxPwrSet = true;
            return this;
        }

        @Override
        public int getBiasCurrent() {
            return this.biasCurrent;
        }

        @Override
        public OFPortStatsPropOptical.Builder setBiasCurrent(int biasCurrent) {
            this.biasCurrent = biasCurrent;
            this.biasCurrentSet = true;
            return this;
        }

        @Override
        public int getTemperature() {
            return this.temperature;
        }

        @Override
        public OFPortStatsPropOptical.Builder setTemperature(int temperature) {
            this.temperature = temperature;
            this.temperatureSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFPortStatsPropOptical build() {
            long flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            long txFreqLmda = this.txFreqLmdaSet ? this.txFreqLmda : this.parentMessage.txFreqLmda;
            long txOffset = this.txOffsetSet ? this.txOffset : this.parentMessage.txOffset;
            long txGridSpan = this.txGridSpanSet ? this.txGridSpan : this.parentMessage.txGridSpan;
            long rxFreqLmda = this.rxFreqLmdaSet ? this.rxFreqLmda : this.parentMessage.rxFreqLmda;
            long rxOffset = this.rxOffsetSet ? this.rxOffset : this.parentMessage.rxOffset;
            long rxGridSpan = this.rxGridSpanSet ? this.rxGridSpan : this.parentMessage.rxGridSpan;
            int txPwr = this.txPwrSet ? this.txPwr : this.parentMessage.txPwr;
            int rxPwr = this.rxPwrSet ? this.rxPwr : this.parentMessage.rxPwr;
            int biasCurrent = this.biasCurrentSet ? this.biasCurrent : this.parentMessage.biasCurrent;
            int temperature = this.temperatureSet ? this.temperature : this.parentMessage.temperature;
            return new OFPortStatsPropOpticalVer15(flags, txFreqLmda, txOffset, txGridSpan, rxFreqLmda, rxOffset, rxGridSpan, txPwr, rxPwr, biasCurrent, temperature);
        }
    }
}

