/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPortConfig;
import org.projectfloodlight.openflow.protocol.OFPortDesc;
import org.projectfloodlight.openflow.protocol.OFPortDescProp;
import org.projectfloodlight.openflow.protocol.OFPortDescPropBsnGenerationId;
import org.projectfloodlight.openflow.protocol.OFPortFeatures;
import org.projectfloodlight.openflow.protocol.OFPortState;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver15.OFPortConfigSerializerVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFPortDescPropVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFPortStateSerializerVer15;
import org.projectfloodlight.openflow.types.MacAddress;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U64;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFPortDescVer15
implements OFPortDesc {
    private static final Logger logger = LoggerFactory.getLogger(OFPortDescVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 40;
    private static final OFPort DEFAULT_PORT_NO = OFPort.ANY;
    private static final MacAddress DEFAULT_HW_ADDR = MacAddress.NONE;
    private static final String DEFAULT_NAME = "";
    private static final Set<OFPortConfig> DEFAULT_CONFIG = ImmutableSet.of();
    private static final Set<OFPortState> DEFAULT_STATE = ImmutableSet.of();
    private static final List<OFPortDescProp> DEFAULT_PROPERTIES = ImmutableList.of();
    private final OFPort portNo;
    private final MacAddress hwAddr;
    private final String name;
    private final Set<OFPortConfig> config;
    private final Set<OFPortState> state;
    private final List<OFPortDescProp> properties;
    static final OFPortDescVer15 DEFAULT = new OFPortDescVer15(DEFAULT_PORT_NO, DEFAULT_HW_ADDR, "", DEFAULT_CONFIG, DEFAULT_STATE, DEFAULT_PROPERTIES);
    static final Reader READER = new Reader();
    static final OFPortDescVer15Funnel FUNNEL = new OFPortDescVer15Funnel();
    static final Writer WRITER = new Writer();

    OFPortDescVer15(OFPort portNo, MacAddress hwAddr, String name, Set<OFPortConfig> config, Set<OFPortState> state, List<OFPortDescProp> properties) {
        if (portNo == null) {
            throw new NullPointerException("OFPortDescVer15: property portNo cannot be null");
        }
        if (hwAddr == null) {
            throw new NullPointerException("OFPortDescVer15: property hwAddr cannot be null");
        }
        if (name == null) {
            throw new NullPointerException("OFPortDescVer15: property name cannot be null");
        }
        if (config == null) {
            throw new NullPointerException("OFPortDescVer15: property config cannot be null");
        }
        if (state == null) {
            throw new NullPointerException("OFPortDescVer15: property state cannot be null");
        }
        if (properties == null) {
            throw new NullPointerException("OFPortDescVer15: property properties cannot be null");
        }
        this.portNo = portNo;
        this.hwAddr = hwAddr;
        this.name = name;
        this.config = config;
        this.state = state;
        this.properties = properties;
    }

    @Override
    public OFPort getPortNo() {
        return this.portNo;
    }

    @Override
    public MacAddress getHwAddr() {
        return this.hwAddr;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<OFPortConfig> getConfig() {
        return this.config;
    }

    @Override
    public Set<OFPortState> getState() {
        return this.state;
    }

    @Override
    public Set<OFPortFeatures> getCurr() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property curr not supported in version 1.5");
    }

    @Override
    public Set<OFPortFeatures> getAdvertised() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property advertised not supported in version 1.5");
    }

    @Override
    public Set<OFPortFeatures> getSupported() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property supported not supported in version 1.5");
    }

    @Override
    public Set<OFPortFeatures> getPeer() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property peer not supported in version 1.5");
    }

    @Override
    public long getCurrSpeed() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property currSpeed not supported in version 1.5");
    }

    @Override
    public long getMaxSpeed() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property maxSpeed not supported in version 1.5");
    }

    @Override
    public List<OFPortDescProp> getProperties() {
        return this.properties;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public boolean isEnabled() {
        return !this.state.contains((Object)OFPortState.LINK_DOWN) && !this.config.contains((Object)OFPortConfig.PORT_DOWN);
    }

    @Override
    @Nonnull
    public U64 getBsnGenerationId() {
        for (OFPortDescProp prop : this.getProperties()) {
            if (!(prop instanceof OFPortDescPropBsnGenerationId)) continue;
            return ((OFPortDescPropBsnGenerationId)prop).getGenerationId();
        }
        return U64.ZERO;
    }

    @Override
    public OFPortDesc.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFPortDescVer15(");
        b.append("portNo=").append(this.portNo);
        b.append(", ");
        b.append("hwAddr=").append(this.hwAddr);
        b.append(", ");
        b.append("name=").append(this.name);
        b.append(", ");
        b.append("config=").append(this.config);
        b.append(", ");
        b.append("state=").append(this.state);
        b.append(", ");
        b.append("properties=").append(this.properties);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPortDescVer15 other = (OFPortDescVer15)obj;
        if (this.portNo == null ? other.portNo != null : !this.portNo.equals(other.portNo)) {
            return false;
        }
        if (this.hwAddr == null ? other.hwAddr != null : !this.hwAddr.equals(other.hwAddr)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.config == null ? other.config != null : !this.config.equals(other.config)) {
            return false;
        }
        if (this.state == null ? other.state != null : !this.state.equals(other.state)) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.portNo == null ? 0 : this.portNo.hashCode());
        result = 31 * result + (this.hwAddr == null ? 0 : this.hwAddr.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.config == null ? 0 : this.config.hashCode());
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFPortDescVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFPortDescVer15 message) {
            int startIndex = bb.writerIndex();
            message.portNo.write4Bytes(bb);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeZero(2);
            message.hwAddr.write6Bytes(bb);
            bb.writeZero(2);
            ChannelUtils.writeFixedLengthString(bb, message.name, 16);
            OFPortConfigSerializerVer15.writeTo(bb, message.config);
            OFPortStateSerializerVer15.writeTo(bb, message.state);
            ChannelUtils.writeList(bb, message.properties);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFPortDescVer15Funnel
    implements Funnel<OFPortDescVer15> {
        private static final long serialVersionUID = 1L;

        OFPortDescVer15Funnel() {
        }

        public void funnel(OFPortDescVer15 message, PrimitiveSink sink) {
            message.portNo.putTo(sink);
            message.hwAddr.putTo(sink);
            sink.putUnencodedChars((CharSequence)message.name);
            OFPortConfigSerializerVer15.putTo(message.config, sink);
            OFPortStateSerializerVer15.putTo(message.state, sink);
            FunnelUtils.putList(message.properties, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFPortDesc> {
        Reader() {
        }

        @Override
        public OFPortDesc readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            OFPort portNo = OFPort.read4Bytes(bb);
            int length = U16.f(bb.readShort());
            if (length < 40) {
                throw new OFParseError("Wrong length: Expected to be >= 40, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            bb.skipBytes(2);
            MacAddress hwAddr = MacAddress.read6Bytes(bb);
            bb.skipBytes(2);
            String name = ChannelUtils.readFixedLengthString(bb, 16);
            Set<OFPortConfig> config = OFPortConfigSerializerVer15.readFrom(bb);
            Set<OFPortState> state = OFPortStateSerializerVer15.readFrom(bb);
            List<OFPortDescProp> properties = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFPortDescPropVer15.READER);
            OFPortDescVer15 portDescVer15 = new OFPortDescVer15(portNo, hwAddr, name, config, state, properties);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)portDescVer15);
            }
            return portDescVer15;
        }
    }

    static class Builder
    implements OFPortDesc.Builder {
        private boolean portNoSet;
        private OFPort portNo;
        private boolean hwAddrSet;
        private MacAddress hwAddr;
        private boolean nameSet;
        private String name;
        private boolean configSet;
        private Set<OFPortConfig> config;
        private boolean stateSet;
        private Set<OFPortState> state;
        private boolean propertiesSet;
        private List<OFPortDescProp> properties;

        Builder() {
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFPortDesc.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public MacAddress getHwAddr() {
            return this.hwAddr;
        }

        @Override
        public OFPortDesc.Builder setHwAddr(MacAddress hwAddr) {
            this.hwAddr = hwAddr;
            this.hwAddrSet = true;
            return this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public OFPortDesc.Builder setName(String name) {
            this.name = name;
            this.nameSet = true;
            return this;
        }

        @Override
        public Set<OFPortConfig> getConfig() {
            return this.config;
        }

        @Override
        public OFPortDesc.Builder setConfig(Set<OFPortConfig> config) {
            this.config = config;
            this.configSet = true;
            return this;
        }

        @Override
        public Set<OFPortState> getState() {
            return this.state;
        }

        @Override
        public OFPortDesc.Builder setState(Set<OFPortState> state) {
            this.state = state;
            this.stateSet = true;
            return this;
        }

        @Override
        public Set<OFPortFeatures> getCurr() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property curr not supported in version 1.5");
        }

        @Override
        public OFPortDesc.Builder setCurr(Set<OFPortFeatures> curr) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property curr not supported in version 1.5");
        }

        @Override
        public Set<OFPortFeatures> getAdvertised() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property advertised not supported in version 1.5");
        }

        @Override
        public OFPortDesc.Builder setAdvertised(Set<OFPortFeatures> advertised) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property advertised not supported in version 1.5");
        }

        @Override
        public Set<OFPortFeatures> getSupported() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property supported not supported in version 1.5");
        }

        @Override
        public OFPortDesc.Builder setSupported(Set<OFPortFeatures> supported) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property supported not supported in version 1.5");
        }

        @Override
        public Set<OFPortFeatures> getPeer() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property peer not supported in version 1.5");
        }

        @Override
        public OFPortDesc.Builder setPeer(Set<OFPortFeatures> peer) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property peer not supported in version 1.5");
        }

        @Override
        public long getCurrSpeed() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property currSpeed not supported in version 1.5");
        }

        @Override
        public OFPortDesc.Builder setCurrSpeed(long currSpeed) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property currSpeed not supported in version 1.5");
        }

        @Override
        public long getMaxSpeed() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property maxSpeed not supported in version 1.5");
        }

        @Override
        public OFPortDesc.Builder setMaxSpeed(long maxSpeed) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property maxSpeed not supported in version 1.5");
        }

        @Override
        public List<OFPortDescProp> getProperties() {
            return this.properties;
        }

        @Override
        public OFPortDesc.Builder setProperties(List<OFPortDescProp> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFPortDesc build() {
            List<OFPortDescProp> properties;
            Set<OFPortState> state;
            Set<OFPortConfig> config;
            String name;
            MacAddress hwAddr;
            OFPort portNo;
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : DEFAULT_PORT_NO;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            MacAddress macAddress = hwAddr = this.hwAddrSet ? this.hwAddr : DEFAULT_HW_ADDR;
            if (hwAddr == null) {
                throw new NullPointerException("Property hwAddr must not be null");
            }
            String string = name = this.nameSet ? this.name : OFPortDescVer15.DEFAULT_NAME;
            if (name == null) {
                throw new NullPointerException("Property name must not be null");
            }
            Set<OFPortConfig> set = config = this.configSet ? this.config : DEFAULT_CONFIG;
            if (config == null) {
                throw new NullPointerException("Property config must not be null");
            }
            Set<OFPortState> set2 = state = this.stateSet ? this.state : DEFAULT_STATE;
            if (state == null) {
                throw new NullPointerException("Property state must not be null");
            }
            List<OFPortDescProp> list = properties = this.propertiesSet ? this.properties : DEFAULT_PROPERTIES;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFPortDescVer15(portNo, hwAddr, name, config, state, properties);
        }
    }

    static class BuilderWithParent
    implements OFPortDesc.Builder {
        final OFPortDescVer15 parentMessage;
        private boolean portNoSet;
        private OFPort portNo;
        private boolean hwAddrSet;
        private MacAddress hwAddr;
        private boolean nameSet;
        private String name;
        private boolean configSet;
        private Set<OFPortConfig> config;
        private boolean stateSet;
        private Set<OFPortState> state;
        private boolean propertiesSet;
        private List<OFPortDescProp> properties;

        BuilderWithParent(OFPortDescVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFPortDesc.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public MacAddress getHwAddr() {
            return this.hwAddr;
        }

        @Override
        public OFPortDesc.Builder setHwAddr(MacAddress hwAddr) {
            this.hwAddr = hwAddr;
            this.hwAddrSet = true;
            return this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public OFPortDesc.Builder setName(String name) {
            this.name = name;
            this.nameSet = true;
            return this;
        }

        @Override
        public Set<OFPortConfig> getConfig() {
            return this.config;
        }

        @Override
        public OFPortDesc.Builder setConfig(Set<OFPortConfig> config) {
            this.config = config;
            this.configSet = true;
            return this;
        }

        @Override
        public Set<OFPortState> getState() {
            return this.state;
        }

        @Override
        public OFPortDesc.Builder setState(Set<OFPortState> state) {
            this.state = state;
            this.stateSet = true;
            return this;
        }

        @Override
        public Set<OFPortFeatures> getCurr() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property curr not supported in version 1.5");
        }

        @Override
        public OFPortDesc.Builder setCurr(Set<OFPortFeatures> curr) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property curr not supported in version 1.5");
        }

        @Override
        public Set<OFPortFeatures> getAdvertised() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property advertised not supported in version 1.5");
        }

        @Override
        public OFPortDesc.Builder setAdvertised(Set<OFPortFeatures> advertised) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property advertised not supported in version 1.5");
        }

        @Override
        public Set<OFPortFeatures> getSupported() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property supported not supported in version 1.5");
        }

        @Override
        public OFPortDesc.Builder setSupported(Set<OFPortFeatures> supported) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property supported not supported in version 1.5");
        }

        @Override
        public Set<OFPortFeatures> getPeer() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property peer not supported in version 1.5");
        }

        @Override
        public OFPortDesc.Builder setPeer(Set<OFPortFeatures> peer) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property peer not supported in version 1.5");
        }

        @Override
        public long getCurrSpeed() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property currSpeed not supported in version 1.5");
        }

        @Override
        public OFPortDesc.Builder setCurrSpeed(long currSpeed) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property currSpeed not supported in version 1.5");
        }

        @Override
        public long getMaxSpeed() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property maxSpeed not supported in version 1.5");
        }

        @Override
        public OFPortDesc.Builder setMaxSpeed(long maxSpeed) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property maxSpeed not supported in version 1.5");
        }

        @Override
        public List<OFPortDescProp> getProperties() {
            return this.properties;
        }

        @Override
        public OFPortDesc.Builder setProperties(List<OFPortDescProp> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFPortDesc build() {
            List properties;
            Set state;
            Set config;
            String name;
            MacAddress hwAddr;
            OFPort portNo;
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : this.parentMessage.portNo;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            MacAddress macAddress = hwAddr = this.hwAddrSet ? this.hwAddr : this.parentMessage.hwAddr;
            if (hwAddr == null) {
                throw new NullPointerException("Property hwAddr must not be null");
            }
            String string = name = this.nameSet ? this.name : this.parentMessage.name;
            if (name == null) {
                throw new NullPointerException("Property name must not be null");
            }
            Set set = config = this.configSet ? this.config : this.parentMessage.config;
            if (config == null) {
                throw new NullPointerException("Property config must not be null");
            }
            Set set2 = state = this.stateSet ? this.state : this.parentMessage.state;
            if (state == null) {
                throw new NullPointerException("Property state must not be null");
            }
            List list = properties = this.propertiesSet ? this.properties : this.parentMessage.properties;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFPortDescVer15(portNo, hwAddr, name, config, state, properties);
        }
    }
}

