/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnModuleEepromRecvSignalType;
import org.projectfloodlight.openflow.protocol.OFBsnUnit;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPortDescPropBsnDiag;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnModuleEepromRecvSignalTypeSerializerVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnUnitVer15;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFPortDescPropBsnDiagVer15
implements OFPortDescPropBsnDiag {
    private static final Logger logger = LoggerFactory.getLogger(OFPortDescPropBsnDiagVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 38;
    private static final Set<OFBsnModuleEepromRecvSignalType> DEFAULT_LASER_RECEIVER_POWER_TYPE = ImmutableSet.of();
    private final OFBsnUnit laserBiasCurr;
    private final OFBsnUnit laserOutputPower;
    private final Set<OFBsnModuleEepromRecvSignalType> laserReceiverPowerType;
    private final OFBsnUnit laserReceiverPower;
    private final OFBsnUnit moduleTemp;
    private final OFBsnUnit moduleVoltage;
    static final Reader READER = new Reader();
    static final OFPortDescPropBsnDiagVer15Funnel FUNNEL = new OFPortDescPropBsnDiagVer15Funnel();
    static final Writer WRITER = new Writer();

    OFPortDescPropBsnDiagVer15(OFBsnUnit laserBiasCurr, OFBsnUnit laserOutputPower, Set<OFBsnModuleEepromRecvSignalType> laserReceiverPowerType, OFBsnUnit laserReceiverPower, OFBsnUnit moduleTemp, OFBsnUnit moduleVoltage) {
        if (laserBiasCurr == null) {
            throw new NullPointerException("OFPortDescPropBsnDiagVer15: property laserBiasCurr cannot be null");
        }
        if (laserOutputPower == null) {
            throw new NullPointerException("OFPortDescPropBsnDiagVer15: property laserOutputPower cannot be null");
        }
        if (laserReceiverPowerType == null) {
            throw new NullPointerException("OFPortDescPropBsnDiagVer15: property laserReceiverPowerType cannot be null");
        }
        if (laserReceiverPower == null) {
            throw new NullPointerException("OFPortDescPropBsnDiagVer15: property laserReceiverPower cannot be null");
        }
        if (moduleTemp == null) {
            throw new NullPointerException("OFPortDescPropBsnDiagVer15: property moduleTemp cannot be null");
        }
        if (moduleVoltage == null) {
            throw new NullPointerException("OFPortDescPropBsnDiagVer15: property moduleVoltage cannot be null");
        }
        this.laserBiasCurr = laserBiasCurr;
        this.laserOutputPower = laserOutputPower;
        this.laserReceiverPowerType = laserReceiverPowerType;
        this.laserReceiverPower = laserReceiverPower;
        this.moduleTemp = moduleTemp;
        this.moduleVoltage = moduleVoltage;
    }

    @Override
    public int getType() {
        return 65535;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getExpType() {
        return 7L;
    }

    @Override
    public OFBsnUnit getLaserBiasCurr() {
        return this.laserBiasCurr;
    }

    @Override
    public OFBsnUnit getLaserOutputPower() {
        return this.laserOutputPower;
    }

    @Override
    public Set<OFBsnModuleEepromRecvSignalType> getLaserReceiverPowerType() {
        return this.laserReceiverPowerType;
    }

    @Override
    public OFBsnUnit getLaserReceiverPower() {
        return this.laserReceiverPower;
    }

    @Override
    public OFBsnUnit getModuleTemp() {
        return this.moduleTemp;
    }

    @Override
    public OFBsnUnit getModuleVoltage() {
        return this.moduleVoltage;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFPortDescPropBsnDiag.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFPortDescPropBsnDiagVer15(");
        b.append("laserBiasCurr=").append(this.laserBiasCurr);
        b.append(", ");
        b.append("laserOutputPower=").append(this.laserOutputPower);
        b.append(", ");
        b.append("laserReceiverPowerType=").append(this.laserReceiverPowerType);
        b.append(", ");
        b.append("laserReceiverPower=").append(this.laserReceiverPower);
        b.append(", ");
        b.append("moduleTemp=").append(this.moduleTemp);
        b.append(", ");
        b.append("moduleVoltage=").append(this.moduleVoltage);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPortDescPropBsnDiagVer15 other = (OFPortDescPropBsnDiagVer15)obj;
        if (this.laserBiasCurr == null ? other.laserBiasCurr != null : !this.laserBiasCurr.equals(other.laserBiasCurr)) {
            return false;
        }
        if (this.laserOutputPower == null ? other.laserOutputPower != null : !this.laserOutputPower.equals(other.laserOutputPower)) {
            return false;
        }
        if (this.laserReceiverPowerType == null ? other.laserReceiverPowerType != null : !this.laserReceiverPowerType.equals(other.laserReceiverPowerType)) {
            return false;
        }
        if (this.laserReceiverPower == null ? other.laserReceiverPower != null : !this.laserReceiverPower.equals(other.laserReceiverPower)) {
            return false;
        }
        if (this.moduleTemp == null ? other.moduleTemp != null : !this.moduleTemp.equals(other.moduleTemp)) {
            return false;
        }
        return !(this.moduleVoltage == null ? other.moduleVoltage != null : !this.moduleVoltage.equals(other.moduleVoltage));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.laserBiasCurr == null ? 0 : this.laserBiasCurr.hashCode());
        result = 31 * result + (this.laserOutputPower == null ? 0 : this.laserOutputPower.hashCode());
        result = 31 * result + (this.laserReceiverPowerType == null ? 0 : this.laserReceiverPowerType.hashCode());
        result = 31 * result + (this.laserReceiverPower == null ? 0 : this.laserReceiverPower.hashCode());
        result = 31 * result + (this.moduleTemp == null ? 0 : this.moduleTemp.hashCode());
        result = 31 * result + (this.moduleVoltage == null ? 0 : this.moduleVoltage.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFPortDescPropBsnDiagVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFPortDescPropBsnDiagVer15 message) {
            bb.writeShort(-1);
            bb.writeShort(38);
            bb.writeInt(6035143);
            bb.writeInt(7);
            message.laserBiasCurr.writeTo(bb);
            message.laserOutputPower.writeTo(bb);
            OFBsnModuleEepromRecvSignalTypeSerializerVer15.writeTo(bb, message.laserReceiverPowerType);
            message.laserReceiverPower.writeTo(bb);
            message.moduleTemp.writeTo(bb);
            message.moduleVoltage.writeTo(bb);
        }
    }

    static class OFPortDescPropBsnDiagVer15Funnel
    implements Funnel<OFPortDescPropBsnDiagVer15> {
        private static final long serialVersionUID = 1L;

        OFPortDescPropBsnDiagVer15Funnel() {
        }

        public void funnel(OFPortDescPropBsnDiagVer15 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putShort((short)38);
            sink.putInt(6035143);
            sink.putInt(7);
            message.laserBiasCurr.putTo(sink);
            message.laserOutputPower.putTo(sink);
            OFBsnModuleEepromRecvSignalTypeSerializerVer15.putTo(message.laserReceiverPowerType, sink);
            message.laserReceiverPower.putTo(sink);
            message.moduleTemp.putTo(sink);
            message.moduleVoltage.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFPortDescPropBsnDiag> {
        Reader() {
        }

        @Override
        public OFPortDescPropBsnDiag readFrom(ByteBuf bb) throws OFParseError {
            int experimenter;
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=0xffff(0xffff), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 38) {
                throw new OFParseError("Wrong length: Expected=38(38), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((experimenter = bb.readInt()) != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int expType = bb.readInt();
            if (expType != 7) {
                throw new OFParseError("Wrong expType: Expected=0x7L(0x7L), got=" + expType);
            }
            OFBsnUnit laserBiasCurr = OFBsnUnitVer15.READER.readFrom(bb);
            OFBsnUnit laserOutputPower = OFBsnUnitVer15.READER.readFrom(bb);
            Set<OFBsnModuleEepromRecvSignalType> laserReceiverPowerType = OFBsnModuleEepromRecvSignalTypeSerializerVer15.readFrom(bb);
            OFBsnUnit laserReceiverPower = OFBsnUnitVer15.READER.readFrom(bb);
            OFBsnUnit moduleTemp = OFBsnUnitVer15.READER.readFrom(bb);
            OFBsnUnit moduleVoltage = OFBsnUnitVer15.READER.readFrom(bb);
            OFPortDescPropBsnDiagVer15 portDescPropBsnDiagVer15 = new OFPortDescPropBsnDiagVer15(laserBiasCurr, laserOutputPower, laserReceiverPowerType, laserReceiverPower, moduleTemp, moduleVoltage);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)portDescPropBsnDiagVer15);
            }
            return portDescPropBsnDiagVer15;
        }
    }

    static class Builder
    implements OFPortDescPropBsnDiag.Builder {
        private boolean laserBiasCurrSet;
        private OFBsnUnit laserBiasCurr;
        private boolean laserOutputPowerSet;
        private OFBsnUnit laserOutputPower;
        private boolean laserReceiverPowerTypeSet;
        private Set<OFBsnModuleEepromRecvSignalType> laserReceiverPowerType;
        private boolean laserReceiverPowerSet;
        private OFBsnUnit laserReceiverPower;
        private boolean moduleTempSet;
        private OFBsnUnit moduleTemp;
        private boolean moduleVoltageSet;
        private OFBsnUnit moduleVoltage;

        Builder() {
        }

        @Override
        public int getType() {
            return 65535;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getExpType() {
            return 7L;
        }

        @Override
        public OFPortDescPropBsnDiag.Builder setExpType(long expType) {
            throw new UnsupportedOperationException("Property expType is not writeable");
        }

        @Override
        public OFBsnUnit getLaserBiasCurr() {
            return this.laserBiasCurr;
        }

        @Override
        public OFPortDescPropBsnDiag.Builder setLaserBiasCurr(OFBsnUnit laserBiasCurr) {
            this.laserBiasCurr = laserBiasCurr;
            this.laserBiasCurrSet = true;
            return this;
        }

        @Override
        public OFBsnUnit getLaserOutputPower() {
            return this.laserOutputPower;
        }

        @Override
        public OFPortDescPropBsnDiag.Builder setLaserOutputPower(OFBsnUnit laserOutputPower) {
            this.laserOutputPower = laserOutputPower;
            this.laserOutputPowerSet = true;
            return this;
        }

        @Override
        public Set<OFBsnModuleEepromRecvSignalType> getLaserReceiverPowerType() {
            return this.laserReceiverPowerType;
        }

        @Override
        public OFPortDescPropBsnDiag.Builder setLaserReceiverPowerType(Set<OFBsnModuleEepromRecvSignalType> laserReceiverPowerType) {
            this.laserReceiverPowerType = laserReceiverPowerType;
            this.laserReceiverPowerTypeSet = true;
            return this;
        }

        @Override
        public OFBsnUnit getLaserReceiverPower() {
            return this.laserReceiverPower;
        }

        @Override
        public OFPortDescPropBsnDiag.Builder setLaserReceiverPower(OFBsnUnit laserReceiverPower) {
            this.laserReceiverPower = laserReceiverPower;
            this.laserReceiverPowerSet = true;
            return this;
        }

        @Override
        public OFBsnUnit getModuleTemp() {
            return this.moduleTemp;
        }

        @Override
        public OFPortDescPropBsnDiag.Builder setModuleTemp(OFBsnUnit moduleTemp) {
            this.moduleTemp = moduleTemp;
            this.moduleTempSet = true;
            return this;
        }

        @Override
        public OFBsnUnit getModuleVoltage() {
            return this.moduleVoltage;
        }

        @Override
        public OFPortDescPropBsnDiag.Builder setModuleVoltage(OFBsnUnit moduleVoltage) {
            this.moduleVoltage = moduleVoltage;
            this.moduleVoltageSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFPortDescPropBsnDiag build() {
            Set<OFBsnModuleEepromRecvSignalType> laserReceiverPowerType;
            if (!this.laserBiasCurrSet) {
                throw new IllegalStateException("Property laserBiasCurr doesn't have default value -- must be set");
            }
            if (this.laserBiasCurr == null) {
                throw new NullPointerException("Property laserBiasCurr must not be null");
            }
            if (!this.laserOutputPowerSet) {
                throw new IllegalStateException("Property laserOutputPower doesn't have default value -- must be set");
            }
            if (this.laserOutputPower == null) {
                throw new NullPointerException("Property laserOutputPower must not be null");
            }
            Set<OFBsnModuleEepromRecvSignalType> set = laserReceiverPowerType = this.laserReceiverPowerTypeSet ? this.laserReceiverPowerType : DEFAULT_LASER_RECEIVER_POWER_TYPE;
            if (laserReceiverPowerType == null) {
                throw new NullPointerException("Property laserReceiverPowerType must not be null");
            }
            if (!this.laserReceiverPowerSet) {
                throw new IllegalStateException("Property laserReceiverPower doesn't have default value -- must be set");
            }
            if (this.laserReceiverPower == null) {
                throw new NullPointerException("Property laserReceiverPower must not be null");
            }
            if (!this.moduleTempSet) {
                throw new IllegalStateException("Property moduleTemp doesn't have default value -- must be set");
            }
            if (this.moduleTemp == null) {
                throw new NullPointerException("Property moduleTemp must not be null");
            }
            if (!this.moduleVoltageSet) {
                throw new IllegalStateException("Property moduleVoltage doesn't have default value -- must be set");
            }
            if (this.moduleVoltage == null) {
                throw new NullPointerException("Property moduleVoltage must not be null");
            }
            return new OFPortDescPropBsnDiagVer15(this.laserBiasCurr, this.laserOutputPower, laserReceiverPowerType, this.laserReceiverPower, this.moduleTemp, this.moduleVoltage);
        }
    }

    static class BuilderWithParent
    implements OFPortDescPropBsnDiag.Builder {
        final OFPortDescPropBsnDiagVer15 parentMessage;
        private boolean laserBiasCurrSet;
        private OFBsnUnit laserBiasCurr;
        private boolean laserOutputPowerSet;
        private OFBsnUnit laserOutputPower;
        private boolean laserReceiverPowerTypeSet;
        private Set<OFBsnModuleEepromRecvSignalType> laserReceiverPowerType;
        private boolean laserReceiverPowerSet;
        private OFBsnUnit laserReceiverPower;
        private boolean moduleTempSet;
        private OFBsnUnit moduleTemp;
        private boolean moduleVoltageSet;
        private OFBsnUnit moduleVoltage;

        BuilderWithParent(OFPortDescPropBsnDiagVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 65535;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getExpType() {
            return 7L;
        }

        @Override
        public OFPortDescPropBsnDiag.Builder setExpType(long expType) {
            throw new UnsupportedOperationException("Property expType is not writeable");
        }

        @Override
        public OFBsnUnit getLaserBiasCurr() {
            return this.laserBiasCurr;
        }

        @Override
        public OFPortDescPropBsnDiag.Builder setLaserBiasCurr(OFBsnUnit laserBiasCurr) {
            this.laserBiasCurr = laserBiasCurr;
            this.laserBiasCurrSet = true;
            return this;
        }

        @Override
        public OFBsnUnit getLaserOutputPower() {
            return this.laserOutputPower;
        }

        @Override
        public OFPortDescPropBsnDiag.Builder setLaserOutputPower(OFBsnUnit laserOutputPower) {
            this.laserOutputPower = laserOutputPower;
            this.laserOutputPowerSet = true;
            return this;
        }

        @Override
        public Set<OFBsnModuleEepromRecvSignalType> getLaserReceiverPowerType() {
            return this.laserReceiverPowerType;
        }

        @Override
        public OFPortDescPropBsnDiag.Builder setLaserReceiverPowerType(Set<OFBsnModuleEepromRecvSignalType> laserReceiverPowerType) {
            this.laserReceiverPowerType = laserReceiverPowerType;
            this.laserReceiverPowerTypeSet = true;
            return this;
        }

        @Override
        public OFBsnUnit getLaserReceiverPower() {
            return this.laserReceiverPower;
        }

        @Override
        public OFPortDescPropBsnDiag.Builder setLaserReceiverPower(OFBsnUnit laserReceiverPower) {
            this.laserReceiverPower = laserReceiverPower;
            this.laserReceiverPowerSet = true;
            return this;
        }

        @Override
        public OFBsnUnit getModuleTemp() {
            return this.moduleTemp;
        }

        @Override
        public OFPortDescPropBsnDiag.Builder setModuleTemp(OFBsnUnit moduleTemp) {
            this.moduleTemp = moduleTemp;
            this.moduleTempSet = true;
            return this;
        }

        @Override
        public OFBsnUnit getModuleVoltage() {
            return this.moduleVoltage;
        }

        @Override
        public OFPortDescPropBsnDiag.Builder setModuleVoltage(OFBsnUnit moduleVoltage) {
            this.moduleVoltage = moduleVoltage;
            this.moduleVoltageSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFPortDescPropBsnDiag build() {
            OFBsnUnit moduleVoltage;
            OFBsnUnit moduleTemp;
            OFBsnUnit laserReceiverPower;
            Set laserReceiverPowerType;
            OFBsnUnit laserOutputPower;
            OFBsnUnit laserBiasCurr;
            OFBsnUnit oFBsnUnit = laserBiasCurr = this.laserBiasCurrSet ? this.laserBiasCurr : this.parentMessage.laserBiasCurr;
            if (laserBiasCurr == null) {
                throw new NullPointerException("Property laserBiasCurr must not be null");
            }
            OFBsnUnit oFBsnUnit2 = laserOutputPower = this.laserOutputPowerSet ? this.laserOutputPower : this.parentMessage.laserOutputPower;
            if (laserOutputPower == null) {
                throw new NullPointerException("Property laserOutputPower must not be null");
            }
            Set set = laserReceiverPowerType = this.laserReceiverPowerTypeSet ? this.laserReceiverPowerType : this.parentMessage.laserReceiverPowerType;
            if (laserReceiverPowerType == null) {
                throw new NullPointerException("Property laserReceiverPowerType must not be null");
            }
            OFBsnUnit oFBsnUnit3 = laserReceiverPower = this.laserReceiverPowerSet ? this.laserReceiverPower : this.parentMessage.laserReceiverPower;
            if (laserReceiverPower == null) {
                throw new NullPointerException("Property laserReceiverPower must not be null");
            }
            OFBsnUnit oFBsnUnit4 = moduleTemp = this.moduleTempSet ? this.moduleTemp : this.parentMessage.moduleTemp;
            if (moduleTemp == null) {
                throw new NullPointerException("Property moduleTemp must not be null");
            }
            OFBsnUnit oFBsnUnit5 = moduleVoltage = this.moduleVoltageSet ? this.moduleVoltage : this.parentMessage.moduleVoltage;
            if (moduleVoltage == null) {
                throw new NullPointerException("Property moduleVoltage must not be null");
            }
            return new OFPortDescPropBsnDiagVer15(laserBiasCurr, laserOutputPower, laserReceiverPowerType, laserReceiverPower, moduleTemp, moduleVoltage);
        }
    }
}

