/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnModuleEepromAlarmSet;
import org.projectfloodlight.openflow.protocol.OFBsnModuleEepromDiagType;
import org.projectfloodlight.openflow.protocol.OFBsnUnitType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPortDescPropBsnAlarm;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnModuleEepromAlarmSetSerializerVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnModuleEepromDiagTypeSerializerVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnUnitTypeSerializerVer15;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFPortDescPropBsnAlarmVer15
implements OFPortDescPropBsnAlarm {
    private static final Logger logger = LoggerFactory.getLogger(OFPortDescPropBsnAlarmVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 31;
    private static final Set<OFBsnModuleEepromAlarmSet> DEFAULT_ALARM_SET = ImmutableSet.of();
    private static final long DEFAULT_HIGH = 0L;
    private static final long DEFAULT_HIGH_WARN = 0L;
    private static final long DEFAULT_LOW = 0L;
    private static final long DEFAULT_LOW_WARN = 0L;
    private static final Set<OFBsnModuleEepromDiagType> DEFAULT_ALARM_TYPE = ImmutableSet.of();
    private static final Set<OFBsnUnitType> DEFAULT_UNIT = ImmutableSet.of();
    private final Set<OFBsnModuleEepromAlarmSet> alarmSet;
    private final long high;
    private final long highWarn;
    private final long low;
    private final long lowWarn;
    private final Set<OFBsnModuleEepromDiagType> alarmType;
    private final Set<OFBsnUnitType> unit;
    static final OFPortDescPropBsnAlarmVer15 DEFAULT = new OFPortDescPropBsnAlarmVer15(DEFAULT_ALARM_SET, 0L, 0L, 0L, 0L, DEFAULT_ALARM_TYPE, DEFAULT_UNIT);
    static final Reader READER = new Reader();
    static final OFPortDescPropBsnAlarmVer15Funnel FUNNEL = new OFPortDescPropBsnAlarmVer15Funnel();
    static final Writer WRITER = new Writer();

    OFPortDescPropBsnAlarmVer15(Set<OFBsnModuleEepromAlarmSet> alarmSet, long high, long highWarn, long low, long lowWarn, Set<OFBsnModuleEepromDiagType> alarmType, Set<OFBsnUnitType> unit) {
        if (alarmSet == null) {
            throw new NullPointerException("OFPortDescPropBsnAlarmVer15: property alarmSet cannot be null");
        }
        if (alarmType == null) {
            throw new NullPointerException("OFPortDescPropBsnAlarmVer15: property alarmType cannot be null");
        }
        if (unit == null) {
            throw new NullPointerException("OFPortDescPropBsnAlarmVer15: property unit cannot be null");
        }
        this.alarmSet = alarmSet;
        this.high = high;
        this.highWarn = highWarn;
        this.low = low;
        this.lowWarn = lowWarn;
        this.alarmType = alarmType;
        this.unit = unit;
    }

    @Override
    public int getType() {
        return 65535;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getExpType() {
        return 8L;
    }

    @Override
    public Set<OFBsnModuleEepromAlarmSet> getAlarmSet() {
        return this.alarmSet;
    }

    @Override
    public long getHigh() {
        return this.high;
    }

    @Override
    public long getHighWarn() {
        return this.highWarn;
    }

    @Override
    public long getLow() {
        return this.low;
    }

    @Override
    public long getLowWarn() {
        return this.lowWarn;
    }

    @Override
    public Set<OFBsnModuleEepromDiagType> getAlarmType() {
        return this.alarmType;
    }

    @Override
    public Set<OFBsnUnitType> getUnit() {
        return this.unit;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFPortDescPropBsnAlarm.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFPortDescPropBsnAlarmVer15(");
        b.append("alarmSet=").append(this.alarmSet);
        b.append(", ");
        b.append("high=").append(this.high);
        b.append(", ");
        b.append("highWarn=").append(this.highWarn);
        b.append(", ");
        b.append("low=").append(this.low);
        b.append(", ");
        b.append("lowWarn=").append(this.lowWarn);
        b.append(", ");
        b.append("alarmType=").append(this.alarmType);
        b.append(", ");
        b.append("unit=").append(this.unit);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPortDescPropBsnAlarmVer15 other = (OFPortDescPropBsnAlarmVer15)obj;
        if (this.alarmSet == null ? other.alarmSet != null : !this.alarmSet.equals(other.alarmSet)) {
            return false;
        }
        if (this.high != other.high) {
            return false;
        }
        if (this.highWarn != other.highWarn) {
            return false;
        }
        if (this.low != other.low) {
            return false;
        }
        if (this.lowWarn != other.lowWarn) {
            return false;
        }
        if (this.alarmType == null ? other.alarmType != null : !this.alarmType.equals(other.alarmType)) {
            return false;
        }
        return !(this.unit == null ? other.unit != null : !this.unit.equals(other.unit));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.alarmSet == null ? 0 : this.alarmSet.hashCode());
        result = 31 * (int)(this.high ^ this.high >>> 32);
        result = 31 * (int)(this.highWarn ^ this.highWarn >>> 32);
        result = 31 * (int)(this.low ^ this.low >>> 32);
        result = 31 * (int)(this.lowWarn ^ this.lowWarn >>> 32);
        result = 31 * result + (this.alarmType == null ? 0 : this.alarmType.hashCode());
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFPortDescPropBsnAlarmVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFPortDescPropBsnAlarmVer15 message) {
            bb.writeShort(-1);
            bb.writeShort(31);
            bb.writeInt(6035143);
            bb.writeInt(8);
            OFBsnModuleEepromAlarmSetSerializerVer15.writeTo(bb, message.alarmSet);
            bb.writeInt(U32.t(message.high));
            bb.writeInt(U32.t(message.highWarn));
            bb.writeInt(U32.t(message.low));
            bb.writeInt(U32.t(message.lowWarn));
            OFBsnModuleEepromDiagTypeSerializerVer15.writeTo(bb, message.alarmType);
            OFBsnUnitTypeSerializerVer15.writeTo(bb, message.unit);
        }
    }

    static class OFPortDescPropBsnAlarmVer15Funnel
    implements Funnel<OFPortDescPropBsnAlarmVer15> {
        private static final long serialVersionUID = 1L;

        OFPortDescPropBsnAlarmVer15Funnel() {
        }

        public void funnel(OFPortDescPropBsnAlarmVer15 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putShort((short)31);
            sink.putInt(6035143);
            sink.putInt(8);
            OFBsnModuleEepromAlarmSetSerializerVer15.putTo(message.alarmSet, sink);
            sink.putLong(message.high);
            sink.putLong(message.highWarn);
            sink.putLong(message.low);
            sink.putLong(message.lowWarn);
            OFBsnModuleEepromDiagTypeSerializerVer15.putTo(message.alarmType, sink);
            OFBsnUnitTypeSerializerVer15.putTo(message.unit, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFPortDescPropBsnAlarm> {
        Reader() {
        }

        @Override
        public OFPortDescPropBsnAlarm readFrom(ByteBuf bb) throws OFParseError {
            int experimenter;
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=0xffff(0xffff), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 31) {
                throw new OFParseError("Wrong length: Expected=31(31), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((experimenter = bb.readInt()) != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int expType = bb.readInt();
            if (expType != 8) {
                throw new OFParseError("Wrong expType: Expected=0x8L(0x8L), got=" + expType);
            }
            Set<OFBsnModuleEepromAlarmSet> alarmSet = OFBsnModuleEepromAlarmSetSerializerVer15.readFrom(bb);
            long high = U32.f(bb.readInt());
            long highWarn = U32.f(bb.readInt());
            long low = U32.f(bb.readInt());
            long lowWarn = U32.f(bb.readInt());
            Set<OFBsnModuleEepromDiagType> alarmType = OFBsnModuleEepromDiagTypeSerializerVer15.readFrom(bb);
            Set<OFBsnUnitType> unit = OFBsnUnitTypeSerializerVer15.readFrom(bb);
            OFPortDescPropBsnAlarmVer15 portDescPropBsnAlarmVer15 = new OFPortDescPropBsnAlarmVer15(alarmSet, high, highWarn, low, lowWarn, alarmType, unit);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)portDescPropBsnAlarmVer15);
            }
            return portDescPropBsnAlarmVer15;
        }
    }

    static class Builder
    implements OFPortDescPropBsnAlarm.Builder {
        private boolean alarmSetSet;
        private Set<OFBsnModuleEepromAlarmSet> alarmSet;
        private boolean highSet;
        private long high;
        private boolean highWarnSet;
        private long highWarn;
        private boolean lowSet;
        private long low;
        private boolean lowWarnSet;
        private long lowWarn;
        private boolean alarmTypeSet;
        private Set<OFBsnModuleEepromDiagType> alarmType;
        private boolean unitSet;
        private Set<OFBsnUnitType> unit;

        Builder() {
        }

        @Override
        public int getType() {
            return 65535;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getExpType() {
            return 8L;
        }

        @Override
        public OFPortDescPropBsnAlarm.Builder setExpType(long expType) {
            throw new UnsupportedOperationException("Property expType is not writeable");
        }

        @Override
        public Set<OFBsnModuleEepromAlarmSet> getAlarmSet() {
            return this.alarmSet;
        }

        @Override
        public OFPortDescPropBsnAlarm.Builder setAlarmSet(Set<OFBsnModuleEepromAlarmSet> alarmSet) {
            this.alarmSet = alarmSet;
            this.alarmSetSet = true;
            return this;
        }

        @Override
        public long getHigh() {
            return this.high;
        }

        @Override
        public OFPortDescPropBsnAlarm.Builder setHigh(long high) {
            this.high = high;
            this.highSet = true;
            return this;
        }

        @Override
        public long getHighWarn() {
            return this.highWarn;
        }

        @Override
        public OFPortDescPropBsnAlarm.Builder setHighWarn(long highWarn) {
            this.highWarn = highWarn;
            this.highWarnSet = true;
            return this;
        }

        @Override
        public long getLow() {
            return this.low;
        }

        @Override
        public OFPortDescPropBsnAlarm.Builder setLow(long low) {
            this.low = low;
            this.lowSet = true;
            return this;
        }

        @Override
        public long getLowWarn() {
            return this.lowWarn;
        }

        @Override
        public OFPortDescPropBsnAlarm.Builder setLowWarn(long lowWarn) {
            this.lowWarn = lowWarn;
            this.lowWarnSet = true;
            return this;
        }

        @Override
        public Set<OFBsnModuleEepromDiagType> getAlarmType() {
            return this.alarmType;
        }

        @Override
        public OFPortDescPropBsnAlarm.Builder setAlarmType(Set<OFBsnModuleEepromDiagType> alarmType) {
            this.alarmType = alarmType;
            this.alarmTypeSet = true;
            return this;
        }

        @Override
        public Set<OFBsnUnitType> getUnit() {
            return this.unit;
        }

        @Override
        public OFPortDescPropBsnAlarm.Builder setUnit(Set<OFBsnUnitType> unit) {
            this.unit = unit;
            this.unitSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFPortDescPropBsnAlarm build() {
            Set<OFBsnUnitType> unit;
            Set<OFBsnModuleEepromDiagType> alarmType;
            Set<OFBsnModuleEepromAlarmSet> alarmSet;
            Set<OFBsnModuleEepromAlarmSet> set = alarmSet = this.alarmSetSet ? this.alarmSet : DEFAULT_ALARM_SET;
            if (alarmSet == null) {
                throw new NullPointerException("Property alarmSet must not be null");
            }
            long high = this.highSet ? this.high : 0L;
            long highWarn = this.highWarnSet ? this.highWarn : 0L;
            long low = this.lowSet ? this.low : 0L;
            long lowWarn = this.lowWarnSet ? this.lowWarn : 0L;
            Set<OFBsnModuleEepromDiagType> set2 = alarmType = this.alarmTypeSet ? this.alarmType : DEFAULT_ALARM_TYPE;
            if (alarmType == null) {
                throw new NullPointerException("Property alarmType must not be null");
            }
            Set<OFBsnUnitType> set3 = unit = this.unitSet ? this.unit : DEFAULT_UNIT;
            if (unit == null) {
                throw new NullPointerException("Property unit must not be null");
            }
            return new OFPortDescPropBsnAlarmVer15(alarmSet, high, highWarn, low, lowWarn, alarmType, unit);
        }
    }

    static class BuilderWithParent
    implements OFPortDescPropBsnAlarm.Builder {
        final OFPortDescPropBsnAlarmVer15 parentMessage;
        private boolean alarmSetSet;
        private Set<OFBsnModuleEepromAlarmSet> alarmSet;
        private boolean highSet;
        private long high;
        private boolean highWarnSet;
        private long highWarn;
        private boolean lowSet;
        private long low;
        private boolean lowWarnSet;
        private long lowWarn;
        private boolean alarmTypeSet;
        private Set<OFBsnModuleEepromDiagType> alarmType;
        private boolean unitSet;
        private Set<OFBsnUnitType> unit;

        BuilderWithParent(OFPortDescPropBsnAlarmVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 65535;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getExpType() {
            return 8L;
        }

        @Override
        public OFPortDescPropBsnAlarm.Builder setExpType(long expType) {
            throw new UnsupportedOperationException("Property expType is not writeable");
        }

        @Override
        public Set<OFBsnModuleEepromAlarmSet> getAlarmSet() {
            return this.alarmSet;
        }

        @Override
        public OFPortDescPropBsnAlarm.Builder setAlarmSet(Set<OFBsnModuleEepromAlarmSet> alarmSet) {
            this.alarmSet = alarmSet;
            this.alarmSetSet = true;
            return this;
        }

        @Override
        public long getHigh() {
            return this.high;
        }

        @Override
        public OFPortDescPropBsnAlarm.Builder setHigh(long high) {
            this.high = high;
            this.highSet = true;
            return this;
        }

        @Override
        public long getHighWarn() {
            return this.highWarn;
        }

        @Override
        public OFPortDescPropBsnAlarm.Builder setHighWarn(long highWarn) {
            this.highWarn = highWarn;
            this.highWarnSet = true;
            return this;
        }

        @Override
        public long getLow() {
            return this.low;
        }

        @Override
        public OFPortDescPropBsnAlarm.Builder setLow(long low) {
            this.low = low;
            this.lowSet = true;
            return this;
        }

        @Override
        public long getLowWarn() {
            return this.lowWarn;
        }

        @Override
        public OFPortDescPropBsnAlarm.Builder setLowWarn(long lowWarn) {
            this.lowWarn = lowWarn;
            this.lowWarnSet = true;
            return this;
        }

        @Override
        public Set<OFBsnModuleEepromDiagType> getAlarmType() {
            return this.alarmType;
        }

        @Override
        public OFPortDescPropBsnAlarm.Builder setAlarmType(Set<OFBsnModuleEepromDiagType> alarmType) {
            this.alarmType = alarmType;
            this.alarmTypeSet = true;
            return this;
        }

        @Override
        public Set<OFBsnUnitType> getUnit() {
            return this.unit;
        }

        @Override
        public OFPortDescPropBsnAlarm.Builder setUnit(Set<OFBsnUnitType> unit) {
            this.unit = unit;
            this.unitSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFPortDescPropBsnAlarm build() {
            Set unit;
            Set alarmType;
            Set alarmSet;
            Set set = alarmSet = this.alarmSetSet ? this.alarmSet : this.parentMessage.alarmSet;
            if (alarmSet == null) {
                throw new NullPointerException("Property alarmSet must not be null");
            }
            long high = this.highSet ? this.high : this.parentMessage.high;
            long highWarn = this.highWarnSet ? this.highWarn : this.parentMessage.highWarn;
            long low = this.lowSet ? this.low : this.parentMessage.low;
            long lowWarn = this.lowWarnSet ? this.lowWarn : this.parentMessage.lowWarn;
            Set set2 = alarmType = this.alarmTypeSet ? this.alarmType : this.parentMessage.alarmType;
            if (alarmType == null) {
                throw new NullPointerException("Property alarmType must not be null");
            }
            Set set3 = unit = this.unitSet ? this.unit : this.parentMessage.unit;
            if (unit == null) {
                throw new NullPointerException("Property unit must not be null");
            }
            return new OFPortDescPropBsnAlarmVer15(alarmSet, high, highWarn, low, lowWarn, alarmType, unit);
        }
    }
}

