/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.oxs.OFOxs;
import org.projectfloodlight.openflow.protocol.oxs.OFOxsFlowCount;
import org.projectfloodlight.openflow.protocol.stat.StatField;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxsFlowCountVer15
implements OFOxsFlowCount {
    private static final Logger logger = LoggerFactory.getLogger(OFOxsFlowCountVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 8;
    private static final U32 DEFAULT_VALUE = U32.ZERO;
    private final U32 value;
    static final OFOxsFlowCountVer15 DEFAULT = new OFOxsFlowCountVer15(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxsFlowCountVer15Funnel FUNNEL = new OFOxsFlowCountVer15Funnel();
    static final Writer WRITER = new Writer();

    OFOxsFlowCountVer15(U32 value) {
        if (value == null) {
            throw new NullPointerException("OFOxsFlowCountVer15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 2147615748L;
    }

    @Override
    public U32 getValue() {
        return this.value;
    }

    @Override
    public StatField<U32> getStatField() {
        return StatField.FLOW_COUNT;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxs<U32> getCanonical() {
        return this;
    }

    @Override
    public U32 getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.5");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFOxsFlowCount.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxsFlowCountVer15(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxsFlowCountVer15 other = (OFOxsFlowCountVer15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxsFlowCountVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxsFlowCountVer15 message) {
            bb.writeInt(-2147351548);
            bb.writeInt(message.value.getRaw());
        }
    }

    static class OFOxsFlowCountVer15Funnel
    implements Funnel<OFOxsFlowCountVer15> {
        private static final long serialVersionUID = 1L;

        OFOxsFlowCountVer15Funnel() {
        }

        public void funnel(OFOxsFlowCountVer15 message, PrimitiveSink sink) {
            sink.putInt(-2147351548);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxsFlowCount> {
        Reader() {
        }

        @Override
        public OFOxsFlowCount readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147351548) {
                throw new OFParseError("Wrong typeLen: Expected=0x80020404L(0x80020404L), got=" + typeLen);
            }
            U32 value = U32.of(bb.readInt());
            OFOxsFlowCountVer15 oxsFlowCountVer15 = new OFOxsFlowCountVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxsFlowCountVer15);
            }
            return oxsFlowCountVer15;
        }
    }

    static class Builder
    implements OFOxsFlowCount.Builder {
        private boolean valueSet;
        private U32 value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147615748L;
        }

        @Override
        public U32 getValue() {
            return this.value;
        }

        @Override
        public OFOxsFlowCount.Builder setValue(U32 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public StatField<U32> getStatField() {
            return StatField.FLOW_COUNT;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxs<U32> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public U32 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxsFlowCount build() {
            U32 value;
            U32 u32 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxsFlowCountVer15(value);
        }
    }

    static class BuilderWithParent
    implements OFOxsFlowCount.Builder {
        final OFOxsFlowCountVer15 parentMessage;
        private boolean valueSet;
        private U32 value;

        BuilderWithParent(OFOxsFlowCountVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147615748L;
        }

        @Override
        public U32 getValue() {
            return this.value;
        }

        @Override
        public OFOxsFlowCount.Builder setValue(U32 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public StatField<U32> getStatField() {
            return StatField.FLOW_COUNT;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxs<U32> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public U32 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxsFlowCount build() {
            U32 value;
            U32 u32 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxsFlowCountVer15(value);
        }
    }
}

