/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmTunnelId;
import org.projectfloodlight.openflow.types.U64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmTunnelIdVer15
implements OFOxmTunnelId {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmTunnelIdVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 12;
    private static final U64 DEFAULT_VALUE = U64.ZERO;
    private final U64 value;
    static final OFOxmTunnelIdVer15 DEFAULT = new OFOxmTunnelIdVer15(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmTunnelIdVer15Funnel FUNNEL = new OFOxmTunnelIdVer15Funnel();
    static final Writer WRITER = new Writer();

    OFOxmTunnelIdVer15(U64 value) {
        if (value == null) {
            throw new NullPointerException("OFOxmTunnelIdVer15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 2147503112L;
    }

    @Override
    public U64 getValue() {
        return this.value;
    }

    @Override
    public MatchField<U64> getMatchField() {
        return MatchField.TUNNEL_ID;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<U64> getCanonical() {
        return this;
    }

    @Override
    public U64 getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.5");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFOxmTunnelId.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmTunnelIdVer15(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmTunnelIdVer15 other = (OFOxmTunnelIdVer15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmTunnelIdVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmTunnelIdVer15 message) {
            bb.writeInt(-2147464184);
            bb.writeLong(message.value.getValue());
        }
    }

    static class OFOxmTunnelIdVer15Funnel
    implements Funnel<OFOxmTunnelIdVer15> {
        private static final long serialVersionUID = 1L;

        OFOxmTunnelIdVer15Funnel() {
        }

        public void funnel(OFOxmTunnelIdVer15 message, PrimitiveSink sink) {
            sink.putInt(-2147464184);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmTunnelId> {
        Reader() {
        }

        @Override
        public OFOxmTunnelId readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147464184) {
                throw new OFParseError("Wrong typeLen: Expected=0x80004c08L(0x80004c08L), got=" + typeLen);
            }
            U64 value = U64.ofRaw(bb.readLong());
            OFOxmTunnelIdVer15 oxmTunnelIdVer15 = new OFOxmTunnelIdVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmTunnelIdVer15);
            }
            return oxmTunnelIdVer15;
        }
    }

    static class Builder
    implements OFOxmTunnelId.Builder {
        private boolean valueSet;
        private U64 value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147503112L;
        }

        @Override
        public U64 getValue() {
            return this.value;
        }

        @Override
        public OFOxmTunnelId.Builder setValue(U64 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U64> getMatchField() {
            return MatchField.TUNNEL_ID;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U64> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public U64 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmTunnelId build() {
            U64 value;
            U64 u64 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmTunnelIdVer15(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmTunnelId.Builder {
        final OFOxmTunnelIdVer15 parentMessage;
        private boolean valueSet;
        private U64 value;

        BuilderWithParent(OFOxmTunnelIdVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147503112L;
        }

        @Override
        public U64 getValue() {
            return this.value;
        }

        @Override
        public OFOxmTunnelId.Builder setValue(U64 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U64> getMatchField() {
            return MatchField.TUNNEL_ID;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U64> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public U64 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmTunnelId build() {
            U64 value;
            U64 u64 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmTunnelIdVer15(value);
        }
    }
}

