/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmBsnInPorts128Masked;
import org.projectfloodlight.openflow.protocol.ver15.OFOxmBsnInPorts128Ver15;
import org.projectfloodlight.openflow.types.OFBitMask128;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmBsnInPorts128MaskedVer15
implements OFOxmBsnInPorts128Masked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmBsnInPorts128MaskedVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 36;
    private static final OFBitMask128 DEFAULT_VALUE = OFBitMask128.NONE;
    private static final OFBitMask128 DEFAULT_VALUE_MASK = OFBitMask128.NONE;
    private final OFBitMask128 value;
    private final OFBitMask128 mask;
    static final OFOxmBsnInPorts128MaskedVer15 DEFAULT = new OFOxmBsnInPorts128MaskedVer15(DEFAULT_VALUE, DEFAULT_VALUE_MASK);
    static final Reader READER = new Reader();
    static final OFOxmBsnInPorts128MaskedVer15Funnel FUNNEL = new OFOxmBsnInPorts128MaskedVer15Funnel();
    static final Writer WRITER = new Writer();

    OFOxmBsnInPorts128MaskedVer15(OFBitMask128 value, OFBitMask128 mask) {
        if (value == null) {
            throw new NullPointerException("OFOxmBsnInPorts128MaskedVer15: property value cannot be null");
        }
        if (mask == null) {
            throw new NullPointerException("OFOxmBsnInPorts128MaskedVer15: property mask cannot be null");
        }
        this.value = value;
        this.mask = mask;
    }

    @Override
    public long getTypeLen() {
        return 196896L;
    }

    @Override
    public OFBitMask128 getValue() {
        return this.value;
    }

    @Override
    public OFBitMask128 getMask() {
        return this.mask;
    }

    @Override
    public MatchField<OFBitMask128> getMatchField() {
        return MatchField.BSN_IN_PORTS_128;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<OFBitMask128> getCanonical() {
        if (OFBitMask128.NO_MASK.equals(this.mask)) {
            return new OFOxmBsnInPorts128Ver15(this.value);
        }
        if (OFBitMask128.FULL_MASK.equals(this.mask)) {
            return null;
        }
        return this;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFOxmBsnInPorts128Masked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmBsnInPorts128MaskedVer15(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmBsnInPorts128MaskedVer15 other = (OFOxmBsnInPorts128MaskedVer15)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.mask == null ? other.mask != null : !this.mask.equals(other.mask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmBsnInPorts128MaskedVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmBsnInPorts128MaskedVer15 message) {
            bb.writeInt(196896);
            message.value.write16Bytes(bb);
            message.mask.write16Bytes(bb);
        }
    }

    static class OFOxmBsnInPorts128MaskedVer15Funnel
    implements Funnel<OFOxmBsnInPorts128MaskedVer15> {
        private static final long serialVersionUID = 1L;

        OFOxmBsnInPorts128MaskedVer15Funnel() {
        }

        public void funnel(OFOxmBsnInPorts128MaskedVer15 message, PrimitiveSink sink) {
            sink.putInt(196896);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmBsnInPorts128Masked> {
        Reader() {
        }

        @Override
        public OFOxmBsnInPorts128Masked readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 196896) {
                throw new OFParseError("Wrong typeLen: Expected=0x30120L(0x30120L), got=" + typeLen);
            }
            OFBitMask128 value = OFBitMask128.read16Bytes(bb);
            OFBitMask128 mask = OFBitMask128.read16Bytes(bb);
            OFOxmBsnInPorts128MaskedVer15 oxmBsnInPorts128MaskedVer15 = new OFOxmBsnInPorts128MaskedVer15(value, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmBsnInPorts128MaskedVer15);
            }
            return oxmBsnInPorts128MaskedVer15;
        }
    }

    static class Builder
    implements OFOxmBsnInPorts128Masked.Builder {
        private boolean valueSet;
        private OFBitMask128 value;
        private boolean maskSet;
        private OFBitMask128 mask;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 196896L;
        }

        @Override
        public OFBitMask128 getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnInPorts128Masked.Builder setValue(OFBitMask128 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFBitMask128 getMask() {
            return this.mask;
        }

        @Override
        public OFOxmBsnInPorts128Masked.Builder setMask(OFBitMask128 mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<OFBitMask128> getMatchField() {
            return MatchField.BSN_IN_PORTS_128;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<OFBitMask128> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmBsnInPorts128Masked build() {
            OFBitMask128 mask;
            OFBitMask128 value;
            OFBitMask128 oFBitMask128 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            OFBitMask128 oFBitMask1282 = mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmBsnInPorts128MaskedVer15(value, mask);
        }
    }

    static class BuilderWithParent
    implements OFOxmBsnInPorts128Masked.Builder {
        final OFOxmBsnInPorts128MaskedVer15 parentMessage;
        private boolean valueSet;
        private OFBitMask128 value;
        private boolean maskSet;
        private OFBitMask128 mask;

        BuilderWithParent(OFOxmBsnInPorts128MaskedVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 196896L;
        }

        @Override
        public OFBitMask128 getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnInPorts128Masked.Builder setValue(OFBitMask128 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFBitMask128 getMask() {
            return this.mask;
        }

        @Override
        public OFOxmBsnInPorts128Masked.Builder setMask(OFBitMask128 mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<OFBitMask128> getMatchField() {
            return MatchField.BSN_IN_PORTS_128;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<OFBitMask128> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmBsnInPorts128Masked build() {
            OFBitMask128 mask;
            OFBitMask128 value;
            OFBitMask128 oFBitMask128 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            OFBitMask128 oFBitMask1282 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmBsnInPorts128MaskedVer15(value, mask);
        }
    }
}

