/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.instruction.OFInstruction;
import org.projectfloodlight.openflow.protocol.ver15.OFInstructionApplyActionsVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFInstructionClearActionsVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFInstructionExperimenterVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFInstructionGotoTableVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFInstructionStatTriggerVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFInstructionWriteActionsVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFInstructionWriteMetadataVer15;

abstract class OFInstructionVer15 {
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 4;
    public static final Reader READER = new Reader();

    OFInstructionVer15() {
    }

    static class Reader
    implements OFMessageReader<OFInstruction> {
        Reader() {
        }

        @Override
        public OFInstruction readFrom(ByteBuf bb) throws OFParseError {
            if (bb.readableBytes() < 4) {
                return null;
            }
            int start = bb.readerIndex();
            short type = bb.readShort();
            bb.readerIndex(start);
            switch (type) {
                case 4: {
                    return OFInstructionApplyActionsVer15.READER.readFrom(bb);
                }
                case 5: {
                    return OFInstructionClearActionsVer15.READER.readFrom(bb);
                }
                case -1: {
                    return OFInstructionExperimenterVer15.READER.readFrom(bb);
                }
                case 1: {
                    return OFInstructionGotoTableVer15.READER.readFrom(bb);
                }
                case 3: {
                    return OFInstructionWriteActionsVer15.READER.readFrom(bb);
                }
                case 2: {
                    return OFInstructionWriteMetadataVer15.READER.readFrom(bb);
                }
                case 7: {
                    return OFInstructionStatTriggerVer15.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator type of class OFInstructionVer15: " + type);
        }
    }
}

