/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFInstructionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFAction;
import org.projectfloodlight.openflow.protocol.instruction.OFInstructionApplyActions;
import org.projectfloodlight.openflow.protocol.ver15.OFActionVer15;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFInstructionApplyActionsVer15
implements OFInstructionApplyActions {
    private static final Logger logger = LoggerFactory.getLogger(OFInstructionApplyActionsVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 8;
    private static final List<OFAction> DEFAULT_ACTIONS = ImmutableList.of();
    private final List<OFAction> actions;
    static final OFInstructionApplyActionsVer15 DEFAULT = new OFInstructionApplyActionsVer15(DEFAULT_ACTIONS);
    static final Reader READER = new Reader();
    static final OFInstructionApplyActionsVer15Funnel FUNNEL = new OFInstructionApplyActionsVer15Funnel();
    static final Writer WRITER = new Writer();

    OFInstructionApplyActionsVer15(List<OFAction> actions) {
        if (actions == null) {
            throw new NullPointerException("OFInstructionApplyActionsVer15: property actions cannot be null");
        }
        this.actions = actions;
    }

    @Override
    public OFInstructionType getType() {
        return OFInstructionType.APPLY_ACTIONS;
    }

    @Override
    public List<OFAction> getActions() {
        return this.actions;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFInstructionApplyActions.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFInstructionApplyActionsVer15(");
        b.append("actions=").append(this.actions);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFInstructionApplyActionsVer15 other = (OFInstructionApplyActionsVer15)obj;
        return !(this.actions == null ? other.actions != null : !this.actions.equals(other.actions));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.actions == null ? 0 : this.actions.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFInstructionApplyActionsVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFInstructionApplyActionsVer15 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(4);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeZero(4);
            ChannelUtils.writeList(bb, message.actions);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFInstructionApplyActionsVer15Funnel
    implements Funnel<OFInstructionApplyActionsVer15> {
        private static final long serialVersionUID = 1L;

        OFInstructionApplyActionsVer15Funnel() {
        }

        public void funnel(OFInstructionApplyActionsVer15 message, PrimitiveSink sink) {
            sink.putShort((short)4);
            FunnelUtils.putList(message.actions, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFInstructionApplyActions> {
        Reader() {
        }

        @Override
        public OFInstructionApplyActions readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFInstructionType.APPLY_ACTIONS(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 8) {
                throw new OFParseError("Wrong length: Expected to be >= 8, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            bb.skipBytes(4);
            List<OFAction> actions = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFActionVer15.READER);
            OFInstructionApplyActionsVer15 instructionApplyActionsVer15 = new OFInstructionApplyActionsVer15(actions);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)instructionApplyActionsVer15);
            }
            return instructionApplyActionsVer15;
        }
    }

    static class Builder
    implements OFInstructionApplyActions.Builder {
        private boolean actionsSet;
        private List<OFAction> actions;

        Builder() {
        }

        @Override
        public OFInstructionType getType() {
            return OFInstructionType.APPLY_ACTIONS;
        }

        @Override
        public List<OFAction> getActions() {
            return this.actions;
        }

        @Override
        public OFInstructionApplyActions.Builder setActions(List<OFAction> actions) {
            this.actions = actions;
            this.actionsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFInstructionApplyActions build() {
            List<OFAction> actions;
            List<OFAction> list = actions = this.actionsSet ? this.actions : DEFAULT_ACTIONS;
            if (actions == null) {
                throw new NullPointerException("Property actions must not be null");
            }
            return new OFInstructionApplyActionsVer15(actions);
        }
    }

    static class BuilderWithParent
    implements OFInstructionApplyActions.Builder {
        final OFInstructionApplyActionsVer15 parentMessage;
        private boolean actionsSet;
        private List<OFAction> actions;

        BuilderWithParent(OFInstructionApplyActionsVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFInstructionType getType() {
            return OFInstructionType.APPLY_ACTIONS;
        }

        @Override
        public List<OFAction> getActions() {
            return this.actions;
        }

        @Override
        public OFInstructionApplyActions.Builder setActions(List<OFAction> actions) {
            this.actions = actions;
            this.actionsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFInstructionApplyActions build() {
            List actions;
            List list = actions = this.actionsSet ? this.actions : this.parentMessage.actions;
            if (actions == null) {
                throw new NullPointerException("Property actions must not be null");
            }
            return new OFInstructionApplyActionsVer15(actions);
        }
    }
}

