/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFHelloElemVersionbitmap;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFHelloElemVersionbitmapVer15
implements OFHelloElemVersionbitmap {
    private static final Logger logger = LoggerFactory.getLogger(OFHelloElemVersionbitmapVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 4;
    private static final List<U32> DEFAULT_BITMAPS = ImmutableList.of();
    private final List<U32> bitmaps;
    static final OFHelloElemVersionbitmapVer15 DEFAULT = new OFHelloElemVersionbitmapVer15(DEFAULT_BITMAPS);
    static final Reader READER = new Reader();
    static final OFHelloElemVersionbitmapVer15Funnel FUNNEL = new OFHelloElemVersionbitmapVer15Funnel();
    static final Writer WRITER = new Writer();

    OFHelloElemVersionbitmapVer15(List<U32> bitmaps) {
        if (bitmaps == null) {
            throw new NullPointerException("OFHelloElemVersionbitmapVer15: property bitmaps cannot be null");
        }
        this.bitmaps = bitmaps;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public List<U32> getBitmaps() {
        return this.bitmaps;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFHelloElemVersionbitmap.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFHelloElemVersionbitmapVer15(");
        b.append("bitmaps=").append(this.bitmaps);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFHelloElemVersionbitmapVer15 other = (OFHelloElemVersionbitmapVer15)obj;
        return !(this.bitmaps == null ? other.bitmaps != null : !this.bitmaps.equals(other.bitmaps));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bitmaps == null ? 0 : this.bitmaps.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFHelloElemVersionbitmapVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFHelloElemVersionbitmapVer15 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(1);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            ChannelUtils.writeList(bb, message.bitmaps);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFHelloElemVersionbitmapVer15Funnel
    implements Funnel<OFHelloElemVersionbitmapVer15> {
        private static final long serialVersionUID = 1L;

        OFHelloElemVersionbitmapVer15Funnel() {
        }

        public void funnel(OFHelloElemVersionbitmapVer15 message, PrimitiveSink sink) {
            sink.putShort((short)1);
            FunnelUtils.putList(message.bitmaps, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFHelloElemVersionbitmap> {
        Reader() {
        }

        @Override
        public OFHelloElemVersionbitmap readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 1) {
                throw new OFParseError("Wrong type: Expected=0x1(0x1), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 4) {
                throw new OFParseError("Wrong length: Expected to be >= 4, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            List<U32> bitmaps = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), U32.READER);
            OFHelloElemVersionbitmapVer15 helloElemVersionbitmapVer15 = new OFHelloElemVersionbitmapVer15(bitmaps);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)helloElemVersionbitmapVer15);
            }
            return helloElemVersionbitmapVer15;
        }
    }

    static class Builder
    implements OFHelloElemVersionbitmap.Builder {
        private boolean bitmapsSet;
        private List<U32> bitmaps;

        Builder() {
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public List<U32> getBitmaps() {
            return this.bitmaps;
        }

        @Override
        public OFHelloElemVersionbitmap.Builder setBitmaps(List<U32> bitmaps) {
            this.bitmaps = bitmaps;
            this.bitmapsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFHelloElemVersionbitmap build() {
            List<U32> bitmaps;
            List<U32> list = bitmaps = this.bitmapsSet ? this.bitmaps : DEFAULT_BITMAPS;
            if (bitmaps == null) {
                throw new NullPointerException("Property bitmaps must not be null");
            }
            return new OFHelloElemVersionbitmapVer15(bitmaps);
        }
    }

    static class BuilderWithParent
    implements OFHelloElemVersionbitmap.Builder {
        final OFHelloElemVersionbitmapVer15 parentMessage;
        private boolean bitmapsSet;
        private List<U32> bitmaps;

        BuilderWithParent(OFHelloElemVersionbitmapVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public List<U32> getBitmaps() {
            return this.bitmaps;
        }

        @Override
        public OFHelloElemVersionbitmap.Builder setBitmaps(List<U32> bitmaps) {
            this.bitmaps = bitmaps;
            this.bitmapsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFHelloElemVersionbitmap build() {
            List bitmaps;
            List list = bitmaps = this.bitmapsSet ? this.bitmaps : this.parentMessage.bitmaps;
            if (bitmaps == null) {
                throw new NullPointerException("Property bitmaps must not be null");
            }
            return new OFHelloElemVersionbitmapVer15(bitmaps);
        }
    }
}

