/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBucket;
import org.projectfloodlight.openflow.protocol.OFGroupDescStatsEntry;
import org.projectfloodlight.openflow.protocol.OFGroupProp;
import org.projectfloodlight.openflow.protocol.OFGroupType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver15.OFBucketVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFGroupPropVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFGroupTypeSerializerVer15;
import org.projectfloodlight.openflow.types.OFGroup;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFGroupDescStatsEntryVer15
implements OFGroupDescStatsEntry {
    private static final Logger logger = LoggerFactory.getLogger(OFGroupDescStatsEntryVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 16;
    private static final OFGroup DEFAULT_GROUP_ID = OFGroup.ALL;
    private static final List<OFBucket> DEFAULT_BUCKETS = ImmutableList.of();
    private static final List<OFGroupProp> DEFAULT_PROPERTIES = ImmutableList.of();
    private final OFGroupType groupType;
    private final OFGroup group;
    private final List<OFBucket> buckets;
    private final List<OFGroupProp> properties;
    static final Reader READER = new Reader();
    static final OFGroupDescStatsEntryVer15Funnel FUNNEL = new OFGroupDescStatsEntryVer15Funnel();
    static final Writer WRITER = new Writer();

    OFGroupDescStatsEntryVer15(OFGroupType groupType, OFGroup group, List<OFBucket> buckets, List<OFGroupProp> properties) {
        if (groupType == null) {
            throw new NullPointerException("OFGroupDescStatsEntryVer15: property groupType cannot be null");
        }
        if (group == null) {
            throw new NullPointerException("OFGroupDescStatsEntryVer15: property group cannot be null");
        }
        if (buckets == null) {
            throw new NullPointerException("OFGroupDescStatsEntryVer15: property buckets cannot be null");
        }
        if (properties == null) {
            throw new NullPointerException("OFGroupDescStatsEntryVer15: property properties cannot be null");
        }
        this.groupType = groupType;
        this.group = group;
        this.buckets = buckets;
        this.properties = properties;
    }

    @Override
    public OFGroupType getGroupType() {
        return this.groupType;
    }

    @Override
    public OFGroup getGroup() {
        return this.group;
    }

    @Override
    public List<OFBucket> getBuckets() {
        return this.buckets;
    }

    @Override
    public List<OFGroupProp> getProperties() {
        return this.properties;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFGroupDescStatsEntry.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFGroupDescStatsEntryVer15(");
        b.append("groupType=").append((Object)this.groupType);
        b.append(", ");
        b.append("group=").append(this.group);
        b.append(", ");
        b.append("buckets=").append(this.buckets);
        b.append(", ");
        b.append("properties=").append(this.properties);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFGroupDescStatsEntryVer15 other = (OFGroupDescStatsEntryVer15)obj;
        if (this.groupType == null ? other.groupType != null : !this.groupType.equals((Object)other.groupType)) {
            return false;
        }
        if (this.group == null ? other.group != null : !this.group.equals(other.group)) {
            return false;
        }
        if (this.buckets == null ? other.buckets != null : !this.buckets.equals(other.buckets)) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.groupType == null ? 0 : this.groupType.hashCode());
        result = 31 * result + (this.group == null ? 0 : this.group.hashCode());
        result = 31 * result + (this.buckets == null ? 0 : this.buckets.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFGroupDescStatsEntryVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFGroupDescStatsEntryVer15 message) {
            int startIndex = bb.writerIndex();
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            OFGroupTypeSerializerVer15.writeTo(bb, message.groupType);
            bb.writeZero(1);
            message.group.write4Bytes(bb);
            int bucketArrayLenIndex = bb.writerIndex();
            bb.writeShort(0);
            bb.writeZero(6);
            int bucketsStartIndex = bb.writerIndex();
            ChannelUtils.writeList(bb, message.buckets);
            int bucketsLength = bb.writerIndex() - bucketsStartIndex;
            bb.setShort(bucketArrayLenIndex, bucketsLength);
            ChannelUtils.writeList(bb, message.properties);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFGroupDescStatsEntryVer15Funnel
    implements Funnel<OFGroupDescStatsEntryVer15> {
        private static final long serialVersionUID = 1L;

        OFGroupDescStatsEntryVer15Funnel() {
        }

        public void funnel(OFGroupDescStatsEntryVer15 message, PrimitiveSink sink) {
            OFGroupTypeSerializerVer15.putTo(message.groupType, sink);
            message.group.putTo(sink);
            FunnelUtils.putList(message.buckets, sink);
            FunnelUtils.putList(message.properties, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFGroupDescStatsEntry> {
        Reader() {
        }

        @Override
        public OFGroupDescStatsEntry readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFGroupType groupType = OFGroupTypeSerializerVer15.readFrom(bb);
            bb.skipBytes(1);
            OFGroup group = OFGroup.read4Bytes(bb);
            int bucketArrayLen = U16.f(bb.readShort());
            bb.skipBytes(6);
            List<OFBucket> buckets = ChannelUtils.readList(bb, bucketArrayLen, OFBucketVer15.READER);
            List<OFGroupProp> properties = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFGroupPropVer15.READER);
            OFGroupDescStatsEntryVer15 groupDescStatsEntryVer15 = new OFGroupDescStatsEntryVer15(groupType, group, buckets, properties);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)groupDescStatsEntryVer15);
            }
            return groupDescStatsEntryVer15;
        }
    }

    static class Builder
    implements OFGroupDescStatsEntry.Builder {
        private boolean groupTypeSet;
        private OFGroupType groupType;
        private boolean groupSet;
        private OFGroup group;
        private boolean bucketsSet;
        private List<OFBucket> buckets;
        private boolean propertiesSet;
        private List<OFGroupProp> properties;

        Builder() {
        }

        @Override
        public OFGroupType getGroupType() {
            return this.groupType;
        }

        @Override
        public OFGroupDescStatsEntry.Builder setGroupType(OFGroupType groupType) {
            this.groupType = groupType;
            this.groupTypeSet = true;
            return this;
        }

        @Override
        public OFGroup getGroup() {
            return this.group;
        }

        @Override
        public OFGroupDescStatsEntry.Builder setGroup(OFGroup group) {
            this.group = group;
            this.groupSet = true;
            return this;
        }

        @Override
        public List<OFBucket> getBuckets() {
            return this.buckets;
        }

        @Override
        public OFGroupDescStatsEntry.Builder setBuckets(List<OFBucket> buckets) {
            this.buckets = buckets;
            this.bucketsSet = true;
            return this;
        }

        @Override
        public List<OFGroupProp> getProperties() {
            return this.properties;
        }

        @Override
        public OFGroupDescStatsEntry.Builder setProperties(List<OFGroupProp> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFGroupDescStatsEntry build() {
            List<OFGroupProp> properties;
            List<OFBucket> buckets;
            OFGroup group;
            if (!this.groupTypeSet) {
                throw new IllegalStateException("Property groupType doesn't have default value -- must be set");
            }
            if (this.groupType == null) {
                throw new NullPointerException("Property groupType must not be null");
            }
            OFGroup oFGroup = group = this.groupSet ? this.group : DEFAULT_GROUP_ID;
            if (group == null) {
                throw new NullPointerException("Property group must not be null");
            }
            List<OFBucket> list = buckets = this.bucketsSet ? this.buckets : DEFAULT_BUCKETS;
            if (buckets == null) {
                throw new NullPointerException("Property buckets must not be null");
            }
            List<OFGroupProp> list2 = properties = this.propertiesSet ? this.properties : DEFAULT_PROPERTIES;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFGroupDescStatsEntryVer15(this.groupType, group, buckets, properties);
        }
    }

    static class BuilderWithParent
    implements OFGroupDescStatsEntry.Builder {
        final OFGroupDescStatsEntryVer15 parentMessage;
        private boolean groupTypeSet;
        private OFGroupType groupType;
        private boolean groupSet;
        private OFGroup group;
        private boolean bucketsSet;
        private List<OFBucket> buckets;
        private boolean propertiesSet;
        private List<OFGroupProp> properties;

        BuilderWithParent(OFGroupDescStatsEntryVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFGroupType getGroupType() {
            return this.groupType;
        }

        @Override
        public OFGroupDescStatsEntry.Builder setGroupType(OFGroupType groupType) {
            this.groupType = groupType;
            this.groupTypeSet = true;
            return this;
        }

        @Override
        public OFGroup getGroup() {
            return this.group;
        }

        @Override
        public OFGroupDescStatsEntry.Builder setGroup(OFGroup group) {
            this.group = group;
            this.groupSet = true;
            return this;
        }

        @Override
        public List<OFBucket> getBuckets() {
            return this.buckets;
        }

        @Override
        public OFGroupDescStatsEntry.Builder setBuckets(List<OFBucket> buckets) {
            this.buckets = buckets;
            this.bucketsSet = true;
            return this;
        }

        @Override
        public List<OFGroupProp> getProperties() {
            return this.properties;
        }

        @Override
        public OFGroupDescStatsEntry.Builder setProperties(List<OFGroupProp> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFGroupDescStatsEntry build() {
            List properties;
            List buckets;
            OFGroup group;
            OFGroupType groupType;
            OFGroupType oFGroupType = groupType = this.groupTypeSet ? this.groupType : this.parentMessage.groupType;
            if (groupType == null) {
                throw new NullPointerException("Property groupType must not be null");
            }
            OFGroup oFGroup = group = this.groupSet ? this.group : this.parentMessage.group;
            if (group == null) {
                throw new NullPointerException("Property group must not be null");
            }
            List list = buckets = this.bucketsSet ? this.buckets : this.parentMessage.buckets;
            if (buckets == null) {
                throw new NullPointerException("Property buckets must not be null");
            }
            List list2 = properties = this.propertiesSet ? this.properties : this.parentMessage.properties;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFGroupDescStatsEntryVer15(groupType, group, buckets, properties);
        }
    }
}

