/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBucket;
import org.projectfloodlight.openflow.protocol.OFGroupBucket;
import org.projectfloodlight.openflow.protocol.OFGroupDelete;
import org.projectfloodlight.openflow.protocol.OFGroupModCommand;
import org.projectfloodlight.openflow.protocol.OFGroupProp;
import org.projectfloodlight.openflow.protocol.OFGroupType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver15.OFBucketVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFGroupBucketSerializerVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFGroupPropVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFGroupTypeSerializerVer15;
import org.projectfloodlight.openflow.types.OFGroup;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFGroupDeleteVer15
implements OFGroupDelete {
    private static final Logger logger = LoggerFactory.getLogger(OFGroupDeleteVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 24;
    private static final long DEFAULT_XID = 0L;
    private static final OFGroup DEFAULT_GROUP_ID = OFGroup.ALL;
    private static final List<OFBucket> DEFAULT_BUCKETS = ImmutableList.of();
    private static final List<OFGroupProp> DEFAULT_PROPERTIES = ImmutableList.of();
    private final long xid;
    private final OFGroupType groupType;
    private final OFGroup group;
    private final OFGroupBucket commandBucketId;
    private final List<OFBucket> buckets;
    private final List<OFGroupProp> properties;
    static final Reader READER = new Reader();
    static final OFGroupDeleteVer15Funnel FUNNEL = new OFGroupDeleteVer15Funnel();
    static final Writer WRITER = new Writer();

    OFGroupDeleteVer15(long xid, OFGroupType groupType, OFGroup group, OFGroupBucket commandBucketId, List<OFBucket> buckets, List<OFGroupProp> properties) {
        if (groupType == null) {
            throw new NullPointerException("OFGroupDeleteVer15: property groupType cannot be null");
        }
        if (group == null) {
            throw new NullPointerException("OFGroupDeleteVer15: property group cannot be null");
        }
        if (commandBucketId == null) {
            throw new NullPointerException("OFGroupDeleteVer15: property commandBucketId cannot be null");
        }
        if (buckets == null) {
            throw new NullPointerException("OFGroupDeleteVer15: property buckets cannot be null");
        }
        if (properties == null) {
            throw new NullPointerException("OFGroupDeleteVer15: property properties cannot be null");
        }
        this.xid = xid;
        this.groupType = groupType;
        this.group = group;
        this.commandBucketId = commandBucketId;
        this.buckets = buckets;
        this.properties = properties;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFType getType() {
        return OFType.GROUP_MOD;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFGroupModCommand getCommand() {
        return OFGroupModCommand.DELETE;
    }

    @Override
    public OFGroupType getGroupType() {
        return this.groupType;
    }

    @Override
    public OFGroup getGroup() {
        return this.group;
    }

    @Override
    public List<OFBucket> getBuckets() {
        return this.buckets;
    }

    @Override
    public OFGroupBucket getCommandBucketId() {
        return this.commandBucketId;
    }

    @Override
    public List<OFGroupProp> getProperties() {
        return this.properties;
    }

    @Override
    public OFGroupDelete.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFGroupDeleteVer15(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("groupType=").append((Object)this.groupType);
        b.append(", ");
        b.append("group=").append(this.group);
        b.append(", ");
        b.append("commandBucketId=").append((Object)this.commandBucketId);
        b.append(", ");
        b.append("buckets=").append(this.buckets);
        b.append(", ");
        b.append("properties=").append(this.properties);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFGroupDeleteVer15 other = (OFGroupDeleteVer15)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.groupType == null ? other.groupType != null : !this.groupType.equals((Object)other.groupType)) {
            return false;
        }
        if (this.group == null ? other.group != null : !this.group.equals(other.group)) {
            return false;
        }
        if (this.commandBucketId == null ? other.commandBucketId != null : !this.commandBucketId.equals((Object)other.commandBucketId)) {
            return false;
        }
        if (this.buckets == null ? other.buckets != null : !this.buckets.equals(other.buckets)) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFGroupDeleteVer15 other = (OFGroupDeleteVer15)obj;
        if (this.groupType == null ? other.groupType != null : !this.groupType.equals((Object)other.groupType)) {
            return false;
        }
        if (this.group == null ? other.group != null : !this.group.equals(other.group)) {
            return false;
        }
        if (this.commandBucketId == null ? other.commandBucketId != null : !this.commandBucketId.equals((Object)other.commandBucketId)) {
            return false;
        }
        if (this.buckets == null ? other.buckets != null : !this.buckets.equals(other.buckets)) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.groupType == null ? 0 : this.groupType.hashCode());
        result = 31 * result + (this.group == null ? 0 : this.group.hashCode());
        result = 31 * result + (this.commandBucketId == null ? 0 : this.commandBucketId.hashCode());
        result = 31 * result + (this.buckets == null ? 0 : this.buckets.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.groupType == null ? 0 : this.groupType.hashCode());
        result = 31 * result + (this.group == null ? 0 : this.group.hashCode());
        result = 31 * result + (this.commandBucketId == null ? 0 : this.commandBucketId.hashCode());
        result = 31 * result + (this.buckets == null ? 0 : this.buckets.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFGroupDeleteVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFGroupDeleteVer15 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(6);
            bb.writeByte(15);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            bb.writeShort(2);
            OFGroupTypeSerializerVer15.writeTo(bb, message.groupType);
            bb.writeZero(1);
            message.group.write4Bytes(bb);
            int bucketArrayLenIndex = bb.writerIndex();
            bb.writeShort(0);
            bb.writeZero(2);
            OFGroupBucketSerializerVer15.writeTo(bb, message.commandBucketId);
            int bucketsStartIndex = bb.writerIndex();
            ChannelUtils.writeList(bb, message.buckets);
            int bucketsLength = bb.writerIndex() - bucketsStartIndex;
            bb.setShort(bucketArrayLenIndex, bucketsLength);
            ChannelUtils.writeList(bb, message.properties);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFGroupDeleteVer15Funnel
    implements Funnel<OFGroupDeleteVer15> {
        private static final long serialVersionUID = 1L;

        OFGroupDeleteVer15Funnel() {
        }

        public void funnel(OFGroupDeleteVer15 message, PrimitiveSink sink) {
            sink.putByte((byte)6);
            sink.putByte((byte)15);
            sink.putLong(message.xid);
            sink.putShort((short)2);
            OFGroupTypeSerializerVer15.putTo(message.groupType, sink);
            message.group.putTo(sink);
            OFGroupBucketSerializerVer15.putTo(message.commandBucketId, sink);
            FunnelUtils.putList(message.buckets, sink);
            FunnelUtils.putList(message.properties, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFGroupDelete> {
        Reader() {
        }

        @Override
        public OFGroupDelete readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 6) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 15) {
                throw new OFParseError("Wrong type: Expected=OFType.GROUP_MOD(15), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 24) {
                throw new OFParseError("Wrong length: Expected to be >= 24, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            short command = bb.readShort();
            if (command != 2) {
                throw new OFParseError("Wrong command: Expected=OFGroupModCommand.DELETE(2), got=" + command);
            }
            OFGroupType groupType = OFGroupTypeSerializerVer15.readFrom(bb);
            bb.skipBytes(1);
            OFGroup group = OFGroup.read4Bytes(bb);
            int bucketArrayLen = U16.f(bb.readShort());
            bb.skipBytes(2);
            OFGroupBucket commandBucketId = OFGroupBucketSerializerVer15.readFrom(bb);
            List<OFBucket> buckets = ChannelUtils.readList(bb, bucketArrayLen, OFBucketVer15.READER);
            List<OFGroupProp> properties = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFGroupPropVer15.READER);
            OFGroupDeleteVer15 groupDeleteVer15 = new OFGroupDeleteVer15(xid, groupType, group, commandBucketId, buckets, properties);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)groupDeleteVer15);
            }
            return groupDeleteVer15;
        }
    }

    static class Builder
    implements OFGroupDelete.Builder {
        private boolean xidSet;
        private long xid;
        private boolean groupTypeSet;
        private OFGroupType groupType;
        private boolean groupSet;
        private OFGroup group;
        private boolean commandBucketIdSet;
        private OFGroupBucket commandBucketId;
        private boolean bucketsSet;
        private List<OFBucket> buckets;
        private boolean propertiesSet;
        private List<OFGroupProp> properties;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.GROUP_MOD;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFGroupDelete.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFGroupModCommand getCommand() {
            return OFGroupModCommand.DELETE;
        }

        @Override
        public OFGroupType getGroupType() {
            return this.groupType;
        }

        @Override
        public OFGroupDelete.Builder setGroupType(OFGroupType groupType) {
            this.groupType = groupType;
            this.groupTypeSet = true;
            return this;
        }

        @Override
        public OFGroup getGroup() {
            return this.group;
        }

        @Override
        public OFGroupDelete.Builder setGroup(OFGroup group) {
            this.group = group;
            this.groupSet = true;
            return this;
        }

        @Override
        public List<OFBucket> getBuckets() {
            return this.buckets;
        }

        @Override
        public OFGroupDelete.Builder setBuckets(List<OFBucket> buckets) {
            this.buckets = buckets;
            this.bucketsSet = true;
            return this;
        }

        @Override
        public OFGroupBucket getCommandBucketId() {
            return this.commandBucketId;
        }

        @Override
        public OFGroupDelete.Builder setCommandBucketId(OFGroupBucket commandBucketId) {
            this.commandBucketId = commandBucketId;
            this.commandBucketIdSet = true;
            return this;
        }

        @Override
        public List<OFGroupProp> getProperties() {
            return this.properties;
        }

        @Override
        public OFGroupDelete.Builder setProperties(List<OFGroupProp> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFGroupDelete build() {
            List<OFGroupProp> properties;
            List<OFBucket> buckets;
            OFGroup group;
            long xid;
            long l = xid = this.xidSet ? this.xid : 0L;
            if (!this.groupTypeSet) {
                throw new IllegalStateException("Property groupType doesn't have default value -- must be set");
            }
            if (this.groupType == null) {
                throw new NullPointerException("Property groupType must not be null");
            }
            OFGroup oFGroup = group = this.groupSet ? this.group : DEFAULT_GROUP_ID;
            if (group == null) {
                throw new NullPointerException("Property group must not be null");
            }
            if (!this.commandBucketIdSet) {
                throw new IllegalStateException("Property commandBucketId doesn't have default value -- must be set");
            }
            if (this.commandBucketId == null) {
                throw new NullPointerException("Property commandBucketId must not be null");
            }
            List<OFBucket> list = buckets = this.bucketsSet ? this.buckets : DEFAULT_BUCKETS;
            if (buckets == null) {
                throw new NullPointerException("Property buckets must not be null");
            }
            List<OFGroupProp> list2 = properties = this.propertiesSet ? this.properties : DEFAULT_PROPERTIES;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFGroupDeleteVer15(xid, this.groupType, group, this.commandBucketId, buckets, properties);
        }
    }

    static class BuilderWithParent
    implements OFGroupDelete.Builder {
        final OFGroupDeleteVer15 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean groupTypeSet;
        private OFGroupType groupType;
        private boolean groupSet;
        private OFGroup group;
        private boolean commandBucketIdSet;
        private OFGroupBucket commandBucketId;
        private boolean bucketsSet;
        private List<OFBucket> buckets;
        private boolean propertiesSet;
        private List<OFGroupProp> properties;

        BuilderWithParent(OFGroupDeleteVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.GROUP_MOD;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFGroupDelete.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFGroupModCommand getCommand() {
            return OFGroupModCommand.DELETE;
        }

        @Override
        public OFGroupType getGroupType() {
            return this.groupType;
        }

        @Override
        public OFGroupDelete.Builder setGroupType(OFGroupType groupType) {
            this.groupType = groupType;
            this.groupTypeSet = true;
            return this;
        }

        @Override
        public OFGroup getGroup() {
            return this.group;
        }

        @Override
        public OFGroupDelete.Builder setGroup(OFGroup group) {
            this.group = group;
            this.groupSet = true;
            return this;
        }

        @Override
        public List<OFBucket> getBuckets() {
            return this.buckets;
        }

        @Override
        public OFGroupDelete.Builder setBuckets(List<OFBucket> buckets) {
            this.buckets = buckets;
            this.bucketsSet = true;
            return this;
        }

        @Override
        public OFGroupBucket getCommandBucketId() {
            return this.commandBucketId;
        }

        @Override
        public OFGroupDelete.Builder setCommandBucketId(OFGroupBucket commandBucketId) {
            this.commandBucketId = commandBucketId;
            this.commandBucketIdSet = true;
            return this;
        }

        @Override
        public List<OFGroupProp> getProperties() {
            return this.properties;
        }

        @Override
        public OFGroupDelete.Builder setProperties(List<OFGroupProp> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFGroupDelete build() {
            List properties;
            List buckets;
            OFGroupBucket commandBucketId;
            OFGroup group;
            OFGroupType groupType;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            OFGroupType oFGroupType = groupType = this.groupTypeSet ? this.groupType : this.parentMessage.groupType;
            if (groupType == null) {
                throw new NullPointerException("Property groupType must not be null");
            }
            OFGroup oFGroup = group = this.groupSet ? this.group : this.parentMessage.group;
            if (group == null) {
                throw new NullPointerException("Property group must not be null");
            }
            OFGroupBucket oFGroupBucket = commandBucketId = this.commandBucketIdSet ? this.commandBucketId : this.parentMessage.commandBucketId;
            if (commandBucketId == null) {
                throw new NullPointerException("Property commandBucketId must not be null");
            }
            List list = buckets = this.bucketsSet ? this.buckets : this.parentMessage.buckets;
            if (buckets == null) {
                throw new NullPointerException("Property buckets must not be null");
            }
            List list2 = properties = this.propertiesSet ? this.properties : this.parentMessage.properties;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFGroupDeleteVer15(xid, groupType, group, commandBucketId, buckets, properties);
        }
    }
}

