/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFControllerStatus;
import org.projectfloodlight.openflow.protocol.OFControllerStatusEntry;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver15.OFControllerStatusEntryVer15;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFControllerStatusVer15
implements OFControllerStatus {
    private static final Logger logger = LoggerFactory.getLogger(OFControllerStatusVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 24;
    private static final long DEFAULT_XID = 0L;
    private final long xid;
    private final OFControllerStatusEntry entry;
    static final Reader READER = new Reader();
    static final OFControllerStatusVer15Funnel FUNNEL = new OFControllerStatusVer15Funnel();
    static final Writer WRITER = new Writer();

    OFControllerStatusVer15(long xid, OFControllerStatusEntry entry) {
        if (entry == null) {
            throw new NullPointerException("OFControllerStatusVer15: property entry cannot be null");
        }
        this.xid = xid;
        this.entry = entry;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFType getType() {
        return OFType.CONTROLLER_STATUS;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFControllerStatusEntry getEntry() {
        return this.entry;
    }

    @Override
    public OFControllerStatus.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFControllerStatusVer15(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("entry=").append(this.entry);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFControllerStatusVer15 other = (OFControllerStatusVer15)obj;
        if (this.xid != other.xid) {
            return false;
        }
        return !(this.entry == null ? other.entry != null : !this.entry.equals(other.entry));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFControllerStatusVer15 other = (OFControllerStatusVer15)obj;
        return !(this.entry == null ? other.entry != null : !this.entry.equals(other.entry));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.entry == null ? 0 : this.entry.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.entry == null ? 0 : this.entry.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFControllerStatusVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFControllerStatusVer15 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(6);
            bb.writeByte(35);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            message.entry.writeTo(bb);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFControllerStatusVer15Funnel
    implements Funnel<OFControllerStatusVer15> {
        private static final long serialVersionUID = 1L;

        OFControllerStatusVer15Funnel() {
        }

        public void funnel(OFControllerStatusVer15 message, PrimitiveSink sink) {
            sink.putByte((byte)6);
            sink.putByte((byte)35);
            sink.putLong(message.xid);
            message.entry.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFControllerStatus> {
        Reader() {
        }

        @Override
        public OFControllerStatus readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 6) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 35) {
                throw new OFParseError("Wrong type: Expected=OFType.CONTROLLER_STATUS(35), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 24) {
                throw new OFParseError("Wrong length: Expected to be >= 24, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            OFControllerStatusEntry entry = OFControllerStatusEntryVer15.READER.readFrom(bb);
            OFControllerStatusVer15 controllerStatusVer15 = new OFControllerStatusVer15(xid, entry);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)controllerStatusVer15);
            }
            return controllerStatusVer15;
        }
    }

    static class Builder
    implements OFControllerStatus.Builder {
        private boolean xidSet;
        private long xid;
        private boolean entrySet;
        private OFControllerStatusEntry entry;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.CONTROLLER_STATUS;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFControllerStatus.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFControllerStatusEntry getEntry() {
            return this.entry;
        }

        @Override
        public OFControllerStatus.Builder setEntry(OFControllerStatusEntry entry) {
            this.entry = entry;
            this.entrySet = true;
            return this;
        }

        @Override
        public OFControllerStatus build() {
            long xid;
            long l = xid = this.xidSet ? this.xid : 0L;
            if (!this.entrySet) {
                throw new IllegalStateException("Property entry doesn't have default value -- must be set");
            }
            if (this.entry == null) {
                throw new NullPointerException("Property entry must not be null");
            }
            return new OFControllerStatusVer15(xid, this.entry);
        }
    }

    static class BuilderWithParent
    implements OFControllerStatus.Builder {
        final OFControllerStatusVer15 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean entrySet;
        private OFControllerStatusEntry entry;

        BuilderWithParent(OFControllerStatusVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.CONTROLLER_STATUS;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFControllerStatus.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFControllerStatusEntry getEntry() {
            return this.entry;
        }

        @Override
        public OFControllerStatus.Builder setEntry(OFControllerStatusEntry entry) {
            this.entry = entry;
            this.entrySet = true;
            return this;
        }

        @Override
        public OFControllerStatus build() {
            OFControllerStatusEntry entry;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            OFControllerStatusEntry oFControllerStatusEntry = entry = this.entrySet ? this.entry : this.parentMessage.entry;
            if (entry == null) {
                throw new NullPointerException("Property entry must not be null");
            }
            return new OFControllerStatusVer15(xid, entry);
        }
    }
}

