/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvTxPackets;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvTxPacketsVer15
implements OFBsnTlvTxPackets {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvTxPacketsVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 12;
    private static final U64 DEFAULT_VALUE = U64.ZERO;
    private final U64 value;
    static final OFBsnTlvTxPacketsVer15 DEFAULT = new OFBsnTlvTxPacketsVer15(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvTxPacketsVer15Funnel FUNNEL = new OFBsnTlvTxPacketsVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvTxPacketsVer15(U64 value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvTxPacketsVer15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public U64 getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvTxPackets.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvTxPacketsVer15(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvTxPacketsVer15 other = (OFBsnTlvTxPacketsVer15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvTxPacketsVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvTxPacketsVer15 message) {
            bb.writeShort(3);
            bb.writeShort(12);
            bb.writeLong(message.value.getValue());
        }
    }

    static class OFBsnTlvTxPacketsVer15Funnel
    implements Funnel<OFBsnTlvTxPacketsVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvTxPacketsVer15Funnel() {
        }

        public void funnel(OFBsnTlvTxPacketsVer15 message, PrimitiveSink sink) {
            sink.putShort((short)3);
            sink.putShort((short)12);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvTxPackets> {
        Reader() {
        }

        @Override
        public OFBsnTlvTxPackets readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 3) {
                throw new OFParseError("Wrong type: Expected=0x3(0x3), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 12) {
                throw new OFParseError("Wrong length: Expected=12(12), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            U64 value = U64.ofRaw(bb.readLong());
            OFBsnTlvTxPacketsVer15 bsnTlvTxPacketsVer15 = new OFBsnTlvTxPacketsVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvTxPacketsVer15);
            }
            return bsnTlvTxPacketsVer15;
        }
    }

    static class Builder
    implements OFBsnTlvTxPackets.Builder {
        private boolean valueSet;
        private U64 value;

        Builder() {
        }

        @Override
        public int getType() {
            return 3;
        }

        @Override
        public U64 getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvTxPackets.Builder setValue(U64 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvTxPackets build() {
            U64 value;
            U64 u64 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvTxPacketsVer15(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvTxPackets.Builder {
        final OFBsnTlvTxPacketsVer15 parentMessage;
        private boolean valueSet;
        private U64 value;

        BuilderWithParent(OFBsnTlvTxPacketsVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 3;
        }

        @Override
        public U64 getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvTxPackets.Builder setValue(U64 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvTxPackets build() {
            U64 value;
            U64 u64 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvTxPacketsVer15(value);
        }
    }
}

