/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvReplyPackets;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvReplyPacketsVer15
implements OFBsnTlvReplyPackets {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvReplyPacketsVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 12;
    private static final U64 DEFAULT_VALUE = U64.ZERO;
    private final U64 value;
    static final OFBsnTlvReplyPacketsVer15 DEFAULT = new OFBsnTlvReplyPacketsVer15(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvReplyPacketsVer15Funnel FUNNEL = new OFBsnTlvReplyPacketsVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvReplyPacketsVer15(U64 value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvReplyPacketsVer15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 12;
    }

    @Override
    public U64 getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvReplyPackets.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvReplyPacketsVer15(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvReplyPacketsVer15 other = (OFBsnTlvReplyPacketsVer15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvReplyPacketsVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvReplyPacketsVer15 message) {
            bb.writeShort(12);
            bb.writeShort(12);
            bb.writeLong(message.value.getValue());
        }
    }

    static class OFBsnTlvReplyPacketsVer15Funnel
    implements Funnel<OFBsnTlvReplyPacketsVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvReplyPacketsVer15Funnel() {
        }

        public void funnel(OFBsnTlvReplyPacketsVer15 message, PrimitiveSink sink) {
            sink.putShort((short)12);
            sink.putShort((short)12);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvReplyPackets> {
        Reader() {
        }

        @Override
        public OFBsnTlvReplyPackets readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 12) {
                throw new OFParseError("Wrong type: Expected=0xc(0xc), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 12) {
                throw new OFParseError("Wrong length: Expected=12(12), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            U64 value = U64.ofRaw(bb.readLong());
            OFBsnTlvReplyPacketsVer15 bsnTlvReplyPacketsVer15 = new OFBsnTlvReplyPacketsVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvReplyPacketsVer15);
            }
            return bsnTlvReplyPacketsVer15;
        }
    }

    static class Builder
    implements OFBsnTlvReplyPackets.Builder {
        private boolean valueSet;
        private U64 value;

        Builder() {
        }

        @Override
        public int getType() {
            return 12;
        }

        @Override
        public U64 getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvReplyPackets.Builder setValue(U64 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvReplyPackets build() {
            U64 value;
            U64 u64 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvReplyPacketsVer15(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvReplyPackets.Builder {
        final OFBsnTlvReplyPacketsVer15 parentMessage;
        private boolean valueSet;
        private U64 value;

        BuilderWithParent(OFBsnTlvReplyPacketsVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 12;
        }

        @Override
        public U64 getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvReplyPackets.Builder setValue(U64 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvReplyPackets build() {
            U64 value;
            U64 u64 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvReplyPacketsVer15(value);
        }
    }
}

