/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnRateUnit;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvRateUnit;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnRateUnitSerializerVer15;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvRateUnitVer15
implements OFBsnTlvRateUnit {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvRateUnitVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 5;
    private final OFBsnRateUnit value;
    static final Reader READER = new Reader();
    static final OFBsnTlvRateUnitVer15Funnel FUNNEL = new OFBsnTlvRateUnitVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvRateUnitVer15(OFBsnRateUnit value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvRateUnitVer15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 89;
    }

    @Override
    public OFBsnRateUnit getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvRateUnit.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvRateUnitVer15(");
        b.append("value=").append((Object)this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvRateUnitVer15 other = (OFBsnTlvRateUnitVer15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvRateUnitVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvRateUnitVer15 message) {
            bb.writeShort(89);
            bb.writeShort(5);
            OFBsnRateUnitSerializerVer15.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvRateUnitVer15Funnel
    implements Funnel<OFBsnTlvRateUnitVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvRateUnitVer15Funnel() {
        }

        public void funnel(OFBsnTlvRateUnitVer15 message, PrimitiveSink sink) {
            sink.putShort((short)89);
            sink.putShort((short)5);
            OFBsnRateUnitSerializerVer15.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvRateUnit> {
        Reader() {
        }

        @Override
        public OFBsnTlvRateUnit readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 89) {
                throw new OFParseError("Wrong type: Expected=0x59(0x59), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 5) {
                throw new OFParseError("Wrong length: Expected=5(5), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFBsnRateUnit value = OFBsnRateUnitSerializerVer15.readFrom(bb);
            OFBsnTlvRateUnitVer15 bsnTlvRateUnitVer15 = new OFBsnTlvRateUnitVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvRateUnitVer15);
            }
            return bsnTlvRateUnitVer15;
        }
    }

    static class Builder
    implements OFBsnTlvRateUnit.Builder {
        private boolean valueSet;
        private OFBsnRateUnit value;

        Builder() {
        }

        @Override
        public int getType() {
            return 89;
        }

        @Override
        public OFBsnRateUnit getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvRateUnit.Builder setValue(OFBsnRateUnit value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvRateUnit build() {
            if (!this.valueSet) {
                throw new IllegalStateException("Property value doesn't have default value -- must be set");
            }
            if (this.value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvRateUnitVer15(this.value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvRateUnit.Builder {
        final OFBsnTlvRateUnitVer15 parentMessage;
        private boolean valueSet;
        private OFBsnRateUnit value;

        BuilderWithParent(OFBsnTlvRateUnitVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 89;
        }

        @Override
        public OFBsnRateUnit getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvRateUnit.Builder setValue(OFBsnRateUnit value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvRateUnit build() {
            OFBsnRateUnit value;
            OFBsnRateUnit oFBsnRateUnit = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvRateUnitVer15(value);
        }
    }
}

