/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnPortUsage;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvPortUsage;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnPortUsageSerializerVer15;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvPortUsageVer15
implements OFBsnTlvPortUsage {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvPortUsageVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 6;
    private final OFBsnPortUsage value;
    static final Reader READER = new Reader();
    static final OFBsnTlvPortUsageVer15Funnel FUNNEL = new OFBsnTlvPortUsageVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvPortUsageVer15(OFBsnPortUsage value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvPortUsageVer15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 141;
    }

    @Override
    public OFBsnPortUsage getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvPortUsage.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvPortUsageVer15(");
        b.append("value=").append((Object)this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvPortUsageVer15 other = (OFBsnTlvPortUsageVer15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvPortUsageVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvPortUsageVer15 message) {
            bb.writeShort(141);
            bb.writeShort(6);
            OFBsnPortUsageSerializerVer15.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvPortUsageVer15Funnel
    implements Funnel<OFBsnTlvPortUsageVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvPortUsageVer15Funnel() {
        }

        public void funnel(OFBsnTlvPortUsageVer15 message, PrimitiveSink sink) {
            sink.putShort((short)141);
            sink.putShort((short)6);
            OFBsnPortUsageSerializerVer15.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvPortUsage> {
        Reader() {
        }

        @Override
        public OFBsnTlvPortUsage readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 141) {
                throw new OFParseError("Wrong type: Expected=0x8d(0x8d), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFBsnPortUsage value = OFBsnPortUsageSerializerVer15.readFrom(bb);
            OFBsnTlvPortUsageVer15 bsnTlvPortUsageVer15 = new OFBsnTlvPortUsageVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvPortUsageVer15);
            }
            return bsnTlvPortUsageVer15;
        }
    }

    static class Builder
    implements OFBsnTlvPortUsage.Builder {
        private boolean valueSet;
        private OFBsnPortUsage value;

        Builder() {
        }

        @Override
        public int getType() {
            return 141;
        }

        @Override
        public OFBsnPortUsage getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvPortUsage.Builder setValue(OFBsnPortUsage value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvPortUsage build() {
            if (!this.valueSet) {
                throw new IllegalStateException("Property value doesn't have default value -- must be set");
            }
            if (this.value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvPortUsageVer15(this.value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvPortUsage.Builder {
        final OFBsnTlvPortUsageVer15 parentMessage;
        private boolean valueSet;
        private OFBsnPortUsage value;

        BuilderWithParent(OFBsnTlvPortUsageVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 141;
        }

        @Override
        public OFBsnPortUsage getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvPortUsage.Builder setValue(OFBsnPortUsage value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvPortUsage build() {
            OFBsnPortUsage value;
            OFBsnPortUsage oFBsnPortUsage = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvPortUsageVer15(value);
        }
    }
}

