/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvEthType;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvEthTypeVer15
implements OFBsnTlvEthType {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvEthTypeVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 6;
    private static final int DEFAULT_VALUE = 0;
    private final int value;
    static final OFBsnTlvEthTypeVer15 DEFAULT = new OFBsnTlvEthTypeVer15(0);
    static final Reader READER = new Reader();
    static final OFBsnTlvEthTypeVer15Funnel FUNNEL = new OFBsnTlvEthTypeVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvEthTypeVer15(int value) {
        this.value = value;
    }

    @Override
    public int getType() {
        return 131;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvEthType.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvEthTypeVer15(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvEthTypeVer15 other = (OFBsnTlvEthTypeVer15)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.value;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvEthTypeVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvEthTypeVer15 message) {
            bb.writeShort(131);
            bb.writeShort(6);
            bb.writeShort((int)U16.t(message.value));
        }
    }

    static class OFBsnTlvEthTypeVer15Funnel
    implements Funnel<OFBsnTlvEthTypeVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvEthTypeVer15Funnel() {
        }

        public void funnel(OFBsnTlvEthTypeVer15 message, PrimitiveSink sink) {
            sink.putShort((short)131);
            sink.putShort((short)6);
            sink.putInt(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvEthType> {
        Reader() {
        }

        @Override
        public OFBsnTlvEthType readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 131) {
                throw new OFParseError("Wrong type: Expected=0x83(0x83), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            int value = U16.f(bb.readShort());
            OFBsnTlvEthTypeVer15 bsnTlvEthTypeVer15 = new OFBsnTlvEthTypeVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvEthTypeVer15);
            }
            return bsnTlvEthTypeVer15;
        }
    }

    static class Builder
    implements OFBsnTlvEthType.Builder {
        private boolean valueSet;
        private int value;

        Builder() {
        }

        @Override
        public int getType() {
            return 131;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvEthType.Builder setValue(int value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvEthType build() {
            int value = this.valueSet ? this.value : 0;
            return new OFBsnTlvEthTypeVer15(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvEthType.Builder {
        final OFBsnTlvEthTypeVer15 parentMessage;
        private boolean valueSet;
        private int value;

        BuilderWithParent(OFBsnTlvEthTypeVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 131;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvEthType.Builder setValue(int value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvEthType build() {
            int value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvEthTypeVer15(value);
        }
    }
}

