/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvActorPortNum;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvActorPortNumVer15
implements OFBsnTlvActorPortNum {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvActorPortNumVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 6;
    private static final int DEFAULT_VALUE = 0;
    private final int value;
    static final OFBsnTlvActorPortNumVer15 DEFAULT = new OFBsnTlvActorPortNumVer15(0);
    static final Reader READER = new Reader();
    static final OFBsnTlvActorPortNumVer15Funnel FUNNEL = new OFBsnTlvActorPortNumVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvActorPortNumVer15(int value) {
        this.value = value;
    }

    @Override
    public int getType() {
        return 43;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvActorPortNum.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvActorPortNumVer15(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvActorPortNumVer15 other = (OFBsnTlvActorPortNumVer15)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.value;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvActorPortNumVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvActorPortNumVer15 message) {
            bb.writeShort(43);
            bb.writeShort(6);
            bb.writeShort((int)U16.t(message.value));
        }
    }

    static class OFBsnTlvActorPortNumVer15Funnel
    implements Funnel<OFBsnTlvActorPortNumVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvActorPortNumVer15Funnel() {
        }

        public void funnel(OFBsnTlvActorPortNumVer15 message, PrimitiveSink sink) {
            sink.putShort((short)43);
            sink.putShort((short)6);
            sink.putInt(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvActorPortNum> {
        Reader() {
        }

        @Override
        public OFBsnTlvActorPortNum readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 43) {
                throw new OFParseError("Wrong type: Expected=0x2b(0x2b), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            int value = U16.f(bb.readShort());
            OFBsnTlvActorPortNumVer15 bsnTlvActorPortNumVer15 = new OFBsnTlvActorPortNumVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvActorPortNumVer15);
            }
            return bsnTlvActorPortNumVer15;
        }
    }

    static class Builder
    implements OFBsnTlvActorPortNum.Builder {
        private boolean valueSet;
        private int value;

        Builder() {
        }

        @Override
        public int getType() {
            return 43;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvActorPortNum.Builder setValue(int value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvActorPortNum build() {
            int value = this.valueSet ? this.value : 0;
            return new OFBsnTlvActorPortNumVer15(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvActorPortNum.Builder {
        final OFBsnTlvActorPortNumVer15 parentMessage;
        private boolean valueSet;
        private int value;

        BuilderWithParent(OFBsnTlvActorPortNumVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 43;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvActorPortNum.Builder setValue(int value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvActorPortNum build() {
            int value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvActorPortNumVer15(value);
        }
    }
}

