/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnSetAuxCxnsRequest;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnSetAuxCxnsRequestVer15
implements OFBsnSetAuxCxnsRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnSetAuxCxnsRequestVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 20;
    private static final long DEFAULT_XID = 0L;
    private static final long DEFAULT_NUM_AUX = 0L;
    private final long xid;
    private final long numAux;
    static final OFBsnSetAuxCxnsRequestVer15 DEFAULT = new OFBsnSetAuxCxnsRequestVer15(0L, 0L);
    static final Reader READER = new Reader();
    static final OFBsnSetAuxCxnsRequestVer15Funnel FUNNEL = new OFBsnSetAuxCxnsRequestVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnSetAuxCxnsRequestVer15(long xid, long numAux) {
        this.xid = xid;
        this.numAux = numAux;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 58L;
    }

    @Override
    public long getNumAux() {
        return this.numAux;
    }

    @Override
    public OFBsnSetAuxCxnsRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnSetAuxCxnsRequestVer15(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("numAux=").append(this.numAux);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnSetAuxCxnsRequestVer15 other = (OFBsnSetAuxCxnsRequestVer15)obj;
        if (this.xid != other.xid) {
            return false;
        }
        return this.numAux == other.numAux;
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnSetAuxCxnsRequestVer15 other = (OFBsnSetAuxCxnsRequestVer15)obj;
        return this.numAux == other.numAux;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * (int)(this.numAux ^ this.numAux >>> 32);
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.numAux ^ this.numAux >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnSetAuxCxnsRequestVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnSetAuxCxnsRequestVer15 message) {
            bb.writeByte(6);
            bb.writeByte(4);
            bb.writeShort(20);
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(58);
            bb.writeInt(U32.t(message.numAux));
        }
    }

    static class OFBsnSetAuxCxnsRequestVer15Funnel
    implements Funnel<OFBsnSetAuxCxnsRequestVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnSetAuxCxnsRequestVer15Funnel() {
        }

        public void funnel(OFBsnSetAuxCxnsRequestVer15 message, PrimitiveSink sink) {
            sink.putByte((byte)6);
            sink.putByte((byte)4);
            sink.putShort((short)20);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(58);
            sink.putLong(message.numAux);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnSetAuxCxnsRequest> {
        Reader() {
        }

        @Override
        public OFBsnSetAuxCxnsRequest readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 6) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 20) {
                throw new OFParseError("Wrong length: Expected=20(20), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 58) {
                throw new OFParseError("Wrong subtype: Expected=0x3aL(0x3aL), got=" + subtype);
            }
            long numAux = U32.f(bb.readInt());
            OFBsnSetAuxCxnsRequestVer15 bsnSetAuxCxnsRequestVer15 = new OFBsnSetAuxCxnsRequestVer15(xid, numAux);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnSetAuxCxnsRequestVer15);
            }
            return bsnSetAuxCxnsRequestVer15;
        }
    }

    static class Builder
    implements OFBsnSetAuxCxnsRequest.Builder {
        private boolean xidSet;
        private long xid;
        private boolean numAuxSet;
        private long numAux;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnSetAuxCxnsRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 58L;
        }

        @Override
        public long getNumAux() {
            return this.numAux;
        }

        @Override
        public OFBsnSetAuxCxnsRequest.Builder setNumAux(long numAux) {
            this.numAux = numAux;
            this.numAuxSet = true;
            return this;
        }

        @Override
        public OFBsnSetAuxCxnsRequest build() {
            long xid = this.xidSet ? this.xid : 0L;
            long numAux = this.numAuxSet ? this.numAux : 0L;
            return new OFBsnSetAuxCxnsRequestVer15(xid, numAux);
        }
    }

    static class BuilderWithParent
    implements OFBsnSetAuxCxnsRequest.Builder {
        final OFBsnSetAuxCxnsRequestVer15 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean numAuxSet;
        private long numAux;

        BuilderWithParent(OFBsnSetAuxCxnsRequestVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnSetAuxCxnsRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 58L;
        }

        @Override
        public long getNumAux() {
            return this.numAux;
        }

        @Override
        public OFBsnSetAuxCxnsRequest.Builder setNumAux(long numAux) {
            this.numAux = numAux;
            this.numAuxSet = true;
            return this;
        }

        @Override
        public OFBsnSetAuxCxnsRequest build() {
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            long numAux = this.numAuxSet ? this.numAux : this.parentMessage.numAux;
            return new OFBsnSetAuxCxnsRequestVer15(xid, numAux);
        }
    }
}

