/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnModuleEepromTransceiver;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnModuleEepromTransceiverVer15
implements OFBsnModuleEepromTransceiver {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnModuleEepromTransceiverVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 8;
    private static final U64 DEFAULT_CODES = U64.ZERO;
    private final U64 codes;
    static final OFBsnModuleEepromTransceiverVer15 DEFAULT = new OFBsnModuleEepromTransceiverVer15(DEFAULT_CODES);
    static final Reader READER = new Reader();
    static final OFBsnModuleEepromTransceiverVer15Funnel FUNNEL = new OFBsnModuleEepromTransceiverVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnModuleEepromTransceiverVer15(U64 codes) {
        if (codes == null) {
            throw new NullPointerException("OFBsnModuleEepromTransceiverVer15: property codes cannot be null");
        }
        this.codes = codes;
    }

    @Override
    public U64 getCodes() {
        return this.codes;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnModuleEepromTransceiver.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnModuleEepromTransceiverVer15(");
        b.append("codes=").append(this.codes);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnModuleEepromTransceiverVer15 other = (OFBsnModuleEepromTransceiverVer15)obj;
        return !(this.codes == null ? other.codes != null : !this.codes.equals(other.codes));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.codes == null ? 0 : this.codes.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnModuleEepromTransceiverVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnModuleEepromTransceiverVer15 message) {
            bb.writeLong(message.codes.getValue());
        }
    }

    static class OFBsnModuleEepromTransceiverVer15Funnel
    implements Funnel<OFBsnModuleEepromTransceiverVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnModuleEepromTransceiverVer15Funnel() {
        }

        public void funnel(OFBsnModuleEepromTransceiverVer15 message, PrimitiveSink sink) {
            message.codes.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnModuleEepromTransceiver> {
        Reader() {
        }

        @Override
        public OFBsnModuleEepromTransceiver readFrom(ByteBuf bb) throws OFParseError {
            U64 codes = U64.ofRaw(bb.readLong());
            OFBsnModuleEepromTransceiverVer15 bsnModuleEepromTransceiverVer15 = new OFBsnModuleEepromTransceiverVer15(codes);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnModuleEepromTransceiverVer15);
            }
            return bsnModuleEepromTransceiverVer15;
        }
    }

    static class Builder
    implements OFBsnModuleEepromTransceiver.Builder {
        private boolean codesSet;
        private U64 codes;

        Builder() {
        }

        @Override
        public U64 getCodes() {
            return this.codes;
        }

        @Override
        public OFBsnModuleEepromTransceiver.Builder setCodes(U64 codes) {
            this.codes = codes;
            this.codesSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnModuleEepromTransceiver build() {
            U64 codes;
            U64 u64 = codes = this.codesSet ? this.codes : DEFAULT_CODES;
            if (codes == null) {
                throw new NullPointerException("Property codes must not be null");
            }
            return new OFBsnModuleEepromTransceiverVer15(codes);
        }
    }

    static class BuilderWithParent
    implements OFBsnModuleEepromTransceiver.Builder {
        final OFBsnModuleEepromTransceiverVer15 parentMessage;
        private boolean codesSet;
        private U64 codes;

        BuilderWithParent(OFBsnModuleEepromTransceiverVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public U64 getCodes() {
            return this.codes;
        }

        @Override
        public OFBsnModuleEepromTransceiver.Builder setCodes(U64 codes) {
            this.codes = codes;
            this.codesSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnModuleEepromTransceiver build() {
            U64 codes;
            U64 u64 = codes = this.codesSet ? this.codes : this.parentMessage.codes;
            if (codes == null) {
                throw new NullPointerException("Property codes must not be null");
            }
            return new OFBsnModuleEepromTransceiverVer15(codes);
        }
    }
}

