/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnGenericCommand;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlv;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnTlvVer15;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnGenericCommandVer15
implements OFBsnGenericCommand {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnGenericCommandVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 80;
    private static final long DEFAULT_XID = 0L;
    private static final String DEFAULT_NAME = "";
    private static final List<OFBsnTlv> DEFAULT_TLVS = ImmutableList.of();
    private final long xid;
    private final String name;
    private final List<OFBsnTlv> tlvs;
    static final OFBsnGenericCommandVer15 DEFAULT = new OFBsnGenericCommandVer15(0L, "", DEFAULT_TLVS);
    static final Reader READER = new Reader();
    static final OFBsnGenericCommandVer15Funnel FUNNEL = new OFBsnGenericCommandVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnGenericCommandVer15(long xid, String name, List<OFBsnTlv> tlvs) {
        if (name == null) {
            throw new NullPointerException("OFBsnGenericCommandVer15: property name cannot be null");
        }
        if (tlvs == null) {
            throw new NullPointerException("OFBsnGenericCommandVer15: property tlvs cannot be null");
        }
        this.xid = xid;
        this.name = name;
        this.tlvs = tlvs;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 71L;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<OFBsnTlv> getTlvs() {
        return this.tlvs;
    }

    @Override
    public OFBsnGenericCommand.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnGenericCommandVer15(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("name=").append(this.name);
        b.append(", ");
        b.append("tlvs=").append(this.tlvs);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnGenericCommandVer15 other = (OFBsnGenericCommandVer15)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.tlvs == null ? other.tlvs != null : !this.tlvs.equals(other.tlvs));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnGenericCommandVer15 other = (OFBsnGenericCommandVer15)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.tlvs == null ? other.tlvs != null : !this.tlvs.equals(other.tlvs));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.tlvs == null ? 0 : this.tlvs.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.tlvs == null ? 0 : this.tlvs.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnGenericCommandVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnGenericCommandVer15 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(6);
            bb.writeByte(4);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(71);
            ChannelUtils.writeFixedLengthString(bb, message.name, 64);
            ChannelUtils.writeList(bb, message.tlvs);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFBsnGenericCommandVer15Funnel
    implements Funnel<OFBsnGenericCommandVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnGenericCommandVer15Funnel() {
        }

        public void funnel(OFBsnGenericCommandVer15 message, PrimitiveSink sink) {
            sink.putByte((byte)6);
            sink.putByte((byte)4);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(71);
            sink.putUnencodedChars((CharSequence)message.name);
            FunnelUtils.putList(message.tlvs, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnGenericCommand> {
        Reader() {
        }

        @Override
        public OFBsnGenericCommand readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 6) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 80) {
                throw new OFParseError("Wrong length: Expected to be >= 80, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 71) {
                throw new OFParseError("Wrong subtype: Expected=0x47L(0x47L), got=" + subtype);
            }
            String name = ChannelUtils.readFixedLengthString(bb, 64);
            List<OFBsnTlv> tlvs = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFBsnTlvVer15.READER);
            OFBsnGenericCommandVer15 bsnGenericCommandVer15 = new OFBsnGenericCommandVer15(xid, name, tlvs);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnGenericCommandVer15);
            }
            return bsnGenericCommandVer15;
        }
    }

    static class Builder
    implements OFBsnGenericCommand.Builder {
        private boolean xidSet;
        private long xid;
        private boolean nameSet;
        private String name;
        private boolean tlvsSet;
        private List<OFBsnTlv> tlvs;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnGenericCommand.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 71L;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public OFBsnGenericCommand.Builder setName(String name) {
            this.name = name;
            this.nameSet = true;
            return this;
        }

        @Override
        public List<OFBsnTlv> getTlvs() {
            return this.tlvs;
        }

        @Override
        public OFBsnGenericCommand.Builder setTlvs(List<OFBsnTlv> tlvs) {
            this.tlvs = tlvs;
            this.tlvsSet = true;
            return this;
        }

        @Override
        public OFBsnGenericCommand build() {
            List<OFBsnTlv> tlvs;
            String name;
            long xid = this.xidSet ? this.xid : 0L;
            String string = name = this.nameSet ? this.name : OFBsnGenericCommandVer15.DEFAULT_NAME;
            if (name == null) {
                throw new NullPointerException("Property name must not be null");
            }
            List<OFBsnTlv> list = tlvs = this.tlvsSet ? this.tlvs : DEFAULT_TLVS;
            if (tlvs == null) {
                throw new NullPointerException("Property tlvs must not be null");
            }
            return new OFBsnGenericCommandVer15(xid, name, tlvs);
        }
    }

    static class BuilderWithParent
    implements OFBsnGenericCommand.Builder {
        final OFBsnGenericCommandVer15 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean nameSet;
        private String name;
        private boolean tlvsSet;
        private List<OFBsnTlv> tlvs;

        BuilderWithParent(OFBsnGenericCommandVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnGenericCommand.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 71L;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public OFBsnGenericCommand.Builder setName(String name) {
            this.name = name;
            this.nameSet = true;
            return this;
        }

        @Override
        public List<OFBsnTlv> getTlvs() {
            return this.tlvs;
        }

        @Override
        public OFBsnGenericCommand.Builder setTlvs(List<OFBsnTlv> tlvs) {
            this.tlvs = tlvs;
            this.tlvsSet = true;
            return this;
        }

        @Override
        public OFBsnGenericCommand build() {
            List tlvs;
            String name;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            String string = name = this.nameSet ? this.name : this.parentMessage.name;
            if (name == null) {
                throw new NullPointerException("Property name must not be null");
            }
            List list = tlvs = this.tlvsSet ? this.tlvs : this.parentMessage.tlvs;
            if (tlvs == null) {
                throw new NullPointerException("Property tlvs must not be null");
            }
            return new OFBsnGenericCommandVer15(xid, name, tlvs);
        }
    }
}

