/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnControllerConnection;
import org.projectfloodlight.openflow.protocol.OFBsnControllerConnectionsReply;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnControllerConnectionVer15;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnControllerConnectionsReplyVer15
implements OFBsnControllerConnectionsReply {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnControllerConnectionsReplyVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 16;
    private static final long DEFAULT_XID = 0L;
    private static final List<OFBsnControllerConnection> DEFAULT_CONNECTIONS = ImmutableList.of();
    private final long xid;
    private final List<OFBsnControllerConnection> connections;
    static final OFBsnControllerConnectionsReplyVer15 DEFAULT = new OFBsnControllerConnectionsReplyVer15(0L, DEFAULT_CONNECTIONS);
    static final Reader READER = new Reader();
    static final OFBsnControllerConnectionsReplyVer15Funnel FUNNEL = new OFBsnControllerConnectionsReplyVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnControllerConnectionsReplyVer15(long xid, List<OFBsnControllerConnection> connections) {
        if (connections == null) {
            throw new NullPointerException("OFBsnControllerConnectionsReplyVer15: property connections cannot be null");
        }
        this.xid = xid;
        this.connections = connections;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 57L;
    }

    @Override
    public List<OFBsnControllerConnection> getConnections() {
        return this.connections;
    }

    @Override
    public OFBsnControllerConnectionsReply.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnControllerConnectionsReplyVer15(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("connections=").append(this.connections);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnControllerConnectionsReplyVer15 other = (OFBsnControllerConnectionsReplyVer15)obj;
        if (this.xid != other.xid) {
            return false;
        }
        return !(this.connections == null ? other.connections != null : !this.connections.equals(other.connections));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnControllerConnectionsReplyVer15 other = (OFBsnControllerConnectionsReplyVer15)obj;
        return !(this.connections == null ? other.connections != null : !this.connections.equals(other.connections));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.connections == null ? 0 : this.connections.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.connections == null ? 0 : this.connections.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnControllerConnectionsReplyVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnControllerConnectionsReplyVer15 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(6);
            bb.writeByte(4);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(57);
            ChannelUtils.writeList(bb, message.connections);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFBsnControllerConnectionsReplyVer15Funnel
    implements Funnel<OFBsnControllerConnectionsReplyVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnControllerConnectionsReplyVer15Funnel() {
        }

        public void funnel(OFBsnControllerConnectionsReplyVer15 message, PrimitiveSink sink) {
            sink.putByte((byte)6);
            sink.putByte((byte)4);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(57);
            FunnelUtils.putList(message.connections, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnControllerConnectionsReply> {
        Reader() {
        }

        @Override
        public OFBsnControllerConnectionsReply readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 6) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 57) {
                throw new OFParseError("Wrong subtype: Expected=0x39L(0x39L), got=" + subtype);
            }
            List<OFBsnControllerConnection> connections = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFBsnControllerConnectionVer15.READER);
            OFBsnControllerConnectionsReplyVer15 bsnControllerConnectionsReplyVer15 = new OFBsnControllerConnectionsReplyVer15(xid, connections);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnControllerConnectionsReplyVer15);
            }
            return bsnControllerConnectionsReplyVer15;
        }
    }

    static class Builder
    implements OFBsnControllerConnectionsReply.Builder {
        private boolean xidSet;
        private long xid;
        private boolean connectionsSet;
        private List<OFBsnControllerConnection> connections;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnControllerConnectionsReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 57L;
        }

        @Override
        public List<OFBsnControllerConnection> getConnections() {
            return this.connections;
        }

        @Override
        public OFBsnControllerConnectionsReply.Builder setConnections(List<OFBsnControllerConnection> connections) {
            this.connections = connections;
            this.connectionsSet = true;
            return this;
        }

        @Override
        public OFBsnControllerConnectionsReply build() {
            List<OFBsnControllerConnection> connections;
            long xid = this.xidSet ? this.xid : 0L;
            List<OFBsnControllerConnection> list = connections = this.connectionsSet ? this.connections : DEFAULT_CONNECTIONS;
            if (connections == null) {
                throw new NullPointerException("Property connections must not be null");
            }
            return new OFBsnControllerConnectionsReplyVer15(xid, connections);
        }
    }

    static class BuilderWithParent
    implements OFBsnControllerConnectionsReply.Builder {
        final OFBsnControllerConnectionsReplyVer15 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean connectionsSet;
        private List<OFBsnControllerConnection> connections;

        BuilderWithParent(OFBsnControllerConnectionsReplyVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnControllerConnectionsReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 57L;
        }

        @Override
        public List<OFBsnControllerConnection> getConnections() {
            return this.connections;
        }

        @Override
        public OFBsnControllerConnectionsReply.Builder setConnections(List<OFBsnControllerConnection> connections) {
            this.connections = connections;
            this.connectionsSet = true;
            return this;
        }

        @Override
        public OFBsnControllerConnectionsReply build() {
            List connections;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            List list = connections = this.connectionsSet ? this.connections : this.parentMessage.connections;
            if (connections == null) {
                throw new NullPointerException("Property connections must not be null");
            }
            return new OFBsnControllerConnectionsReplyVer15(xid, connections);
        }
    }
}

