/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFAsyncConfigPropTableStatusSlave;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFAsyncConfigPropTableStatusSlaveVer15
implements OFAsyncConfigPropTableStatusSlave {
    private static final Logger logger = LoggerFactory.getLogger(OFAsyncConfigPropTableStatusSlaveVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 8;
    private static final long DEFAULT_MASK = 0L;
    private final long mask;
    static final OFAsyncConfigPropTableStatusSlaveVer15 DEFAULT = new OFAsyncConfigPropTableStatusSlaveVer15(0L);
    static final Reader READER = new Reader();
    static final OFAsyncConfigPropTableStatusSlaveVer15Funnel FUNNEL = new OFAsyncConfigPropTableStatusSlaveVer15Funnel();
    static final Writer WRITER = new Writer();

    OFAsyncConfigPropTableStatusSlaveVer15(long mask) {
        this.mask = mask;
    }

    @Override
    public int getType() {
        return 8;
    }

    @Override
    public long getMask() {
        return this.mask;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFAsyncConfigPropTableStatusSlave.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFAsyncConfigPropTableStatusSlaveVer15(");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFAsyncConfigPropTableStatusSlaveVer15 other = (OFAsyncConfigPropTableStatusSlaveVer15)obj;
        return this.mask == other.mask;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.mask ^ this.mask >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFAsyncConfigPropTableStatusSlaveVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFAsyncConfigPropTableStatusSlaveVer15 message) {
            bb.writeShort(8);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.mask));
        }
    }

    static class OFAsyncConfigPropTableStatusSlaveVer15Funnel
    implements Funnel<OFAsyncConfigPropTableStatusSlaveVer15> {
        private static final long serialVersionUID = 1L;

        OFAsyncConfigPropTableStatusSlaveVer15Funnel() {
        }

        public void funnel(OFAsyncConfigPropTableStatusSlaveVer15 message, PrimitiveSink sink) {
            sink.putShort((short)8);
            sink.putShort((short)8);
            sink.putLong(message.mask);
        }
    }

    static class Reader
    implements OFMessageReader<OFAsyncConfigPropTableStatusSlave> {
        Reader() {
        }

        @Override
        public OFAsyncConfigPropTableStatusSlave readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 8) {
                throw new OFParseError("Wrong type: Expected=0x8(0x8), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long mask = U32.f(bb.readInt());
            OFAsyncConfigPropTableStatusSlaveVer15 asyncConfigPropTableStatusSlaveVer15 = new OFAsyncConfigPropTableStatusSlaveVer15(mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)asyncConfigPropTableStatusSlaveVer15);
            }
            return asyncConfigPropTableStatusSlaveVer15;
        }
    }

    static class Builder
    implements OFAsyncConfigPropTableStatusSlave.Builder {
        private boolean maskSet;
        private long mask;

        Builder() {
        }

        @Override
        public int getType() {
            return 8;
        }

        @Override
        public long getMask() {
            return this.mask;
        }

        @Override
        public OFAsyncConfigPropTableStatusSlave.Builder setMask(long mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFAsyncConfigPropTableStatusSlave build() {
            long mask = this.maskSet ? this.mask : 0L;
            return new OFAsyncConfigPropTableStatusSlaveVer15(mask);
        }
    }

    static class BuilderWithParent
    implements OFAsyncConfigPropTableStatusSlave.Builder {
        final OFAsyncConfigPropTableStatusSlaveVer15 parentMessage;
        private boolean maskSet;
        private long mask;

        BuilderWithParent(OFAsyncConfigPropTableStatusSlaveVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 8;
        }

        @Override
        public long getMask() {
            return this.mask;
        }

        @Override
        public OFAsyncConfigPropTableStatusSlave.Builder setMask(long mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFAsyncConfigPropTableStatusSlave build() {
            long mask = this.maskSet ? this.mask : this.parentMessage.mask;
            return new OFAsyncConfigPropTableStatusSlaveVer15(mask);
        }
    }
}

