/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionSetQueue;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionSetQueueVer15
implements OFActionSetQueue {
    private static final Logger logger = LoggerFactory.getLogger(OFActionSetQueueVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 8;
    private static final long DEFAULT_QUEUE_ID = 0L;
    private final long queueId;
    static final OFActionSetQueueVer15 DEFAULT = new OFActionSetQueueVer15(0L);
    static final Reader READER = new Reader();
    static final OFActionSetQueueVer15Funnel FUNNEL = new OFActionSetQueueVer15Funnel();
    static final Writer WRITER = new Writer();

    OFActionSetQueueVer15(long queueId) {
        this.queueId = queueId;
    }

    @Override
    public OFActionType getType() {
        return OFActionType.SET_QUEUE;
    }

    @Override
    public long getQueueId() {
        return this.queueId;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFActionSetQueue.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionSetQueueVer15(");
        b.append("queueId=").append(this.queueId);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFActionSetQueueVer15 other = (OFActionSetQueueVer15)obj;
        return this.queueId == other.queueId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.queueId ^ this.queueId >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionSetQueueVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFActionSetQueueVer15 message) {
            bb.writeShort(21);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.queueId));
        }
    }

    static class OFActionSetQueueVer15Funnel
    implements Funnel<OFActionSetQueueVer15> {
        private static final long serialVersionUID = 1L;

        OFActionSetQueueVer15Funnel() {
        }

        public void funnel(OFActionSetQueueVer15 message, PrimitiveSink sink) {
            sink.putShort((short)21);
            sink.putShort((short)8);
            sink.putLong(message.queueId);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionSetQueue> {
        Reader() {
        }

        @Override
        public OFActionSetQueue readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 21) {
                throw new OFParseError("Wrong type: Expected=OFActionType.SET_QUEUE(21), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long queueId = U32.f(bb.readInt());
            OFActionSetQueueVer15 actionSetQueueVer15 = new OFActionSetQueueVer15(queueId);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)actionSetQueueVer15);
            }
            return actionSetQueueVer15;
        }
    }

    static class Builder
    implements OFActionSetQueue.Builder {
        private boolean queueIdSet;
        private long queueId;

        Builder() {
        }

        @Override
        public OFActionType getType() {
            return OFActionType.SET_QUEUE;
        }

        @Override
        public long getQueueId() {
            return this.queueId;
        }

        @Override
        public OFActionSetQueue.Builder setQueueId(long queueId) {
            this.queueId = queueId;
            this.queueIdSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFActionSetQueue build() {
            long queueId = this.queueIdSet ? this.queueId : 0L;
            return new OFActionSetQueueVer15(queueId);
        }
    }

    static class BuilderWithParent
    implements OFActionSetQueue.Builder {
        final OFActionSetQueueVer15 parentMessage;
        private boolean queueIdSet;
        private long queueId;

        BuilderWithParent(OFActionSetQueueVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFActionType getType() {
            return OFActionType.SET_QUEUE;
        }

        @Override
        public long getQueueId() {
            return this.queueId;
        }

        @Override
        public OFActionSetQueue.Builder setQueueId(long queueId) {
            this.queueId = queueId;
            this.queueIdSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFActionSetQueue build() {
            long queueId = this.queueIdSet ? this.queueId : this.parentMessage.queueId;
            return new OFActionSetQueueVer15(queueId);
        }
    }
}

