/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionCopyField;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFOxmList;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver15.OFOxmVer15;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionCopyFieldVer15
implements OFActionCopyField {
    private static final Logger logger = LoggerFactory.getLogger(OFActionCopyFieldVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 12;
    private static final int DEFAULT_N_BITS = 0;
    private static final int DEFAULT_SRC_OFFSET = 0;
    private static final int DEFAULT_DST_OFFSET = 0;
    private static final OFOxmList DEFAULT_OXM_IDS = OFOxmList.EMPTY;
    private final int nBits;
    private final int srcOffset;
    private final int dstOffset;
    private final OFOxmList oxmIds;
    static final OFActionCopyFieldVer15 DEFAULT = new OFActionCopyFieldVer15(0, 0, 0, DEFAULT_OXM_IDS);
    static final Reader READER = new Reader();
    static final OFActionCopyFieldVer15Funnel FUNNEL = new OFActionCopyFieldVer15Funnel();
    static final Writer WRITER = new Writer();

    OFActionCopyFieldVer15(int nBits, int srcOffset, int dstOffset, OFOxmList oxmIds) {
        if (oxmIds == null) {
            throw new NullPointerException("OFActionCopyFieldVer15: property oxmIds cannot be null");
        }
        this.nBits = nBits;
        this.srcOffset = srcOffset;
        this.dstOffset = dstOffset;
        this.oxmIds = oxmIds;
    }

    @Override
    public int getType() {
        return 28;
    }

    @Override
    public int getNBits() {
        return this.nBits;
    }

    @Override
    public int getSrcOffset() {
        return this.srcOffset;
    }

    @Override
    public int getDstOffset() {
        return this.dstOffset;
    }

    @Override
    public OFOxmList getOxmIds() {
        return this.oxmIds;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFActionCopyField.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionCopyFieldVer15(");
        b.append("nBits=").append(this.nBits);
        b.append(", ");
        b.append("srcOffset=").append(this.srcOffset);
        b.append(", ");
        b.append("dstOffset=").append(this.dstOffset);
        b.append(", ");
        b.append("oxmIds=").append(this.oxmIds);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFActionCopyFieldVer15 other = (OFActionCopyFieldVer15)obj;
        if (this.nBits != other.nBits) {
            return false;
        }
        if (this.srcOffset != other.srcOffset) {
            return false;
        }
        if (this.dstOffset != other.dstOffset) {
            return false;
        }
        return !(this.oxmIds == null ? other.oxmIds != null : !this.oxmIds.equals(other.oxmIds));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.nBits;
        result = 31 * result + this.srcOffset;
        result = 31 * result + this.dstOffset;
        result = 31 * result + (this.oxmIds == null ? 0 : this.oxmIds.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionCopyFieldVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFActionCopyFieldVer15 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(28);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeShort((int)U16.t(message.nBits));
            bb.writeShort((int)U16.t(message.srcOffset));
            bb.writeShort((int)U16.t(message.dstOffset));
            bb.writeZero(2);
            message.oxmIds.writeTo(bb);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFActionCopyFieldVer15Funnel
    implements Funnel<OFActionCopyFieldVer15> {
        private static final long serialVersionUID = 1L;

        OFActionCopyFieldVer15Funnel() {
        }

        public void funnel(OFActionCopyFieldVer15 message, PrimitiveSink sink) {
            sink.putShort((short)28);
            sink.putInt(message.nBits);
            sink.putInt(message.srcOffset);
            sink.putInt(message.dstOffset);
            message.oxmIds.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionCopyField> {
        Reader() {
        }

        @Override
        public OFActionCopyField readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 28) {
                throw new OFParseError("Wrong type: Expected=0x1c(0x1c), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 12) {
                throw new OFParseError("Wrong length: Expected to be >= 12, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            int nBits = U16.f(bb.readShort());
            int srcOffset = U16.f(bb.readShort());
            int dstOffset = U16.f(bb.readShort());
            bb.skipBytes(2);
            OFOxmList oxmIds = OFOxmList.readFrom(bb, length - (bb.readerIndex() - start), OFOxmVer15.READER);
            OFActionCopyFieldVer15 actionCopyFieldVer15 = new OFActionCopyFieldVer15(nBits, srcOffset, dstOffset, oxmIds);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)actionCopyFieldVer15);
            }
            return actionCopyFieldVer15;
        }
    }

    static class Builder
    implements OFActionCopyField.Builder {
        private boolean nBitsSet;
        private int nBits;
        private boolean srcOffsetSet;
        private int srcOffset;
        private boolean dstOffsetSet;
        private int dstOffset;
        private boolean oxmIdsSet;
        private OFOxmList oxmIds;

        Builder() {
        }

        @Override
        public int getType() {
            return 28;
        }

        @Override
        public int getNBits() {
            return this.nBits;
        }

        @Override
        public OFActionCopyField.Builder setNBits(int nBits) {
            this.nBits = nBits;
            this.nBitsSet = true;
            return this;
        }

        @Override
        public int getSrcOffset() {
            return this.srcOffset;
        }

        @Override
        public OFActionCopyField.Builder setSrcOffset(int srcOffset) {
            this.srcOffset = srcOffset;
            this.srcOffsetSet = true;
            return this;
        }

        @Override
        public int getDstOffset() {
            return this.dstOffset;
        }

        @Override
        public OFActionCopyField.Builder setDstOffset(int dstOffset) {
            this.dstOffset = dstOffset;
            this.dstOffsetSet = true;
            return this;
        }

        @Override
        public OFOxmList getOxmIds() {
            return this.oxmIds;
        }

        @Override
        public OFActionCopyField.Builder setOxmIds(OFOxmList oxmIds) {
            this.oxmIds = oxmIds;
            this.oxmIdsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFActionCopyField build() {
            OFOxmList oxmIds;
            int nBits = this.nBitsSet ? this.nBits : 0;
            int srcOffset = this.srcOffsetSet ? this.srcOffset : 0;
            int dstOffset = this.dstOffsetSet ? this.dstOffset : 0;
            OFOxmList oFOxmList = oxmIds = this.oxmIdsSet ? this.oxmIds : DEFAULT_OXM_IDS;
            if (oxmIds == null) {
                throw new NullPointerException("Property oxmIds must not be null");
            }
            return new OFActionCopyFieldVer15(nBits, srcOffset, dstOffset, oxmIds);
        }
    }

    static class BuilderWithParent
    implements OFActionCopyField.Builder {
        final OFActionCopyFieldVer15 parentMessage;
        private boolean nBitsSet;
        private int nBits;
        private boolean srcOffsetSet;
        private int srcOffset;
        private boolean dstOffsetSet;
        private int dstOffset;
        private boolean oxmIdsSet;
        private OFOxmList oxmIds;

        BuilderWithParent(OFActionCopyFieldVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 28;
        }

        @Override
        public int getNBits() {
            return this.nBits;
        }

        @Override
        public OFActionCopyField.Builder setNBits(int nBits) {
            this.nBits = nBits;
            this.nBitsSet = true;
            return this;
        }

        @Override
        public int getSrcOffset() {
            return this.srcOffset;
        }

        @Override
        public OFActionCopyField.Builder setSrcOffset(int srcOffset) {
            this.srcOffset = srcOffset;
            this.srcOffsetSet = true;
            return this;
        }

        @Override
        public int getDstOffset() {
            return this.dstOffset;
        }

        @Override
        public OFActionCopyField.Builder setDstOffset(int dstOffset) {
            this.dstOffset = dstOffset;
            this.dstOffsetSet = true;
            return this;
        }

        @Override
        public OFOxmList getOxmIds() {
            return this.oxmIds;
        }

        @Override
        public OFActionCopyField.Builder setOxmIds(OFOxmList oxmIds) {
            this.oxmIds = oxmIds;
            this.oxmIdsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFActionCopyField build() {
            OFOxmList oxmIds;
            int nBits = this.nBitsSet ? this.nBits : this.parentMessage.nBits;
            int srcOffset = this.srcOffsetSet ? this.srcOffset : this.parentMessage.srcOffset;
            int dstOffset = this.dstOffsetSet ? this.dstOffset : this.parentMessage.dstOffset;
            OFOxmList oFOxmList = oxmIds = this.oxmIdsSet ? this.oxmIds : this.parentMessage.oxmIds;
            if (oxmIds == null) {
                throw new NullPointerException("Property oxmIds must not be null");
            }
            return new OFActionCopyFieldVer15(nBits, srcOffset, dstOffset, oxmIds);
        }
    }
}

