/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmBsnVxlanNetworkId;
import org.projectfloodlight.openflow.types.VxlanNI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmBsnVxlanNetworkIdVer14
implements OFOxmBsnVxlanNetworkId {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmBsnVxlanNetworkIdVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 8;
    private static final VxlanNI DEFAULT_VALUE = VxlanNI.ZERO;
    private final VxlanNI value;
    static final OFOxmBsnVxlanNetworkIdVer14 DEFAULT = new OFOxmBsnVxlanNetworkIdVer14(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmBsnVxlanNetworkIdVer14Funnel FUNNEL = new OFOxmBsnVxlanNetworkIdVer14Funnel();
    static final Writer WRITER = new Writer();

    OFOxmBsnVxlanNetworkIdVer14(VxlanNI value) {
        if (value == null) {
            throw new NullPointerException("OFOxmBsnVxlanNetworkIdVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 207364L;
    }

    @Override
    public VxlanNI getValue() {
        return this.value;
    }

    @Override
    public MatchField<VxlanNI> getMatchField() {
        return MatchField.BSN_VXLAN_NETWORK_ID;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<VxlanNI> getCanonical() {
        return this;
    }

    @Override
    public VxlanNI getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.4");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFOxmBsnVxlanNetworkId.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmBsnVxlanNetworkIdVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmBsnVxlanNetworkIdVer14 other = (OFOxmBsnVxlanNetworkIdVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmBsnVxlanNetworkIdVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmBsnVxlanNetworkIdVer14 message) {
            bb.writeInt(207364);
            message.value.write4Bytes(bb);
        }
    }

    static class OFOxmBsnVxlanNetworkIdVer14Funnel
    implements Funnel<OFOxmBsnVxlanNetworkIdVer14> {
        private static final long serialVersionUID = 1L;

        OFOxmBsnVxlanNetworkIdVer14Funnel() {
        }

        public void funnel(OFOxmBsnVxlanNetworkIdVer14 message, PrimitiveSink sink) {
            sink.putInt(207364);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmBsnVxlanNetworkId> {
        Reader() {
        }

        @Override
        public OFOxmBsnVxlanNetworkId readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 207364) {
                throw new OFParseError("Wrong typeLen: Expected=0x32a04L(0x32a04L), got=" + typeLen);
            }
            VxlanNI value = VxlanNI.read4Bytes(bb);
            OFOxmBsnVxlanNetworkIdVer14 oxmBsnVxlanNetworkIdVer14 = new OFOxmBsnVxlanNetworkIdVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmBsnVxlanNetworkIdVer14);
            }
            return oxmBsnVxlanNetworkIdVer14;
        }
    }

    static class Builder
    implements OFOxmBsnVxlanNetworkId.Builder {
        private boolean valueSet;
        private VxlanNI value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 207364L;
        }

        @Override
        public VxlanNI getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnVxlanNetworkId.Builder setValue(VxlanNI value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<VxlanNI> getMatchField() {
            return MatchField.BSN_VXLAN_NETWORK_ID;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<VxlanNI> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public VxlanNI getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmBsnVxlanNetworkId build() {
            VxlanNI value;
            VxlanNI vxlanNI = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmBsnVxlanNetworkIdVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmBsnVxlanNetworkId.Builder {
        final OFOxmBsnVxlanNetworkIdVer14 parentMessage;
        private boolean valueSet;
        private VxlanNI value;

        BuilderWithParent(OFOxmBsnVxlanNetworkIdVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 207364L;
        }

        @Override
        public VxlanNI getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnVxlanNetworkId.Builder setValue(VxlanNI value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<VxlanNI> getMatchField() {
            return MatchField.BSN_VXLAN_NETWORK_ID;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<VxlanNI> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public VxlanNI getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmBsnVxlanNetworkId build() {
            VxlanNI value;
            VxlanNI vxlanNI = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmBsnVxlanNetworkIdVer14(value);
        }
    }
}

